/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.cvstore;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.cvstore.CoverageStoreSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"add"}, parentOperation=CoverageStoreSection.class)
@Parameters(commandDescription="Add a GeoServer coverage store")
public class GeoServerAddCoverageStoreCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace = null;
    @Parameter(names={"-cs", "--coverageStore"}, required=false, description="coverage store name")
    private String coverageStore = null;
    @Parameter(names={"-histo", "--equalizeHistogramOverride"}, required=false, description="This parameter will override the behavior to always perform histogram equalization if a histogram exists.  Valid values are true and false.", arity=1)
    private Boolean equalizeHistogramOverride = null;
    @Parameter(names={"-interp", "--interpolationOverride"}, required=false, description="This will override the default interpolation stored for each layer.  Valid values are 0, 1, 2, 3 for NearestNeighbor, Bilinear, Bicubic, and Bicubic (polynomial variant) resepctively. ")
    private String interpolationOverride = null;
    @Parameter(names={"-scale", "--scaleTo8Bit"}, required=false, description="By default, integer values will automatically be scaled to 8-bit and floating point values will not.  This can be overridden setting this value to true or false.", arity=1)
    private Boolean scaleTo8Bit = null;
    @Parameter(description="<GeoWave store name>")
    private List<String> parameters = new ArrayList<String>();
    private String gwStore = null;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        Response addStoreResponse;
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <GeoWave store name>");
        }
        this.gwStore = this.parameters.get(0);
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        if ((addStoreResponse = this.geoserverClient.addCoverageStore(this.workspace, this.coverageStore, this.gwStore, this.equalizeHistogramOverride, this.interpolationOverride, this.scaleTo8Bit)).getStatus() == Response.Status.OK.getStatusCode() || addStoreResponse.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return "Add coverage store for '" + this.gwStore + "' to workspace '" + this.workspace + "' on GeoServer: OK";
        }
        String errorMessage = "Error adding coverage store for '" + this.gwStore + "' to workspace '" + this.workspace + "' on GeoServer: " + (String)addStoreResponse.readEntity(String.class) + "\nGeoServer Response Code = " + addStoreResponse.getStatus();
        return (String)this.handleError(addStoreResponse, errorMessage);
    }
}

