/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.cvstore;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.cvstore.CoverageStoreSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"list"}, parentOperation=CoverageStoreSection.class)
@Parameters(commandDescription="List GeoServer coverage stores")
public class GeoServerListCoverageStoresCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace;

    public void execute(OperationParams params) throws Exception {
        JCommander.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        Response listCvgStoresResponse;
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        if ((listCvgStoresResponse = this.geoserverClient.getCoverageStores(this.workspace)).getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)listCvgStoresResponse.getEntity());
            JSONArray cvgStores = jsonResponse.getJSONArray("coverageStores");
            return "\nGeoServer coverage stores list for '" + this.workspace + "': " + cvgStores.toString(2);
        }
        String errorMessage = "Error getting GeoServer coverage stores list for '" + this.workspace + "': " + (String)listCvgStoresResponse.readEntity(String.class) + "\nGeoServer Response Code = " + listCvgStoresResponse.getStatus();
        return (String)this.handleError(listCvgStoresResponse, errorMessage);
    }
}

