/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.internal.Console;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Properties;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.operations.config.security.utils.SecurityUtils;
import org.locationtech.geowave.core.cli.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoServerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoServerConfig.class);
    public static final String DEFAULT_URL = "localhost:8080";
    public static final String DEFAULT_USER = "admin";
    public static final String DEFAULT_PASS = "geoserver";
    public static final String DEFAULT_WORKSPACE = "geowave";
    public static final String DEFAULT_CS = "-raster";
    public static final String DEFAULT_DS = "-vector";
    public static final String DISPLAY_NAME_PREFIX = "GeoWave Datastore - ";
    public static final String QUERY_INDEX_STRATEGY_KEY = "Query Index Strategy";
    private String url = null;
    private String user = null;
    private String pass = null;
    private String workspace = null;
    private final File propFile;
    private final Properties gsConfigProperties;

    public GeoServerConfig(File propFile, Console console) {
        this.propFile = propFile;
        this.gsConfigProperties = propFile != null && propFile.exists() ? ConfigOptions.loadProperties((File)propFile) : new Properties();
        boolean update = false;
        this.url = this.gsConfigProperties.getProperty("geoserver.url");
        if (this.url == null) {
            this.url = DEFAULT_URL;
            this.gsConfigProperties.setProperty("geoserver.url", this.url);
            update = true;
        }
        this.user = this.gsConfigProperties.getProperty("geoserver.user");
        if (this.user == null) {
            this.user = DEFAULT_USER;
            this.gsConfigProperties.setProperty("geoserver.user", this.user);
            update = true;
        }
        this.pass = this.gsConfigProperties.getProperty("geoserver.pass");
        if (this.pass == null) {
            this.pass = DEFAULT_PASS;
            this.gsConfigProperties.setProperty("geoserver.pass", this.pass);
            update = true;
        } else {
            try {
                File resourceTokenFile = SecurityUtils.getFormattedTokenKeyFileForConfig((File)propFile);
                this.pass = SecurityUtils.decryptHexEncodedValue((String)this.pass, (String)resourceTokenFile.getCanonicalPath(), (Console)console);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred decrypting password: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.workspace = this.gsConfigProperties.getProperty("geoserver.workspace");
        if (this.workspace == null) {
            this.workspace = DEFAULT_WORKSPACE;
            this.gsConfigProperties.setProperty("geoserver.workspace", this.workspace);
            update = true;
        }
        if (update) {
            ConfigOptions.writeProperties((File)propFile, (Properties)this.gsConfigProperties, (Console)console);
            LOGGER.info("GeoServer Config Saved");
        }
    }

    public GeoServerConfig(Console console) {
        this(ConfigOptions.getDefaultPropertyFile((Console)console), console);
    }

    public String getUrl() {
        String internalUrl = !this.url.contains("//") ? this.url + "/geoserver" : this.url;
        try {
            return URLUtils.getUrl((String)internalUrl);
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.error("Error discovered in validating specified url: " + e.getLocalizedMessage(), (Throwable)e);
            return internalUrl;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public File getPropFile() {
        return this.propFile;
    }

    public Properties getGsConfigProperties() {
        return this.gsConfigProperties;
    }
}

