/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Properties;
import org.locationtech.geowave.cli.geoserver.SSLOptionAnnotation;
import org.locationtech.geowave.core.cli.converters.OptionalPasswordConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StoreSSLConfigurationOptions {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreSSLConfigurationOptions.class);
    private final String configPrefix;
    @SSLOptionAnnotation(propertyBaseName="ssl.security.protocol")
    @Parameter(names={"--sslSecurityProtocol"}, description="Specify the Transport Layer Security (TLS) protocol to use when connecting to the server. By default, the system will use TLS.")
    protected String sslSecurityProtocol;
    @SSLOptionAnnotation(propertyBaseName="ssl.trustStore")
    @Parameter(names={"--sslTrustStorePath"}, description="Specify the absolute path to where truststore file is located on system. The truststore file is used to validate client certificates.")
    protected String sslTrustStorePath;
    @SSLOptionAnnotation(propertyBaseName="ssl.trustStorePassword")
    @Parameter(names={"--sslTrustStorePassword"}, description="Specify the password to use to access the truststore file. - Can be specified as 'pass:<password>', 'file:<local file containing the password>', 'propfile:<local properties file containing the password>:<property file key>', 'env:<variable containing the pass>', or stdin", converter=OptionalPasswordConverter.class)
    protected String sslTrustStorePassword;
    @SSLOptionAnnotation(propertyBaseName="ssl.trustStoreType")
    @Parameter(names={"--sslTrustStoreType"}, description="Specify the type of key store used for the truststore, i.e. JKS (Java KeyStore).")
    protected String sslTrustStoreType;
    @SSLOptionAnnotation(propertyBaseName="ssl.trustStoreProvider")
    @Parameter(names={"--sslTrustStoreProvider"}, description="Specify the name of the truststore provider to be used for the server certificate.")
    protected String sslTrustStoreProvider;
    @SSLOptionAnnotation(propertyBaseName="ssl.trustStoreMgrFactoryAlgorithm")
    @Parameter(names={"--sslTrustManagerAlgorithm"}, description="Specify the algorithm to use for the truststore.")
    protected String sslTrustManagerAlgorithm;
    @SSLOptionAnnotation(propertyBaseName="ssl.trustStoreMgrFactoryProvider")
    @Parameter(names={"--sslTrustManagerProvider"}, description="Specify the trust manager factory provider.")
    protected String sslTrustManagerProvider;
    @SSLOptionAnnotation(propertyBaseName="ssl.keyStore")
    @Parameter(names={"--sslKeyStorePath"}, description="Specify the absolute path to where the keystore file is located on system. The keystore contains the server certificate to be loaded.")
    protected String sslKeyStorePath;
    @SSLOptionAnnotation(propertyBaseName="ssl.keyStorePassword")
    @Parameter(names={"--sslKeyStorePassword"}, description="Specify the password to use to access the keystore file. - Can be specified as 'pass:<password>', 'file:<local file containing the password>', 'propfile:<local properties file containing the password>:<property file key>', 'env:<variable containing the pass>', or stdin", converter=OptionalPasswordConverter.class)
    protected String sslKeyStorePassword;
    @SSLOptionAnnotation(propertyBaseName="ssl.keyStoreProvider")
    @Parameter(names={"--sslKeyStoreProvider"}, description="Specify the name of the keystore provider to be used for the server certificate.")
    protected String sslKeyStoreProvider;
    @SSLOptionAnnotation(propertyBaseName="ssl.keyPassword")
    @Parameter(names={"--sslKeyPassword"}, description="Specify the password to be used to access the server certificate from the specified keystore file. - Can be specified as 'pass:<password>', 'file:<local file containing the password>', 'propfile:<local properties file containing the password>:<property file key>', 'env:<variable containing the pass>', or stdin", converter=OptionalPasswordConverter.class)
    protected String sslKeyPassword;
    @SSLOptionAnnotation(propertyBaseName="ssl.keyStoreType")
    @Parameter(names={"--sslKeyStoreType"}, description="The type of keystore file to be used for the server certificate.")
    protected String sslKeyStoreType;
    @SSLOptionAnnotation(propertyBaseName="ssl.keyMgrFactoryAlgorithm")
    @Parameter(names={"--sslKeyManagerAlgorithm"}, description="Specify the algorithm to use for the keystore.")
    protected String sslKeyManagerAlgorithm;
    @SSLOptionAnnotation(propertyBaseName="ssl.keyMgrFactoryProvider")
    @Parameter(names={"--sslKeyManagerProvider"}, description="Specify the key manager factory provider.")
    protected String sslKeyManagerProvider;

    public StoreSSLConfigurationOptions(String configPrefix) {
        this.configPrefix = configPrefix;
    }

    public String getSslSecurityProtocol() {
        return this.sslSecurityProtocol;
    }

    public void setSslSecurityProtocol(String sslSecurityProtocol) {
        this.sslSecurityProtocol = sslSecurityProtocol;
    }

    public String getSslTrustStorePath() {
        return this.sslTrustStorePath;
    }

    public void setSslTrustStorePath(String sslTrustStorePath) {
        this.sslTrustStorePath = sslTrustStorePath;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    public void setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
    }

    public String getSslTrustStoreType() {
        return this.sslTrustStoreType;
    }

    public void setSslTrustStoreType(String sslTrustStoreType) {
        this.sslTrustStoreType = sslTrustStoreType;
    }

    public String getSslTrustStoreProvider() {
        return this.sslTrustStoreProvider;
    }

    public void setSslTrustStoreProvider(String sslTrustStoreProvider) {
        this.sslTrustStoreProvider = sslTrustStoreProvider;
    }

    public String getSslTrustManagerAlgorithm() {
        return this.sslTrustManagerAlgorithm;
    }

    public void setSslTrustManagerAlgorithm(String sslTrustManagerAlgorithm) {
        this.sslTrustManagerAlgorithm = sslTrustManagerAlgorithm;
    }

    public String getSslTrustManagerProvider() {
        return this.sslTrustManagerProvider;
    }

    public void setSslTrustManagerProvider(String sslTrustManagerProvider) {
        this.sslTrustManagerProvider = sslTrustManagerProvider;
    }

    public String getSslKeyStorePath() {
        return this.sslKeyStorePath;
    }

    public void setSslKeyStorePath(String sslKeyStorePath) {
        this.sslKeyStorePath = sslKeyStorePath;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    public void setSslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
    }

    public String getSslKeyStoreProvider() {
        return this.sslKeyStoreProvider;
    }

    public void setSslKeyStoreProvider(String sslKeyStoreProvider) {
        this.sslKeyStoreProvider = sslKeyStoreProvider;
    }

    public String getSslKeyPassword() {
        return this.sslKeyPassword;
    }

    public void setSslKeyPassword(String sslKeyPassword) {
        this.sslKeyPassword = sslKeyPassword;
    }

    public String getSslKeyStoreType() {
        return this.sslKeyStoreType;
    }

    public void setSslKeyStoreType(String sslKeyStoreType) {
        this.sslKeyStoreType = sslKeyStoreType;
    }

    public String getSslKeyManagerAlgorithm() {
        return this.sslKeyManagerAlgorithm;
    }

    public void setSslKeyManagerAlgorithm(String sslKeyManagerAlgorithm) {
        this.sslKeyManagerAlgorithm = sslKeyManagerAlgorithm;
    }

    public String getSslKeyManagerProvider() {
        return this.sslKeyManagerProvider;
    }

    public void setSslKeyManagerProvider(String sslKeyManagerProvider) {
        this.sslKeyManagerProvider = sslKeyManagerProvider;
    }

    public boolean saveProperties(Properties existingProps) {
        boolean updated = false;
        Field[] fields = StoreSSLConfigurationOptions.class.getDeclaredFields();
        if (fields != null && fields.length != 0) {
            for (Field field : fields) {
                Annotation[] annotations;
                field.setAccessible(true);
                for (Annotation annotation : annotations = field.getAnnotations()) {
                    if (!(annotation instanceof SSLOptionAnnotation)) continue;
                    SSLOptionAnnotation sslOptionAnnotation = (SSLOptionAnnotation)annotation;
                    Object value = null;
                    try {
                        value = field.get(this);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                    if (value == null || sslOptionAnnotation.propertyBaseName() == null) continue;
                    String propertyKey = String.format("%s.%s", this.configPrefix, sslOptionAnnotation.propertyBaseName());
                    existingProps.put(propertyKey, value);
                    updated = true;
                }
            }
        }
        return updated;
    }
}

