/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.featurelayer;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.featurelayer.FeatureLayerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"list"}, parentOperation=FeatureLayerSection.class)
@Parameters(commandDescription="List GeoServer feature layers")
public class GeoServerListFeatureLayersCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="Workspace Name")
    private String workspace = null;
    @Parameter(names={"-ds", "--datastore"}, required=false, description="Datastore Name")
    private String datastore = null;
    @Parameter(names={"-g", "--geowaveOnly"}, required=false, description="Show only GeoWave feature layers (default: false)")
    private Boolean geowaveOnly = false;

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public void setGeowaveOnly(Boolean geowaveOnly) {
        this.geowaveOnly = geowaveOnly;
    }

    public void execute(OperationParams params) throws Exception {
        params.getConsole().println(this.computeResults(params));
    }

    public void setDatastore(String datastore) {
        this.datastore = datastore;
    }

    public String computeResults(OperationParams params) throws Exception {
        Response listLayersResponse = this.geoserverClient.getFeatureLayers(this.workspace, this.datastore, this.geowaveOnly);
        if (listLayersResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject listObj = JSONObject.fromObject((Object)listLayersResponse.getEntity());
            return "\nGeoServer layer list: " + listObj.toString(2);
        }
        String errorMessage = "Error getting GeoServer layer list: " + (String)listLayersResponse.readEntity(String.class) + "\nGeoServer Response Code = " + listLayersResponse.getStatus();
        return (String)this.handleError(listLayersResponse, errorMessage);
    }
}

