/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.featurelayer;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerRemoveCommand;
import org.locationtech.geowave.cli.geoserver.featurelayer.FeatureLayerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"rm"}, parentOperation=FeatureLayerSection.class)
@Parameters(commandDescription="Remove GeoServer feature Layer")
public class GeoServerRemoveFeatureLayerCommand
extends GeoServerRemoveCommand<String> {
    @Parameter(description="<layer name>")
    private List<String> parameters = new ArrayList<String>();
    private String layerName = null;

    public void execute(OperationParams params) throws Exception {
        params.getConsole().println(this.computeResults(params));
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <layer name>");
        }
        this.layerName = this.parameters.get(0);
        Response deleteLayerResponse = this.geoserverClient.deleteFeatureLayer(this.layerName);
        if (deleteLayerResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject listObj = JSONObject.fromObject((Object)deleteLayerResponse.getEntity());
            return "\nGeoServer delete layer response " + this.layerName + ": " + listObj.toString(2);
        }
        String errorMessage = "Error deleting GeoServer layer '" + this.layerName + "': " + (String)deleteLayerResponse.readEntity(String.class) + "\nGeoServer Response Code = " + deleteLayerResponse.getStatus();
        return (String)this.handleError(deleteLayerResponse, errorMessage);
    }
}

