/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.workspace;

import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.workspace.WorkspaceSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"list"}, parentOperation=WorkspaceSection.class)
@Parameters(commandDescription="List GeoServer workspaces")
public class GeoServerListWorkspacesCommand
extends GeoServerCommand<List<String>> {
    public void execute(OperationParams params) throws Exception {
        Iterator iterator = this.computeResults(params).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            params.getConsole().println(string);
        }
    }

    public List<String> computeResults(OperationParams params) throws Exception {
        Response getWorkspacesResponse = this.geoserverClient.getWorkspaces();
        ArrayList<String> results = new ArrayList<String>();
        if (getWorkspacesResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            results.add("\nList of GeoServer workspaces:");
            JSONObject jsonResponse = JSONObject.fromObject((Object)getWorkspacesResponse.getEntity());
            JSONArray workspaces = jsonResponse.getJSONArray("workspaces");
            for (int i = 0; i < workspaces.size(); ++i) {
                String wsName = workspaces.getJSONObject(i).getString("name");
                results.add("  > " + wsName);
            }
            results.add("---\n");
            return results;
        }
        String errorMessage = "Error getting GeoServer workspace list: " + (String)getWorkspacesResponse.readEntity(String.class) + "\nGeoServer Response Code = " + getWorkspacesResponse.getStatus();
        return (List)this.handleError(getWorkspacesResponse, errorMessage);
    }
}

