/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.core.Response;
import org.apache.spark.status.api.v1.ForbiddenException;
import org.locationtech.geowave.cli.geoserver.GeoServerConfig;
import org.locationtech.geowave.cli.geoserver.GeoServerRestClient;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.cli.exceptions.DuplicateEntryException;
import org.locationtech.geowave.core.cli.exceptions.TargetNotFoundException;

public abstract class GeoServerCommand<T>
extends ServiceEnabledCommand<T> {
    protected GeoServerRestClient geoserverClient = null;

    public boolean prepare(OperationParams params) {
        if (this.geoserverClient == null) {
            this.geoserverClient = GeoServerRestClient.getInstance(new GeoServerConfig(this.getGeoWaveConfigFile(params), params.getConsole()), params.getConsole());
        }
        return true;
    }

    public boolean isDuplicate(Response response, String errorMessage) throws TargetNotFoundException {
        return errorMessage.toLowerCase().contains("already exists");
    }

    public T handleError(Response response, String errorMessage) throws Exception {
        if (this.isDuplicate(response, errorMessage)) {
            throw new DuplicateEntryException(errorMessage);
        }
        switch (response.getStatus()) {
            case 401: {
                throw new NotAuthorizedException((Object)errorMessage, new Object[0]);
            }
            case 403: {
                throw new ForbiddenException(errorMessage);
            }
            case 404: {
                throw new TargetNotFoundException(errorMessage);
            }
            case 500: {
                throw new Exception("Internal Server Error\n GeoServer Response Code = 500");
            }
        }
        throw new Exception(errorMessage);
    }
}

