/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver;

import com.beust.jcommander.internal.Console;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.ws.rs.PathParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.glassfish.jersey.SslConfigurator;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.locationtech.geowave.adapter.raster.adapter.RasterDataAdapter;
import org.locationtech.geowave.cli.geoserver.GeoServerConfig;
import org.locationtech.geowave.cli.geoserver.layer.GeoServerAddLayerCommand;
import org.locationtech.geowave.core.cli.operations.config.security.crypto.BaseEncryption;
import org.locationtech.geowave.core.cli.operations.config.security.utils.SecurityUtils;
import org.locationtech.geowave.core.cli.utils.FileUtils;
import org.locationtech.geowave.core.geotime.store.GeotoolsFeatureDataAdapter;
import org.locationtech.geowave.core.store.adapter.InternalDataAdapter;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.cli.CLIUtils;
import org.locationtech.geowave.core.store.cli.store.DataStorePluginOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GeoServerRestClient {
    private static GeoServerRestClient SINGLETON_INSTANCE;
    private static final Logger LOGGER;
    private static final int defaultIndentation = 2;
    private final GeoServerConfig config;
    private final Console console;
    private WebTarget webTarget = null;

    private GeoServerRestClient(GeoServerConfig config, Console console) {
        this.config = config;
        this.console = console;
    }

    private GeoServerRestClient(GeoServerConfig config, WebTarget webTarget, Console console) {
        this.config = config;
        this.webTarget = webTarget;
        this.console = console;
    }

    public static GeoServerRestClient getInstance(GeoServerConfig config, Console console) {
        if (SINGLETON_INSTANCE == null) {
            SINGLETON_INSTANCE = new GeoServerRestClient(config, console);
        }
        return SINGLETON_INSTANCE;
    }

    public void setWebTarget(WebTarget webTarget) {
        this.webTarget = webTarget;
    }

    public static void invalidateInstance() {
        SINGLETON_INSTANCE = null;
    }

    public GeoServerConfig getConfig() {
        return this.config;
    }

    private WebTarget getWebTarget() {
        String url;
        if (this.webTarget == null && (url = this.getConfig().getUrl()) != null) {
            url = url.trim().toLowerCase(Locale.ROOT);
            Client client = null;
            if (url.startsWith("http://")) {
                client = ClientBuilder.newClient();
            } else if (url.startsWith("https://")) {
                SslConfigurator sslConfig = SslConfigurator.newInstance();
                if (this.getConfig().getGsConfigProperties() != null) {
                    this.loadSSLConfigurations(sslConfig, this.getConfig().getGsConfigProperties());
                }
                SSLContext sslContext = sslConfig.createSSLContext();
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
                client = ClientBuilder.newBuilder().sslContext(sslContext).build();
            }
            if (client != null) {
                client.register((Object)HttpAuthenticationFeature.basic((String)this.getConfig().getUser(), (String)this.getConfig().getPass()));
                try {
                    this.webTarget = client.target(new URI(url));
                }
                catch (URISyntaxException e) {
                    LOGGER.error("Unable to parse geoserver URL: " + url, (Throwable)e);
                }
            }
        }
        return this.webTarget;
    }

    private void loadSSLConfigurations(SslConfigurator sslConfig, Properties gsConfigProperties) {
        if (gsConfigProperties != null && sslConfig != null) {
            File keyStoreFile;
            File trustStoreFile;
            sslConfig.securityProtocol(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.security.protocol", "TLS"));
            if (gsConfigProperties.containsKey("geoserver.ssl.trustStore") && (trustStoreFile = new File(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.trustStore"))) != null) {
                try {
                    sslConfig.trustStoreFile(trustStoreFile.getCanonicalPath());
                }
                catch (IOException e) {
                    LOGGER.error("An error occurred loading the truststore at the specified path [" + this.getPropertyValue(gsConfigProperties, "geoserver.ssl.trustStore") + "]:" + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.trustStorePassword")) {
                sslConfig.trustStorePassword(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.trustStorePassword"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.trustStoreType")) {
                sslConfig.trustStoreType(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.trustStoreType"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.trustStoreProvider")) {
                sslConfig.trustStoreProvider(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.trustStoreProvider"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.trustStoreMgrFactoryAlgorithm")) {
                sslConfig.trustManagerFactoryAlgorithm(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.trustStoreMgrFactoryAlgorithm"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.trustStoreMgrFactoryProvider")) {
                sslConfig.trustManagerFactoryProvider(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.trustStoreMgrFactoryProvider"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.keyStore") && (keyStoreFile = new File(FileUtils.formatFilePath((String)this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyStore")))) != null) {
                try {
                    sslConfig.keyStoreFile(keyStoreFile.getCanonicalPath());
                }
                catch (IOException e) {
                    LOGGER.error("An error occurred loading the keystore at the specified path [" + this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyStore") + "]:" + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.keyStorePassword")) {
                sslConfig.keyStorePassword(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyStorePassword"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.keyPassword")) {
                sslConfig.keyPassword(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyPassword"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.keyStoreProvider")) {
                sslConfig.keyStoreProvider(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyStoreProvider"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.keyStoreType")) {
                sslConfig.keyStoreType(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyStoreType"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.keyMgrFactoryAlgorithm")) {
                sslConfig.keyManagerFactoryAlgorithm(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyMgrFactoryAlgorithm"));
            }
            if (gsConfigProperties.containsKey("geoserver.ssl.keyMgrFactoryProvider")) {
                sslConfig.keyManagerFactoryProvider(this.getPropertyValue(gsConfigProperties, "geoserver.ssl.keyMgrFactoryProvider"));
            }
        }
    }

    private String getPropertyValue(Properties configProps, String configKey) {
        return this.getPropertyValue(configProps, configKey, null);
    }

    private String getPropertyValue(Properties configProps, String configKey, String defaultValue) {
        String configValue = defaultValue;
        if (configProps != null && BaseEncryption.isProperlyWrapped((String)(configValue = configProps.getProperty(configKey, defaultValue)))) {
            try {
                File resourceTokenFile = SecurityUtils.getFormattedTokenKeyFileForConfig((File)this.getConfig().getPropFile());
                configValue = SecurityUtils.decryptHexEncodedValue((String)configValue, (String)resourceTokenFile.getCanonicalPath(), (Console)this.console);
                return configValue;
            }
            catch (Exception e) {
                LOGGER.error("An error occurred decrypting password: " + e.getLocalizedMessage(), (Throwable)e);
                return configValue;
            }
        }
        return configValue;
    }

    public Response addLayer(String workspaceName, String storeName, String adapterId, String defaultStyle) {
        boolean layerAdded = false;
        int retStatus = -1;
        StringBuilder buf = new StringBuilder("{\"adapters\":[");
        ArrayList<DataAdapterInfo> adapterInfoList = this.getStoreAdapterInfo(storeName, adapterId);
        LOGGER.debug("Finished retrieving adapter list");
        if (adapterInfoList.size() > 1 && adapterId == null) {
            LOGGER.debug("addlayer doesn't know how to deal with multiple adapters");
            String descr = "Failed to add layer(s). Please use -a, or choose one of these layers with -id:";
            JSONObject jsonObj = this.getJsonFromAdapters(adapterInfoList, "Failed to add layer(s). Please use -a, or choose one of these layers with -id:");
            LOGGER.debug(jsonObj.toString());
            return Response.ok((Object)jsonObj.toString(2)).build();
        }
        if (!this.workspaceExists(workspaceName)) {
            LOGGER.debug("addlayer needs to create the " + workspaceName + " workspace");
            Response addWsResponse = this.addWorkspace(workspaceName);
            if (addWsResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                return addWsResponse;
            }
        }
        String cvgStoreName = storeName + "-raster";
        String dataStoreName = storeName + "-vector";
        for (DataAdapterInfo dataAdapterInfo : adapterInfoList) {
            String ret;
            String ret2;
            String ret3;
            if (dataAdapterInfo.isRaster.booleanValue()) {
                Response getCvResponse;
                Response getCsResponse = this.getCoverageStore(workspaceName, cvgStoreName, true);
                if (getCsResponse.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                    Response addCsResponse = this.addCoverageStore(workspaceName, cvgStoreName, storeName, null, null, null);
                    if (addCsResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                        ret3 = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + addCsResponse.getStatus() + ",\"Message\":\"Adding coverage store returned error: " + (String)addCsResponse.readEntity(String.class) + "\"},";
                        buf.append(ret3);
                        if (retStatus == -1) {
                            retStatus = addCsResponse.getStatus();
                            continue;
                        }
                        if (retStatus == addCsResponse.getStatus()) continue;
                        retStatus = 400;
                        continue;
                    }
                } else if (getCsResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                    ret2 = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + getCsResponse.getStatus() + ",\"Message\":\"Checking Existence of coverage store returned error: " + (String)getCsResponse.readEntity(String.class) + "\"},";
                    buf.append(ret2);
                    if (retStatus == -1) {
                        retStatus = getCsResponse.getStatus();
                        continue;
                    }
                    if (retStatus == getCsResponse.getStatus()) continue;
                    retStatus = 400;
                    continue;
                }
                if ((getCvResponse = this.getCoverage(workspaceName, cvgStoreName, dataAdapterInfo.typeName, true)).getStatus() == Response.Status.OK.getStatusCode()) {
                    LOGGER.debug(dataAdapterInfo.typeName + " layer already exists");
                    retStatus = 400;
                    ret3 = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":400,\"Message\":\"Coverage already exists\"},";
                    buf.append(ret3);
                    continue;
                }
                Response addCvResponse = this.addCoverage(workspaceName, cvgStoreName, dataAdapterInfo.typeName);
                if (addCvResponse.getStatus() == Response.Status.CREATED.getStatusCode()) {
                    ret = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + addCvResponse.getStatus() + ",\"Message\":\"Coverage added successfully\"},";
                    buf.append(ret);
                    layerAdded = true;
                    continue;
                }
                ret = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + addCvResponse.getStatus() + ",\"Message\":\"Adding coverage returned error: " + (String)addCvResponse.readEntity(String.class) + "\"},";
                buf.append(ret);
                if (retStatus == -1) {
                    retStatus = addCvResponse.getStatus();
                    continue;
                }
                if (retStatus == addCvResponse.getStatus()) continue;
                retStatus = 400;
                continue;
            }
            Response getDsResponse = this.getDatastore(workspaceName, dataStoreName, true);
            if (getDsResponse.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                Response addDsResponse = this.addDatastore(workspaceName, dataStoreName, storeName);
                if (addDsResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
                    ret3 = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + addDsResponse.getStatus() + ",\"Message\":\"Adding data store returned error: " + (String)addDsResponse.readEntity(String.class) + "\"},";
                    buf.append(ret3);
                    if (retStatus == -1) {
                        retStatus = addDsResponse.getStatus();
                        continue;
                    }
                    if (retStatus == addDsResponse.getStatus()) continue;
                    retStatus = 400;
                    continue;
                }
            } else if (getDsResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                ret2 = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + getDsResponse.getStatus() + ",\"Message\":\"Checking Existence of data store returned error: " + (String)getDsResponse.readEntity(String.class) + "\"},";
                buf.append(ret2);
                if (retStatus == -1) {
                    retStatus = getDsResponse.getStatus();
                    continue;
                }
                if (retStatus == getDsResponse.getStatus()) continue;
                retStatus = 400;
                continue;
            }
            LOGGER.debug("Checking for existing feature layer: " + dataAdapterInfo.typeName);
            Response getFlResponse = this.getFeatureLayer(dataAdapterInfo.typeName, true);
            if (getFlResponse.getStatus() == Response.Status.OK.getStatusCode()) {
                LOGGER.debug(dataAdapterInfo.typeName + " layer already exists");
                retStatus = 400;
                ret3 = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":400,\"Message\":\"Feature Layer already exists\"},";
                buf.append(ret3);
                continue;
            }
            LOGGER.debug("Get feature layer: " + dataAdapterInfo.typeName + " returned " + getFlResponse.getStatus());
            Response addFlResponse = this.addFeatureLayer(workspaceName, dataStoreName, dataAdapterInfo.typeName, defaultStyle);
            if (addFlResponse.getStatus() == Response.Status.CREATED.getStatusCode()) {
                ret = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + addFlResponse.getStatus() + ",\"Message\":\"Feature Layer added successfully\"},";
                buf.append(ret);
                layerAdded = true;
                continue;
            }
            ret = "{ \"Adapter\":\"" + adapterId + "\",\"Status\":" + addFlResponse.getStatus() + ",\"Message\":\"Adding data store error: " + (String)addFlResponse.readEntity(String.class) + "\"},";
            buf.append(ret);
            if (retStatus == -1) {
                retStatus = addFlResponse.getStatus();
                continue;
            }
            if (retStatus == addFlResponse.getStatus()) continue;
            retStatus = 400;
        }
        buf.deleteCharAt(buf.length() - 1);
        buf.append("]}");
        if (layerAdded) {
            return Response.ok((Object)buf.toString()).build();
        }
        String ret = buf.toString();
        return Response.status((int)400).entity((Object)ret).build();
    }

    private JSONObject getJsonFromAdapters(ArrayList<DataAdapterInfo> adapterInfoList, String description) {
        StringBuffer buf = new StringBuffer();
        buf.append("{'description':'" + description + "', 'layers':[");
        for (int i = 0; i < adapterInfoList.size(); ++i) {
            DataAdapterInfo info = adapterInfoList.get(i);
            buf.append("{'id':'" + info.typeName + "',");
            buf.append("'type':'" + (info.isRaster != false ? "raster" : "vector") + "'}");
            if (i >= adapterInfoList.size() - 1) continue;
            buf.append(",");
        }
        buf.append("]}");
        return JSONObject.fromObject((Object)buf.toString());
    }

    public boolean workspaceExists(String workspace) {
        Response getWsResponse;
        if (workspace == null) {
            workspace = this.config.getWorkspace();
        }
        if ((getWsResponse = this.getWorkspaces()).getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)getWsResponse.getEntity());
            JSONArray workspaces = jsonResponse.getJSONArray("workspaces");
            for (int i = 0; i < workspaces.size(); ++i) {
                String wsName = workspaces.getJSONObject(i).getString("name");
                if (!wsName.equals(workspace)) continue;
                return true;
            }
        } else {
            LOGGER.error("Error retrieving GeoServer workspace list");
        }
        return false;
    }

    public Response getWorkspaces() {
        Response resp = this.getWebTarget().path("rest/workspaces.json").request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONArray workspaceArray = this.getArrayEntryNames(JSONObject.fromObject((Object)resp.readEntity(String.class)), "workspaces", "workspace");
            JSONObject workspacesObj = new JSONObject();
            workspacesObj.put((Object)"workspaces", (Object)workspaceArray);
            return Response.ok((Object)workspacesObj.toString(2)).build();
        }
        return resp;
    }

    public Response addWorkspace(String workspace) {
        return this.getWebTarget().path("rest/workspaces").request().post(Entity.entity((Object)("{'workspace':{'name':'" + workspace + "'}}"), (String)"application/json"));
    }

    public Response deleteWorkspace(String workspace) {
        return this.getWebTarget().path("rest/workspaces/" + workspace).queryParam("recurse", new Object[]{"true"}).request().delete();
    }

    public Response getDatastore(String workspaceName, String datastoreName, boolean quietOnNotFound) {
        Response resp = this.getWebTarget().path("rest/workspaces/" + workspaceName + "/datastores/" + datastoreName + ".json").queryParam("quietOnNotFound", new Object[]{quietOnNotFound}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONObject datastore = JSONObject.fromObject((Object)resp.readEntity(String.class));
            if (datastore != null) {
                return Response.ok((Object)datastore.toString(2)).build();
            }
        }
        return resp;
    }

    public Response getDatastores(String workspaceName) {
        Response resp = this.getWebTarget().path("rest/workspaces/" + workspaceName + "/datastores.json").request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONArray datastoreArray = this.getArrayEntryNames(JSONObject.fromObject((Object)resp.readEntity(String.class)), "dataStores", "dataStore");
            JSONObject dsObj = new JSONObject();
            dsObj.put((Object)"dataStores", (Object)datastoreArray);
            return Response.ok((Object)dsObj.toString(2)).build();
        }
        return resp;
    }

    public Response addDatastore(String workspaceName, String datastoreName, String gwStoreName) {
        DataStorePluginOptions inputStoreOptions = this.getStorePlugin(gwStoreName);
        if (datastoreName == null || datastoreName.isEmpty()) {
            datastoreName = gwStoreName + "-vector";
        }
        String lockMgmt = "memory";
        String authMgmtPrvdr = "empty";
        String authDataUrl = "";
        String queryIndexStrategy = "Heuristic Match";
        String dataStoreJson = this.createDatastoreJson(inputStoreOptions.getType(), inputStoreOptions.getOptionsAsMap(), datastoreName, "memory", "empty", "", "Heuristic Match", true);
        return this.getWebTarget().path("rest/workspaces/" + workspaceName + "/datastores").request().post(Entity.entity((Object)dataStoreJson, (String)"application/json"));
    }

    public Response deleteDatastore(String workspaceName, String datastoreName) {
        return this.getWebTarget().path("rest/workspaces/" + workspaceName + "/datastores/" + datastoreName).queryParam("recurse", new Object[]{"true"}).request().delete();
    }

    public Response getFeatureLayer(String layerName, boolean quietOnNotFound) {
        JSONObject layer;
        Response resp = this.getWebTarget().path("rest/layers/" + layerName + ".json").queryParam("quietOnNotFound", new Object[]{quietOnNotFound}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode() && (layer = JSONObject.fromObject((Object)resp.readEntity(String.class))) != null) {
            return Response.ok((Object)layer.toString(2)).build();
        }
        return resp;
    }

    public Response getFeatureLayers(String workspaceName, String datastoreName, boolean geowaveOnly) {
        boolean wsFilter = workspaceName != null && !workspaceName.isEmpty();
        boolean dsFilter = datastoreName != null && !datastoreName.isEmpty();
        Response resp = this.getWebTarget().path("rest/layers.json").request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONArray layerArray = this.getArrayEntryNames(JSONObject.fromObject((Object)resp.readEntity(String.class)), "layers", "layer");
            JSONArray layerInfoArray = new JSONArray();
            HashMap namespaceLayersMap = new HashMap();
            Pattern p = Pattern.compile("workspaces/(.*?)/datastores/(.*?)/");
            block0: for (int i = 0; i < layerArray.size(); ++i) {
                boolean include;
                boolean bl = include = !geowaveOnly && !wsFilter && !dsFilter;
                if (include) {
                    layerInfoArray.add((Object)layerArray.getJSONObject(i));
                    continue;
                }
                String name = layerArray.getJSONObject(i).getString("name");
                String layer = (String)this.getFeatureLayer(name, false).getEntity();
                String ws = null;
                String ds = null;
                Matcher m = p.matcher(layer);
                if (m.find()) {
                    ws = m.group(1);
                    ds = m.group(2);
                }
                if (dsFilter && (ds == null || !ds.equals(datastoreName)) || wsFilter && (ws == null || !ws.equals(workspaceName))) continue;
                JSONObject datastore = JSONObject.fromObject((Object)this.getDatastore(ds, ws, false).getEntity()).getJSONObject("dataStore");
                if (geowaveOnly) {
                    if (datastore == null || !datastore.containsKey((Object)"type") || !datastore.getString("type").startsWith("GeoWave Datastore")) continue;
                    JSONArray entryArray = null;
                    if (datastore.get("connectionParameters") instanceof JSONObject) {
                        entryArray = datastore.getJSONObject("connectionParameters").getJSONArray("entry");
                    } else if (datastore.get("connectionParameters") instanceof JSONArray) {
                        entryArray = datastore.getJSONArray("connectionParameters").getJSONObject(0).getJSONArray("entry");
                    }
                    if (entryArray == null) {
                        LOGGER.error("entry Array is null - didn't find a connectionParameters datastore object that was a JSONObject or JSONArray");
                        continue;
                    }
                    for (int j = 0; j < entryArray.size(); ++j) {
                        JSONObject entry = entryArray.getJSONObject(j);
                        String key = entry.getString("@key");
                        String value = entry.getString("$");
                        if (!key.startsWith("gwNamespace")) continue;
                        if (namespaceLayersMap.containsKey(value)) {
                            ((List)namespaceLayersMap.get(value)).add(name);
                            continue block0;
                        }
                        ArrayList<String> layers = new ArrayList<String>();
                        layers.add(name);
                        namespaceLayersMap.put(value, layers);
                        continue block0;
                    }
                    continue;
                }
                layerInfoArray.add((Object)layerArray.getJSONObject(i));
            }
            if (geowaveOnly) {
                JSONArray layersArray = new JSONArray();
                for (Map.Entry kvp : namespaceLayersMap.entrySet()) {
                    JSONArray layers = new JSONArray();
                    for (int i = 0; i < ((List)kvp.getValue()).size(); ++i) {
                        JSONObject layerObj = new JSONObject();
                        layerObj.put((Object)"name", ((List)kvp.getValue()).get(i));
                        layers.add((Object)layerObj);
                    }
                    JSONObject layersObj = new JSONObject();
                    layersObj.put((Object)"namespace", kvp.getKey());
                    layersObj.put((Object)"layers", (Object)layers);
                    layersArray.add((Object)layersObj);
                }
                JSONObject layersObj = new JSONObject();
                layersObj.put((Object)"layers", (Object)layersArray);
                return Response.ok((Object)layersObj.toString(2)).build();
            }
            JSONObject layersObj = new JSONObject();
            layersObj.put((Object)"layers", (Object)layerInfoArray);
            return Response.ok((Object)layersObj.toString(2)).build();
        }
        return resp;
    }

    public Response addFeatureLayer(String workspaceName, String datastoreName, String layerName, String defaultStyle) {
        if (defaultStyle != null) {
            this.getWebTarget().path("rest/layers/" + layerName + ".json").request().put(Entity.entity((Object)("{'layer':{'defaultStyle':{'name':'" + defaultStyle + "'}}}"), (String)"application/json"));
        }
        return this.getWebTarget().path("rest/workspaces/" + workspaceName + "/datastores/" + datastoreName + "/featuretypes").request().post(Entity.entity((Object)("{'featureType':{'name':'" + layerName + "'}}"), (String)"application/json"));
    }

    public Response deleteFeatureLayer(String layerName) {
        return this.getWebTarget().path("rest/layers/" + layerName).request().delete();
    }

    public Response setLayerStyle(String layerName, String styleName) {
        return this.getWebTarget().path("rest/layers/" + layerName + ".json").request().put(Entity.entity((Object)("{'layer':{'defaultStyle':{'name':'" + styleName + "'}}}"), (String)"application/json"));
    }

    public Response getStyle(@PathParam(value="styleName") String styleName, boolean quietOnNotFound) {
        Response resp = this.getWebTarget().path("rest/styles/" + styleName + ".sld").queryParam("quietOnNotFound", new Object[]{quietOnNotFound}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            InputStream inStream = (InputStream)resp.getEntity();
            return Response.ok((Object)inStream, (String)"application/xml").header("Content-Disposition", (Object)("attachment; filename=\"" + styleName + ".sld\"")).build();
        }
        return resp;
    }

    public Response getStyles() {
        Response resp = this.getWebTarget().path("rest/styles.json").request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONArray styleArray = this.getArrayEntryNames(JSONObject.fromObject((Object)resp.readEntity(String.class)), "styles", "style");
            JSONObject stylesObj = new JSONObject();
            stylesObj.put((Object)"styles", (Object)styleArray);
            return Response.ok((Object)stylesObj.toString(2)).build();
        }
        return resp;
    }

    public Response addStyle(String styleName, InputStream fileInStream) {
        Response addStyleResponse = this.getWebTarget().path("rest/styles").request().post(Entity.entity((Object)("{'style':{'name':'" + styleName + "','filename':'" + styleName + ".sld'}}"), (String)"application/json"));
        if (addStyleResponse.getStatus() != Response.Status.CREATED.getStatusCode()) {
            return addStyleResponse;
        }
        return this.getWebTarget().path("rest/styles/" + styleName).request().put(Entity.entity((Object)fileInStream, (String)"application/vnd.ogc.sld+xml"));
    }

    public Response deleteStyle(String styleName) {
        return this.getWebTarget().path("rest/styles/" + styleName).request().delete();
    }

    public Response getCoverageStore(String workspaceName, String coverageName, boolean quietOnNotFound) {
        Response resp = this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores/" + coverageName + ".json").queryParam("quietOnNotFound", new Object[]{quietOnNotFound}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONObject cvgstore = JSONObject.fromObject((Object)resp.readEntity(String.class));
            if (cvgstore != null) {
                return Response.ok((Object)cvgstore.toString(2)).build();
            }
        }
        return resp;
    }

    public Response getCoverageStores(String workspaceName) {
        Response resp = this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores.json").request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONArray coveragesArray = this.getArrayEntryNames(JSONObject.fromObject((Object)resp.readEntity(String.class)), "coverageStores", "coverageStore");
            JSONObject dsObj = new JSONObject();
            dsObj.put((Object)"coverageStores", (Object)coveragesArray);
            return Response.ok((Object)dsObj.toString(2)).build();
        }
        return resp;
    }

    public Response addCoverageStore(String workspaceName, String cvgStoreName, String gwStoreName, Boolean equalizeHistogramOverride, String interpolationOverride, Boolean scaleTo8Bit) {
        DataStorePluginOptions inputStoreOptions = this.getStorePlugin(gwStoreName);
        if (cvgStoreName == null || cvgStoreName.isEmpty()) {
            cvgStoreName = gwStoreName + "-raster";
        }
        Map storeConfigMap = inputStoreOptions.getOptionsAsMap();
        storeConfigMap.put("gwNamespace", inputStoreOptions.getGeoWaveNamespace());
        String cvgStoreXml = this.createCoverageXml(storeConfigMap, equalizeHistogramOverride, interpolationOverride, scaleTo8Bit, workspaceName, cvgStoreName);
        LOGGER.debug("Add coverage store - xml params:\n" + cvgStoreXml);
        return this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores").request().post(Entity.entity((Object)cvgStoreXml, (String)"application/xml"));
    }

    public Response deleteCoverageStore(String workspaceName, String cvgstoreName) {
        return this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores/" + cvgstoreName).queryParam("recurse", new Object[]{"true"}).request().delete();
    }

    public Response getCoverages(String workspaceName, String cvsstoreName) {
        Response resp = this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores/" + cvsstoreName + "/coverages.json").request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONArray coveragesArray = this.getArrayEntryNames(JSONObject.fromObject((Object)resp.readEntity(String.class)), "coverages", "coverage");
            JSONObject dsObj = new JSONObject();
            dsObj.put((Object)"coverages", (Object)coveragesArray);
            return Response.ok((Object)dsObj.toString(2)).build();
        }
        return resp;
    }

    public Response getCoverage(String workspaceName, String cvgStoreName, String coverageName, boolean quietOnNotFound) {
        Response resp = this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores/" + cvgStoreName + "/coverages/" + coverageName + ".json").queryParam("quietOnNotFound", new Object[]{quietOnNotFound}).request().get();
        if (resp.getStatus() == Response.Status.OK.getStatusCode()) {
            resp.bufferEntity();
            JSONObject cvg = JSONObject.fromObject((Object)resp.readEntity(String.class));
            if (cvg != null) {
                return Response.ok((Object)cvg.toString(2)).build();
            }
        }
        return resp;
    }

    public Response addCoverage(String workspaceName, String cvgStoreName, String coverageName) {
        String jsonString = "{'coverage':{'name':'" + coverageName + "','nativeCoverageName':'" + coverageName + "'}}";
        LOGGER.debug("Posting JSON: " + jsonString + " to " + workspaceName + "/" + cvgStoreName);
        return this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores/" + cvgStoreName + "/coverages").request().post(Entity.entity((Object)jsonString, (String)"application/json"));
    }

    public Response deleteCoverage(String workspaceName, String cvgstoreName, String coverageName) {
        return this.getWebTarget().path("rest/workspaces/" + workspaceName + "/coveragestores/" + cvgstoreName + "/coverages/" + coverageName).queryParam("recurse", new Object[]{"true"}).request().delete();
    }

    protected String createFeatureTypeJson(String featureTypeName) {
        JSONObject featTypeJson = new JSONObject();
        featTypeJson.put((Object)"name", (Object)featureTypeName);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"featureType", (Object)featTypeJson);
        return jsonObj.toString();
    }

    protected JSONArray getArrayEntryNames(JSONObject jsonObj, String firstKey, String secondKey) {
        JSONArray tempArray;
        if (jsonObj.get(firstKey) instanceof JSONObject) {
            jsonObj = jsonObj.getJSONObject(firstKey);
        } else if (jsonObj.get(firstKey) instanceof JSONArray && (tempArray = jsonObj.getJSONArray(firstKey)).size() > 0) {
            if (tempArray.get(0) instanceof JSONObject) {
                jsonObj = tempArray.getJSONObject(0);
            } else {
                return new JSONArray();
            }
        }
        JSONArray entryArray = new JSONArray();
        if (jsonObj.get(secondKey) instanceof JSONObject) {
            JSONObject entry = new JSONObject();
            entry.put((Object)"name", (Object)jsonObj.getJSONObject(secondKey).getString("name"));
            entryArray.add((Object)entry);
        } else if (jsonObj.get(secondKey) instanceof JSONArray) {
            JSONArray entries = jsonObj.getJSONArray(secondKey);
            for (int i = 0; i < entries.size(); ++i) {
                JSONObject entry = new JSONObject();
                entry.put((Object)"name", (Object)entries.getJSONObject(i).getString("name"));
                entryArray.add((Object)entry);
            }
        }
        return entryArray;
    }

    protected String createDatastoreJson(String geowaveStoreType, Map<String, String> geowaveStoreConfig, String name, String lockMgmt, String authMgmtProvider, String authDataUrl, String queryIndexStrategy, boolean enabled) {
        JSONObject dataStore = new JSONObject();
        dataStore.put((Object)"name", (Object)name);
        dataStore.put((Object)"type", (Object)("GeoWave Datastore - " + geowaveStoreType));
        dataStore.put((Object)"enabled", (Object)Boolean.toString(enabled));
        JSONObject connParams = new JSONObject();
        if (geowaveStoreConfig != null) {
            for (Map.Entry<String, String> e : geowaveStoreConfig.entrySet()) {
                connParams.put((Object)e.getKey(), (Object)e.getValue());
            }
        }
        connParams.put((Object)"Lock Management", (Object)lockMgmt);
        connParams.put((Object)"Query Index Strategy", (Object)queryIndexStrategy);
        connParams.put((Object)"Authorization Management Provider", (Object)authMgmtProvider);
        if (!authMgmtProvider.equals("empty")) {
            connParams.put((Object)"Authorization Data URL", (Object)authDataUrl);
        }
        dataStore.put((Object)"connectionParameters", (Object)connParams);
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"dataStore", (Object)dataStore);
        return jsonObj.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createCoverageXml(Map<String, String> geowaveStoreConfig, Boolean equalizeHistogramOverride, String interpolationOverride, Boolean scaleTo8Bit, String workspace, String cvgstoreName) {
        String coverageXml = null;
        StreamResult result = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            Document xmlDoc = factory.newDocumentBuilder().newDocument();
            Element rootEl = xmlDoc.createElement("coverageStore");
            xmlDoc.appendChild(rootEl);
            Element nameEl = xmlDoc.createElement("name");
            nameEl.appendChild(xmlDoc.createTextNode(cvgstoreName));
            rootEl.appendChild(nameEl);
            Element wsEl = xmlDoc.createElement("workspace");
            wsEl.appendChild(xmlDoc.createTextNode(workspace));
            rootEl.appendChild(wsEl);
            Element typeEl = xmlDoc.createElement("type");
            typeEl.appendChild(xmlDoc.createTextNode("GeoWaveRasterFormat"));
            rootEl.appendChild(typeEl);
            Element enabledEl = xmlDoc.createElement("enabled");
            enabledEl.appendChild(xmlDoc.createTextNode("true"));
            rootEl.appendChild(enabledEl);
            Element configEl = xmlDoc.createElement("configure");
            configEl.appendChild(xmlDoc.createTextNode("all"));
            rootEl.appendChild(configEl);
            String storeConfigUrl = this.createParamUrl(geowaveStoreConfig, equalizeHistogramOverride, interpolationOverride, scaleTo8Bit);
            Element urlEl = xmlDoc.createElement("url");
            urlEl.appendChild(xmlDoc.createTextNode(storeConfigUrl));
            rootEl.appendChild(urlEl);
            TransformerFactory xformerFactory = TransformerFactory.newInstance();
            Transformer xformer = xformerFactory.newTransformer();
            DOMSource source = new DOMSource(xmlDoc);
            result = new StreamResult(new StringWriter());
            xformer.transform(source, result);
            coverageXml = result.getWriter().toString();
        }
        catch (TransformerException e) {
            LOGGER.error("Unable to create transformer", (Throwable)e);
        }
        catch (ParserConfigurationException e1) {
            LOGGER.error("Unable to create DocumentBuilderFactory", (Throwable)e1);
        }
        finally {
            if (result != null && result.getWriter() != null) {
                try {
                    result.getWriter().close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return coverageXml;
    }

    private String createParamUrl(Map<String, String> geowaveStoreConfig, Boolean equalizeHistogramOverride, String interpolationOverride, Boolean scaleTo8Bit) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (Map.Entry<String, String> e : geowaveStoreConfig.entrySet()) {
            if (!first) {
                buf.append(";");
            } else {
                first = false;
            }
            buf.append(e.getKey()).append("=").append(e.getValue());
        }
        if (equalizeHistogramOverride != null) {
            buf.append(";equalizeHistogramOverride=");
            buf.append(equalizeHistogramOverride);
        }
        if (interpolationOverride != null) {
            buf.append(";interpolationOverride=");
            buf.append(interpolationOverride);
        }
        if (scaleTo8Bit != null) {
            buf.append(";scaleTo8Bit=");
            buf.append(scaleTo8Bit);
        }
        return buf.toString();
    }

    public DataStorePluginOptions getStorePlugin(String storeName) {
        return CLIUtils.loadStore((String)storeName, (File)this.config.getPropFile(), (Console)this.console);
    }

    public ArrayList<String> getStoreAdapters(String storeName, String adapterId) {
        ArrayList<DataAdapterInfo> adapterInfoList = this.getStoreAdapterInfo(storeName, adapterId);
        ArrayList<String> adapterIdList = new ArrayList<String>();
        for (DataAdapterInfo info : adapterInfoList) {
            adapterIdList.add(info.typeName);
        }
        return adapterIdList;
    }

    private ArrayList<DataAdapterInfo> getStoreAdapterInfo(String storeName, String adapterId) {
        DataStorePluginOptions dsPlugin = this.getStorePlugin(storeName);
        DataStore dataStore = dsPlugin.createDataStore();
        ArrayList<DataAdapterInfo> adapterInfoList = new ArrayList<DataAdapterInfo>();
        LOGGER.debug("Adapter list for " + storeName + " with adapterId = " + adapterId + ": ");
        for (DataTypeAdapter adapter : dataStore.getTypes()) {
            DataAdapterInfo info = this.getAdapterInfo(adapterId, adapter);
            if (info == null) continue;
            adapterInfoList.add(info);
            LOGGER.debug("> '" + info.typeName + "' adapter passed filter");
        }
        LOGGER.debug("getStoreAdapterInfo(" + storeName + ") got " + adapterInfoList.size() + " ids");
        if (dataStore instanceof Closeable) {
            try {
                ((Closeable)dataStore).close();
            }
            catch (IOException e) {
                LOGGER.error("Unable to close datastore");
            }
        }
        return adapterInfoList;
    }

    private DataAdapterInfo getAdapterInfo(String typeName, DataTypeAdapter<?> adapter) {
        LOGGER.debug("getAdapterInfo for id = " + typeName);
        DataAdapterInfo info = new DataAdapterInfo();
        info.typeName = adapter.getTypeName();
        info.isRaster = false;
        if (adapter instanceof RasterDataAdapter || adapter instanceof InternalDataAdapter && ((InternalDataAdapter)adapter).getAdapter() instanceof RasterDataAdapter) {
            info.isRaster = true;
        }
        LOGGER.debug("> Adapter ID: " + info.typeName);
        LOGGER.debug("> Adapter Type: " + adapter.getClass().getSimpleName());
        if (typeName == null || typeName.equals(GeoServerAddLayerCommand.AddOption.ALL.name())) {
            LOGGER.debug("id is null or all");
            return info;
        }
        if (typeName.equals(adapter.getTypeName())) {
            LOGGER.debug("id matches adapter id");
            return info;
        }
        if (typeName.equals(GeoServerAddLayerCommand.AddOption.RASTER.name()) && (adapter instanceof RasterDataAdapter || adapter instanceof InternalDataAdapter && ((InternalDataAdapter)adapter).getAdapter() instanceof RasterDataAdapter)) {
            LOGGER.debug("id is all-raster and adapter is raster type");
            return info;
        }
        if (typeName.equals(GeoServerAddLayerCommand.AddOption.VECTOR.name()) && (adapter instanceof GeotoolsFeatureDataAdapter || adapter instanceof InternalDataAdapter && ((InternalDataAdapter)adapter).getAdapter() instanceof GeotoolsFeatureDataAdapter)) {
            LOGGER.debug("id is all-vector and adapter is vector type");
            return info;
        }
        LOGGER.debug("No match!");
        return null;
    }

    static {
        LOGGER = LoggerFactory.getLogger(GeoServerRestClient.class);
    }

    private static class DataAdapterInfo {
        String typeName;
        Boolean isRaster;

        private DataAdapterInfo() {
        }
    }
}

