/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.coverage;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.coverage.CoverageSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"get"}, parentOperation=CoverageSection.class)
@Parameters(commandDescription="Get a GeoServer coverage's info")
public class GeoServerGetCoverageCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace = null;
    @Parameter(names={"-cs", "--cvgstore"}, required=true, description="coverage store name")
    private String cvgstore = null;
    @Parameter(description="<coverage name>")
    private List<String> parameters = new ArrayList<String>();
    private String cvgName = null;

    public void execute(OperationParams params) throws Exception {
        params.getConsole().println(this.computeResults(params));
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <coverage name>");
        }
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        this.cvgName = this.parameters.get(0);
        Response getCvgResponse = this.geoserverClient.getCoverage(this.workspace, this.cvgstore, this.cvgName, false);
        if (getCvgResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            JSONObject jsonResponse = JSONObject.fromObject((Object)getCvgResponse.getEntity());
            return "\nGeoServer coverage info for '" + this.cvgName + "': " + jsonResponse.toString(2);
        }
        String errorMessage = "Error getting GeoServer coverage info for " + this.cvgName + ": " + (String)getCvgResponse.readEntity(String.class) + "\nGeoServer Response Code = " + getCvgResponse.getStatus();
        return (String)this.handleError(getCvgResponse, errorMessage);
    }

    public void setCvgstore(String cvgstore) {
        this.cvgstore = cvgstore;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }
}

