/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.datastore;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.datastore.DatastoreSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"add"}, parentOperation=DatastoreSection.class)
@Parameters(commandDescription="Add a GeoServer datastore")
public class GeoServerAddDatastoreCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace = null;
    @Parameter(names={"-ds", "--datastore"}, required=false, description="datastore name")
    private String datastore = null;
    @Parameter(description="<GeoWave store name>")
    private List<String> parameters = new ArrayList<String>();
    private String gwStore = null;

    public void execute(OperationParams params) throws Exception {
        params.getConsole().println(this.computeResults(params));
    }

    public void setDatastore(String datastore) {
        this.datastore = datastore;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String computeResults(OperationParams params) throws Exception {
        Response addStoreResponse;
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <datastore name>");
        }
        this.gwStore = this.parameters.get(0);
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        if ((addStoreResponse = this.geoserverClient.addDatastore(this.workspace, this.datastore, this.gwStore)).getStatus() == Response.Status.OK.getStatusCode() || addStoreResponse.getStatus() == Response.Status.CREATED.getStatusCode()) {
            return "Add datastore for '" + this.gwStore + "' to workspace '" + this.workspace + "' on GeoServer: OK";
        }
        String errorMessage = "Error adding datastore for '" + this.gwStore + "' to workspace '" + this.workspace + "' on GeoServer: " + (String)addStoreResponse.readEntity(String.class) + "\nGeoServer Response Code = " + addStoreResponse.getStatus();
        return (String)this.handleError(addStoreResponse, errorMessage);
    }
}

