/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.datastore;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.datastore.DatastoreSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"getsa", "getstoreadapters"}, parentOperation=DatastoreSection.class)
@Parameters(commandDescription="Get GeoWave store adapters")
public class GeoServerGetStoreAdapterCommand
extends GeoServerCommand<List<String>> {
    @Parameter(description="<store name>")
    private List<String> parameters = new ArrayList<String>();
    private String storeName = null;

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public void execute(OperationParams params) throws Exception {
        Object adapterList = this.computeResults(params);
        params.getConsole().println("Store " + this.storeName + " has these adapters:");
        Iterator iterator = adapterList.iterator();
        while (iterator.hasNext()) {
            String adapterId = (String)iterator.next();
            params.getConsole().println(adapterId);
        }
    }

    public List<String> computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <store name>");
        }
        this.storeName = this.parameters.get(0);
        ArrayList<String> adapterList = this.geoserverClient.getStoreAdapters(this.storeName, null);
        return adapterList;
    }
}

