/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.featurelayer;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import net.sf.json.JSONObject;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.featurelayer.FeatureLayerSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"add"}, parentOperation=FeatureLayerSection.class)
@Parameters(commandDescription="Add a GeoServer feature layer")
public class GeoServerAddFeatureLayerCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-ws", "--workspace"}, required=false, description="workspace name")
    private String workspace = null;
    @Parameter(names={"-ds", "--datastore"}, required=true, description="datastore name")
    private String datastore = null;
    @Parameter(description="<layer name>")
    private List<String> parameters = new ArrayList<String>();
    private String layerName = null;

    public void execute(OperationParams params) throws Exception {
        params.getConsole().println(this.computeResults(params));
    }

    public void setDatastore(String datastore) {
        this.datastore = datastore;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <layer name>");
        }
        if (this.workspace == null || this.workspace.isEmpty()) {
            this.workspace = this.geoserverClient.getConfig().getWorkspace();
        }
        this.layerName = this.parameters.get(0);
        Response addLayerResponse = this.geoserverClient.addFeatureLayer(this.workspace, this.datastore, this.layerName, null);
        if (addLayerResponse.getStatus() == Response.Status.CREATED.getStatusCode()) {
            JSONObject listObj = JSONObject.fromObject((Object)addLayerResponse.getEntity());
            return "\nGeoServer add layer response " + this.layerName + ":" + listObj.toString(2);
        }
        String errorMessage = "Error adding GeoServer layer " + this.layerName + ": " + (String)addLayerResponse.readEntity(String.class) + "\nGeoServer Response Code = " + addLayerResponse.getStatus();
        return (String)this.handleError(addLayerResponse, errorMessage);
    }
}

