/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.cli.geoserver.style;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.locationtech.geowave.cli.geoserver.GeoServerCommand;
import org.locationtech.geowave.cli.geoserver.style.StyleSection;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;

@GeowaveOperation(name={"set"}, parentOperation=StyleSection.class)
@Parameters(commandDescription="Set GeoServer Layer Style")
public class GeoServerSetLayerStyleCommand
extends GeoServerCommand<String> {
    @Parameter(names={"-sn", "--styleName"}, required=true, description="style name")
    private String styleName = null;
    @Parameter(description="<layer name>")
    private List<String> parameters = new ArrayList<String>();
    private String layerName = null;

    public Boolean successStatusIs200() {
        return true;
    }

    public void execute(OperationParams params) throws Exception {
        params.getConsole().println(this.computeResults(params));
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String computeResults(OperationParams params) throws Exception {
        if (this.parameters.size() != 1) {
            throw new ParameterException("Requires argument: <layer name>");
        }
        this.layerName = this.parameters.get(0);
        Response setLayerStyleResponse = this.geoserverClient.setLayerStyle(this.layerName, this.styleName);
        if (setLayerStyleResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            String style = IOUtils.toString((InputStream)((InputStream)setLayerStyleResponse.getEntity()));
            return "Set style for GeoServer layer '" + this.layerName + ": OK" + style;
        }
        String errorMessage = "Error setting style for GeoServer layer '" + this.layerName + "': " + (String)setLayerStyleResponse.readEntity(String.class) + "\nGeoServer Response Code = " + setLayerStyleResponse.getStatus();
        return (String)this.handleError(setLayerStyleResponse, errorMessage);
    }
}

