/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.kudu.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.concurrent.TimeUnit;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.datastore.kudu.cli.KuduLocal;
import org.locationtech.geowave.datastore.kudu.cli.KuduSection;
import org.locationtech.geowave.datastore.kudu.cli.RunKuduLocalOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GeowaveOperation(name={"run"}, parentOperation=KuduSection.class)
@Parameters(commandDescription="Runs a standalone Kudu server for test and debug with GeoWave")
public class RunKuduLocal
extends DefaultOperation
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunKuduLocal.class);
    @ParametersDelegate
    private RunKuduLocalOptions options = new RunKuduLocalOptions();
    @Parameter(names={"--interactive", "-i"}, arity=1, description="Whether to prompt for user input to end the process")
    private boolean interactive = true;

    public void execute(OperationParams params) {
        block4: {
            try {
                final KuduLocal server = this.options.getServer();
                server.start();
                if (this.interactive) {
                    System.out.println("Press Enter to shutdown..");
                    System.in.read();
                    System.out.println("Shutting down!");
                    server.stop();
                    break block4;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            server.stop();
                        }
                        catch (Exception e) {
                            LOGGER.warn("Unable to shutdown Kudu", (Throwable)e);
                            System.out.println("Error shutting down Kudu server.");
                        }
                        System.out.println("Shutting down!");
                    }
                });
                while (true) {
                    Thread.sleep(TimeUnit.MILLISECONDS.convert(Long.MAX_VALUE, TimeUnit.DAYS));
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to run embedded Kudu server", (Throwable)e);
            }
        }
    }
}

