/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.datastore.kudu.cli;

import java.io.File;
import java.io.IOException;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.io.FileUtils;
import org.apache.kudu.test.cluster.MiniKuduCluster;
import org.locationtech.geowave.datastore.kudu.cli.RunKuduLocalOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduLocal {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuduLocal.class);
    private static final long STARTUP_DELAY_MS = 1500L;
    public static final File DEFAULT_DIR = new File("./target/temp");
    private MiniKuduCluster kudu;
    private final MiniKuduCluster.MiniKuduClusterBuilder kuduBldr;
    private File kuduLocalDir;

    public KuduLocal(RunKuduLocalOptions opt) {
        this(opt.getDirectory(), opt.getTablets());
    }

    public KuduLocal(String localDir, int numTablets) {
        this.kuduLocalDir = localDir != null && !localDir.contentEquals("") ? new File(localDir) : new File(DEFAULT_DIR, "kudu");
        if (!this.kuduLocalDir.exists() && !this.kuduLocalDir.mkdirs()) {
            LOGGER.error("unable to create directory {}", (Object)this.kuduLocalDir.getAbsolutePath());
        } else if (!this.kuduLocalDir.isDirectory()) {
            LOGGER.error("{} exists but is not a directory", (Object)this.kuduLocalDir.getAbsolutePath());
        }
        this.kuduBldr = new MiniKuduCluster.MiniKuduClusterBuilder().numMasterServers(1).numTabletServers(numTablets).clusterRoot(this.kuduLocalDir.getAbsolutePath());
    }

    public String getMasterAddressesAsString() {
        if (this.kudu == null) {
            return "<master not running>";
        }
        return this.kudu.getMasterAddressesAsString();
    }

    public boolean start() {
        try {
            this.startKuduLocal();
        }
        catch (IOException | InterruptedException e) {
            LOGGER.error("Kudu start error: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        return this.kudu != null;
    }

    public void stop() throws IOException {
        this.kudu.killAllTabletServers();
        this.kudu.killAllMasterServers();
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void destroyDB() throws IOException {
        try {
            FileUtils.deleteDirectory((File)this.kuduLocalDir);
        }
        catch (IOException e) {
            LOGGER.error("Could not destroy database files", (Throwable)e);
            throw e;
        }
    }

    private void startKuduLocal() throws ExecuteException, IOException, InterruptedException {
        if (!this.kuduLocalDir.exists() && !this.kuduLocalDir.mkdirs()) {
            LOGGER.error("unable to create directory {}", (Object)this.kuduLocalDir.getAbsolutePath());
        } else if (!this.kuduLocalDir.isDirectory()) {
            LOGGER.error("{} exists but is not a directory", (Object)this.kuduLocalDir.getAbsolutePath());
        }
        if (this.kudu == null) {
            this.kudu = this.kuduBldr.build();
        }
        Thread.sleep(1500L);
    }

    public static void main(String[] args) {
        KuduLocal kudu = new KuduLocal(null, 1);
        kudu.start();
    }
}

