/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Writer;
import org.locationtech.geowave.core.store.cli.remote.options.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.remote.options.IndexLoader;
import org.locationtech.geowave.core.store.cli.remote.options.IndexPluginOptions;
import org.locationtech.geowave.core.store.cli.remote.options.StoreLoader;
import org.locationtech.geowave.format.landsat8.AnalyzeRunner;
import org.locationtech.geowave.format.landsat8.BandFeatureIterator;
import org.locationtech.geowave.format.landsat8.Landsat8BasicCommandLineOptions;
import org.locationtech.geowave.format.landsat8.Landsat8DownloadCommandLineOptions;
import org.locationtech.geowave.format.landsat8.Landsat8RasterIngestCommandLineOptions;
import org.locationtech.geowave.format.landsat8.RasterIngestRunner;
import org.locationtech.geowave.format.landsat8.SceneFeatureIterator;
import org.locationtech.geowave.format.landsat8.VectorIngestRunner;
import org.locationtech.geowave.format.landsat8.VectorOverrideCommandLineOptions;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IngestRunner
extends RasterIngestRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(IngestRunner.class);
    private Writer<SimpleFeature> bandWriter;
    private Writer<SimpleFeature> sceneWriter;
    private final VectorOverrideCommandLineOptions vectorOverrideOptions;
    private SimpleFeatureType sceneType;

    public IngestRunner(Landsat8BasicCommandLineOptions analyzeOptions, Landsat8DownloadCommandLineOptions downloadOptions, Landsat8RasterIngestCommandLineOptions ingestOptions, VectorOverrideCommandLineOptions vectorOverrideOptions, List<String> parameters) {
        super(analyzeOptions, downloadOptions, ingestOptions, parameters);
        this.vectorOverrideOptions = vectorOverrideOptions;
    }

    @Override
    protected void processParameters(OperationParams params) throws Exception {
        Index[] vectorIndices;
        DataStore vectorStore;
        super.processParameters(params);
        File configFile = (File)params.getContext().get("properties-file");
        if (this.vectorOverrideOptions.getVectorStore() != null && !this.vectorOverrideOptions.getVectorStore().trim().isEmpty()) {
            String vectorStoreName = this.vectorOverrideOptions.getVectorStore();
            StoreLoader vectorStoreLoader = new StoreLoader(vectorStoreName);
            if (!vectorStoreLoader.loadFromConfig(configFile)) {
                throw new ParameterException("Cannot find vector store name: " + vectorStoreLoader.getStoreName());
            }
            DataStorePluginOptions vectorStoreOptions = vectorStoreLoader.getDataStorePlugin();
            vectorStore = vectorStoreOptions.createDataStore();
        } else {
            vectorStore = this.store;
        }
        if (this.vectorOverrideOptions.getVectorIndex() != null && !this.vectorOverrideOptions.getVectorIndex().trim().isEmpty()) {
            String vectorIndexList = this.vectorOverrideOptions.getVectorIndex();
            IndexLoader indexLoader = new IndexLoader(vectorIndexList);
            if (!indexLoader.loadFromConfig(configFile)) {
                throw new ParameterException("Cannot find index(s) by name: " + vectorIndexList);
            }
            List indexOptions = indexLoader.getLoadedIndexes();
            vectorIndices = new Index[indexOptions.size()];
            int i = 0;
            for (IndexPluginOptions dimensionType : indexOptions) {
                Index primaryIndex = dimensionType.createIndex();
                if (primaryIndex == null) {
                    LOGGER.error("Could not get index instance, getIndex() returned null;");
                    throw new IOException("Could not get index instance, getIndex() returned null");
                }
                vectorIndices[i++] = primaryIndex;
            }
        } else {
            vectorIndices = this.indices;
        }
        this.sceneType = SceneFeatureIterator.createFeatureType();
        FeatureDataAdapter sceneAdapter = new FeatureDataAdapter(this.sceneType);
        vectorStore.addType((DataTypeAdapter)sceneAdapter, vectorIndices);
        this.sceneWriter = vectorStore.createWriter(sceneAdapter.getTypeName());
        SimpleFeatureType bandType = BandFeatureIterator.createFeatureType(this.sceneType);
        FeatureDataAdapter bandAdapter = new FeatureDataAdapter(bandType);
        vectorStore.addType((DataTypeAdapter)bandAdapter, vectorIndices);
        this.bandWriter = vectorStore.createWriter(bandAdapter.getTypeName());
    }

    @Override
    protected void nextBand(SimpleFeature band, AnalyzeRunner.AnalysisInfo analysisInfo) {
        this.bandWriter.write((Object)band);
        super.nextBand(band, analysisInfo);
    }

    @Override
    protected void nextScene(SimpleFeature firstBandOfScene, AnalyzeRunner.AnalysisInfo analysisInfo) {
        VectorIngestRunner.writeScene(this.sceneType, firstBandOfScene, this.sceneWriter);
        super.nextScene(firstBandOfScene, analysisInfo);
    }

    @Override
    protected void runInternal(OperationParams params) throws Exception {
        try {
            super.runInternal(params);
        }
        finally {
            if (this.sceneWriter != null) {
                this.sceneWriter.close();
            }
            if (this.bandWriter != null) {
                this.bandWriter.close();
            }
        }
    }
}

