/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import org.apache.commons.lang.ArrayUtils;
import org.geotools.data.DataUtilities;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNotEqualTo;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.AnyInteracts;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.Meets;
import org.opengis.filter.temporal.MetBy;
import org.opengis.filter.temporal.OverlappedBy;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.filter.temporal.TOverlaps;

public class PropertyIgnoringFilterVisitor
extends DuplicatingFilterVisitor {
    private final String[] validPropertyNames;
    private final SimpleFeatureType type;

    public PropertyIgnoringFilterVisitor(String[] validPropertyNames, SimpleFeatureType type) {
        this.validPropertyNames = validPropertyNames;
        this.type = type;
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(BBOX filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Beyond filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Contains filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Crosses filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Disjoint filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(DWithin filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Equals filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Intersects filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Overlaps filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Touches filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(Within filter, Object extraData) {
        if (!this.usesProperty((Filter)filter)) {
            return Filter.INCLUDE;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(After after, Object extraData) {
        if (!this.usesProperty((Filter)after)) {
            return Filter.INCLUDE;
        }
        return super.visit(after, extraData);
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        if (!this.usesProperty((Filter)anyInteracts)) {
            return Filter.INCLUDE;
        }
        return super.visit(anyInteracts, extraData);
    }

    public Object visit(Before before, Object extraData) {
        if (!this.usesProperty((Filter)before)) {
            return Filter.INCLUDE;
        }
        return super.visit(before, extraData);
    }

    public Object visit(Begins begins, Object extraData) {
        if (!this.usesProperty((Filter)begins)) {
            return Filter.INCLUDE;
        }
        return super.visit(begins, extraData);
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        if (!this.usesProperty((Filter)begunBy)) {
            return Filter.INCLUDE;
        }
        return super.visit(begunBy, extraData);
    }

    public Object visit(During during, Object extraData) {
        if (!this.usesProperty((Filter)during)) {
            return Filter.INCLUDE;
        }
        return super.visit(during, extraData);
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        if (!this.usesProperty((Filter)endedBy)) {
            return Filter.INCLUDE;
        }
        return super.visit(endedBy, extraData);
    }

    public Object visit(Ends ends, Object extraData) {
        if (!this.usesProperty((Filter)ends)) {
            return Filter.INCLUDE;
        }
        return super.visit(ends, extraData);
    }

    public Object visit(Meets meets, Object extraData) {
        if (!this.usesProperty((Filter)meets)) {
            return Filter.INCLUDE;
        }
        return super.visit(meets, extraData);
    }

    public Object visit(MetBy metBy, Object extraData) {
        if (!this.usesProperty((Filter)metBy)) {
            return Filter.INCLUDE;
        }
        return super.visit(metBy, extraData);
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        if (!this.usesProperty((Filter)overlappedBy)) {
            return Filter.INCLUDE;
        }
        return super.visit(overlappedBy, extraData);
    }

    public Object visit(TContains contains, Object extraData) {
        if (!this.usesProperty((Filter)contains)) {
            return Filter.INCLUDE;
        }
        return super.visit(contains, extraData);
    }

    public Object visit(TEquals equals, Object extraData) {
        if (!this.usesProperty((Filter)equals)) {
            return Filter.INCLUDE;
        }
        return super.visit(equals, extraData);
    }

    public Object visit(TOverlaps contains, Object extraData) {
        if (!this.usesProperty((Filter)contains)) {
            return Filter.INCLUDE;
        }
        return super.visit(contains, extraData);
    }

    private boolean usesProperty(Filter filter) {
        String[] attributes;
        for (String attr : attributes = DataUtilities.attributeNames((Filter)filter, (SimpleFeatureType)this.type)) {
            if (ArrayUtils.contains((Object[])this.validPropertyNames, (Object)attr)) continue;
            return false;
        }
        return true;
    }
}

