/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.geowave.adapter.vector.FeatureDataAdapter;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.store.api.DataStore;
import org.locationtech.geowave.core.store.api.DataTypeAdapter;
import org.locationtech.geowave.core.store.api.Index;
import org.locationtech.geowave.core.store.api.Writer;
import org.locationtech.geowave.core.store.cli.remote.options.DataStorePluginOptions;
import org.locationtech.geowave.core.store.cli.remote.options.IndexLoader;
import org.locationtech.geowave.core.store.cli.remote.options.IndexPluginOptions;
import org.locationtech.geowave.core.store.cli.remote.options.StoreLoader;
import org.locationtech.geowave.format.landsat8.AnalyzeRunner;
import org.locationtech.geowave.format.landsat8.BandFeatureIterator;
import org.locationtech.geowave.format.landsat8.Landsat8BasicCommandLineOptions;
import org.locationtech.geowave.format.landsat8.RasterIngestRunner;
import org.locationtech.geowave.format.landsat8.SceneFeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorIngestRunner
extends AnalyzeRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RasterIngestRunner.class);
    protected final List<String> parameters;
    private Writer bandWriter;
    private Writer sceneWriter;
    private SimpleFeatureType sceneType;

    public VectorIngestRunner(Landsat8BasicCommandLineOptions analyzeOptions, List<String> parameters) {
        super(analyzeOptions);
        this.parameters = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runInternal(OperationParams params) throws Exception {
        try {
            if (this.parameters.size() != 2) {
                throw new ParameterException("Requires arguments: <storename> <comma delimited index/group list>");
            }
            String inputStoreName = this.parameters.get(0);
            String indexList = this.parameters.get(1);
            StoreLoader inputStoreLoader = new StoreLoader(inputStoreName);
            File configFile = (File)params.getContext().get("properties-file");
            if (!inputStoreLoader.loadFromConfig(configFile)) {
                throw new ParameterException("Cannot find store name: " + inputStoreLoader.getStoreName());
            }
            DataStorePluginOptions storeOptions = inputStoreLoader.getDataStorePlugin();
            DataStore store = storeOptions.createDataStore();
            IndexLoader indexLoader = new IndexLoader(indexList);
            if (!indexLoader.loadFromConfig(configFile)) {
                throw new ParameterException("Cannot find index(s) by name: " + indexList);
            }
            List indexOptions = indexLoader.getLoadedIndexes();
            Index[] indices = new Index[indexOptions.size()];
            int i = 0;
            for (IndexPluginOptions dimensionType : indexOptions) {
                Index primaryIndex = dimensionType.createIndex();
                if (primaryIndex == null) {
                    LOGGER.error("Could not get index instance, getIndex() returned null;");
                    throw new IOException("Could not get index instance, getIndex() returned null");
                }
                indices[i++] = primaryIndex;
            }
            this.sceneType = SceneFeatureIterator.createFeatureType();
            FeatureDataAdapter sceneAdapter = new FeatureDataAdapter(this.sceneType);
            store.addType((DataTypeAdapter)sceneAdapter, indices);
            this.sceneWriter = store.createWriter(sceneAdapter.getTypeName());
            SimpleFeatureType bandType = BandFeatureIterator.createFeatureType(this.sceneType);
            FeatureDataAdapter bandAdapter = new FeatureDataAdapter(bandType);
            store.addType((DataTypeAdapter)bandAdapter, indices);
            this.bandWriter = store.createWriter(bandAdapter.getTypeName());
            super.runInternal(params);
        }
        finally {
            if (this.sceneWriter != null) {
                this.sceneWriter.close();
            }
            if (this.bandWriter != null) {
                this.bandWriter.close();
            }
        }
    }

    @Override
    protected void nextBand(SimpleFeature band, AnalyzeRunner.AnalysisInfo analysisInfo) {
        this.bandWriter.write((Object)band);
        super.nextBand(band, analysisInfo);
    }

    @Override
    protected void nextScene(SimpleFeature firstBandOfScene, AnalyzeRunner.AnalysisInfo analysisInfo) {
        VectorIngestRunner.writeScene(this.sceneType, firstBandOfScene, this.sceneWriter);
        super.nextScene(firstBandOfScene, analysisInfo);
    }

    public static void writeScene(SimpleFeatureType sceneType, SimpleFeature firstBandOfScene, Writer sceneWriter) {
        SimpleFeatureBuilder bldr = new SimpleFeatureBuilder(sceneType);
        String fid = null;
        for (int i = 0; i < sceneType.getAttributeCount(); ++i) {
            AttributeDescriptor attr = sceneType.getDescriptor(i);
            String attrName = attr.getLocalName();
            Object attrValue = firstBandOfScene.getAttribute(attrName);
            if (attrValue == null) continue;
            bldr.set(i, attrValue);
            if (!attrName.equals("entityId")) continue;
            fid = attrValue.toString();
        }
        if (fid != null) {
            sceneWriter.write((Object)bldr.buildFeature(fid));
        }
    }
}

