/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.locationtech.geowave.format.landsat8.AnalyzeRunner;
import org.locationtech.geowave.format.landsat8.Landsat8BasicCommandLineOptions;
import org.locationtech.geowave.format.landsat8.Landsat8DownloadCommandLineOptions;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadRunner
extends AnalyzeRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadRunner.class);
    private static final int DOWNLOAD_RETRY = 5;
    private static final String DOWNLOAD_DIRECTORY = "images";
    protected Landsat8DownloadCommandLineOptions downloadOptions;

    public DownloadRunner(Landsat8BasicCommandLineOptions analyzeOptions, Landsat8DownloadCommandLineOptions downloadOptions) {
        super(analyzeOptions);
        this.downloadOptions = downloadOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nextBand(SimpleFeature band, AnalyzeRunner.AnalysisInfo analysisInfo) {
        File localTempPath;
        super.nextBand(band, analysisInfo);
        String downloadUrl = (String)band.getAttribute("bandDownloadUrl");
        File localPath = DownloadRunner.getDownloadFile(band, this.landsatOptions.getWorkspaceDir());
        if (localPath.exists()) {
            if (this.downloadOptions.isOverwriteIfExists()) {
                if (!localPath.delete()) {
                    LOGGER.warn("Unable to delete file '" + localPath.getAbsolutePath() + "'");
                }
            } else {
                return;
            }
        }
        if ((localTempPath = DownloadRunner.getDownloadTempFile(band, this.landsatOptions.getWorkspaceDir())).exists() && !localTempPath.delete()) {
            LOGGER.error("Unable to delete file '" + localTempPath.getAbsolutePath() + "'");
        }
        if (!localPath.getParentFile().exists() && !localPath.getParentFile().mkdirs()) {
            LOGGER.warn("Unable to create directory '" + localPath.getParentFile().getAbsolutePath() + "'");
        }
        InputStream in = null;
        int retry = 0;
        boolean success = false;
        while (!success && retry < 5) {
            try {
                if (retry > 0) {
                    Thread.sleep(1000L);
                }
                in = new URL(downloadUrl).openStream();
                success = true;
                FileOutputStream outStream = new FileOutputStream(localTempPath);
                IOUtils.copyLarge((InputStream)in, (OutputStream)outStream);
                outStream.close();
                FileUtils.moveFile((File)localTempPath, (File)localPath);
                if (in == null) continue;
            }
            catch (IOException | InterruptedException e) {
                try {
                    LOGGER.error("Unable to read image from public S3 '" + downloadUrl + "'; retry round " + ++retry, (Throwable)e);
                    if (in == null) continue;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        IOUtils.closeQuietly(in);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                continue;
            }
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    protected static File getDownloadTempFile(SimpleFeature band, String workspaceDirectory) {
        File file = DownloadRunner.getDownloadFile(band, workspaceDirectory);
        return new File(file.getParentFile(), file.getName() + ".download");
    }

    protected static File getDownloadFile(SimpleFeature band, String workspaceDirectory) {
        int path = (Integer)band.getAttribute("path");
        int row = (Integer)band.getAttribute("row");
        String entity = (String)band.getAttribute("entityId");
        return new File(workspaceDirectory + File.separator + DOWNLOAD_DIRECTORY + File.separator + path + File.separator + row + File.separator + entity + File.separator + band.getID() + ".TIF");
    }
}

