/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import it.geosolutions.jaiext.JAIExt;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.Command;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.format.landsat8.IngestRunner;
import org.locationtech.geowave.format.landsat8.Landsat8BasicCommandLineOptions;
import org.locationtech.geowave.format.landsat8.Landsat8DownloadCommandLineOptions;
import org.locationtech.geowave.format.landsat8.Landsat8RasterIngestCommandLineOptions;
import org.locationtech.geowave.format.landsat8.Landsat8Section;
import org.locationtech.geowave.format.landsat8.VectorOverrideCommandLineOptions;

@GeowaveOperation(name={"ingest"}, parentOperation=Landsat8Section.class)
@Parameters(commandDescription="Ingest routine for locally downloading Landsat 8 imagery and ingesting it into GeoWave's raster store and in parallel ingesting the scene metadata into GeoWave's vector store.  These two stores can actually be the same or they can be different.")
public class Landsat8IngestCommand
extends DefaultOperation
implements Command {
    @Parameter(description="<store name> <comma delimited index list>")
    private List<String> parameters = new ArrayList<String>();
    @ParametersDelegate
    protected Landsat8BasicCommandLineOptions analyzeOptions = new Landsat8BasicCommandLineOptions();
    @ParametersDelegate
    protected Landsat8DownloadCommandLineOptions downloadOptions = new Landsat8DownloadCommandLineOptions();
    @ParametersDelegate
    protected Landsat8RasterIngestCommandLineOptions ingestOptions = new Landsat8RasterIngestCommandLineOptions();
    @ParametersDelegate
    protected VectorOverrideCommandLineOptions vectorOverrideOptions = new VectorOverrideCommandLineOptions();

    public void execute(OperationParams params) throws Exception {
        JAIExt.initJAIEXT();
        IngestRunner runner = new IngestRunner(this.analyzeOptions, this.downloadOptions, this.ingestOptions, this.vectorOverrideOptions, this.parameters);
        runner.runInternal(params);
    }
}

