/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.io.LineReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geowave.core.geotime.util.GeometryUtils;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.format.landsat8.PropertyIgnoringFilterVisitor;
import org.locationtech.geowave.format.landsat8.WRS2GeometryStore;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneFeatureIterator
implements SimpleFeatureIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SceneFeatureIterator.class);
    private static final String SCENES_GZ_URL = "http://landsat-pds.s3.amazonaws.com/scene_list.gz";
    protected static final String SCENES_TYPE_NAME = "scene";
    public static final String SHAPE_ATTRIBUTE_NAME = "shape";
    public static final String ACQUISITION_DATE_ATTRIBUTE_NAME = "acquisitionDate";
    public static final String CLOUD_COVER_ATTRIBUTE_NAME = "cloudCover";
    public static final String PROCESSING_LEVEL_ATTRIBUTE_NAME = "processingLevel";
    public static final String PATH_ATTRIBUTE_NAME = "path";
    public static final String ROW_ATTRIBUTE_NAME = "row";
    public static final String SCENE_DOWNLOAD_ATTRIBUTE_NAME = "sceneDownloadUrl";
    public static final String ENTITY_ID_ATTRIBUTE_NAME = "entityId";
    protected static final String[] SCENE_ATTRIBUTES = new String[]{"shape", "acquisitionDate", "cloudCover", "processingLevel", "path", "row", "entityId", "sceneDownloadUrl"};
    protected static String AQUISITION_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final String SCENES_DIR = "scenes";
    private final String COMPRESSED_FILE_NAME = "scene_list.gz";
    private final String CSV_FILE_NAME = "scene_list";
    private final String TEMP_CSV_FILE_NAME = "scene_list.tmp";
    private CSVParser parser;
    private FileInputStream parserFis;
    private InputStreamReader parserIsr;
    private Iterator<SimpleFeature> iterator;
    private SimpleFeatureType type;

    public SceneFeatureIterator(boolean onlyScenesSinceLastRun, boolean useCachedScenes, boolean nBestScenesByPathRow, int nBestScenes, Filter cqlFilter, String workspaceDir) throws MalformedURLException, IOException {
        this.init(new File(workspaceDir, "scenes"), onlyScenesSinceLastRun, useCachedScenes, nBestScenesByPathRow, nBestScenes, new WRS2GeometryStore(workspaceDir), cqlFilter);
    }

    private void init(File scenesDir, boolean onlyScenesSinceLastRun, boolean useCachedScenes, boolean nBestScenesByPathRow, int nBestScenes, WRS2GeometryStore geometryStore, Filter cqlFilter) throws IOException {
        long startLine;
        File csvFile;
        block43: {
            BufferedInputStream bin;
            FileInputStream fin;
            GzipCompressorInputStream gzIn;
            File tempCsvFile;
            block41: {
                if (!scenesDir.exists() && !scenesDir.mkdirs()) {
                    LOGGER.warn("Unable to create directory '" + scenesDir.getAbsolutePath() + "'");
                }
                csvFile = new File(scenesDir, "scene_list");
                startLine = 0L;
                if (csvFile.exists() && useCachedScenes) break block43;
                File compressedFile = new File(scenesDir, "scene_list.gz");
                tempCsvFile = new File(scenesDir, "scene_list.tmp");
                if (compressedFile.exists() && !compressedFile.delete()) {
                    LOGGER.warn("Unable to delete '" + compressedFile.getAbsolutePath() + "'");
                }
                if (tempCsvFile.exists() && !tempCsvFile.delete()) {
                    LOGGER.warn("Unable to delete '" + tempCsvFile.getAbsolutePath() + "'");
                }
                InputStream in = null;
                FileOutputStream outStream = new FileOutputStream(compressedFile);
                try {
                    in = new URL(SCENES_GZ_URL).openStream();
                    IOUtils.copyLarge((InputStream)in, (OutputStream)outStream);
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to read scenes from public S3", (Throwable)e);
                    throw e;
                }
                finally {
                    if (outStream != null) {
                        outStream.close();
                    }
                    if (in != null) {
                        IOUtils.closeQuietly((InputStream)in);
                    }
                }
                gzIn = null;
                FileOutputStream out = null;
                fin = null;
                bin = null;
                try {
                    fin = new FileInputStream(compressedFile);
                    bin = new BufferedInputStream(fin);
                    out = new FileOutputStream(tempCsvFile);
                    gzIn = new GzipCompressorInputStream((InputStream)bin);
                    byte[] buffer = new byte[1024];
                    int n = 0;
                    while (-1 != (n = gzIn.read(buffer))) {
                        out.write(buffer, 0, n);
                    }
                    fin.close();
                    if (!compressedFile.delete()) {
                        LOGGER.warn("Unable to delete '" + compressedFile.getAbsolutePath() + "'");
                    }
                    out.close();
                    if (out == null) break block41;
                }
                catch (IOException e) {
                    try {
                        LOGGER.warn("Unable to extract scenes file", (Throwable)e);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (out != null) {
                            IOUtils.closeQuietly(out);
                        }
                        if (gzIn != null) {
                            IOUtils.closeQuietly(gzIn);
                        }
                        if (fin != null) {
                            IOUtils.closeQuietly((InputStream)fin);
                        }
                        if (bin != null) {
                            IOUtils.closeQuietly((InputStream)bin);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
            if (gzIn != null) {
                IOUtils.closeQuietly((InputStream)gzIn);
            }
            if (fin != null) {
                IOUtils.closeQuietly((InputStream)fin);
            }
            if (bin != null) {
                IOUtils.closeQuietly((InputStream)bin);
            }
            if (onlyScenesSinceLastRun && csvFile.exists()) {
                try (FileInputStream is = new FileInputStream(csvFile);){
                    LineReader lines = new LineReader((Readable)new InputStreamReader((InputStream)is, StringUtils.UTF8_CHARSET));
                    while (lines.readLine() != null) {
                        ++startLine;
                    }
                }
            }
            if (csvFile.exists() && !csvFile.delete()) {
                LOGGER.warn("Unable to delete '" + csvFile.getAbsolutePath() + "'");
            }
            if (!tempCsvFile.renameTo(csvFile)) {
                LOGGER.warn("Unable to rename '" + tempCsvFile.getAbsolutePath() + "' to '" + csvFile.getAbsolutePath() + "'");
            }
        }
        this.type = SceneFeatureIterator.createFeatureType();
        this.setupCsvToFeatureIterator(csvFile, startLine, geometryStore, cqlFilter);
        if (nBestScenes > 0) {
            this.nBestScenes(nBestScenesByPathRow, nBestScenes);
        }
    }

    public static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(SCENES_TYPE_NAME);
        typeBuilder.setCRS(GeometryUtils.getDefaultCRS());
        typeBuilder.add(SHAPE_ATTRIBUTE_NAME, MultiPolygon.class);
        typeBuilder.add(ENTITY_ID_ATTRIBUTE_NAME, String.class);
        typeBuilder.add(ACQUISITION_DATE_ATTRIBUTE_NAME, Date.class);
        typeBuilder.add(CLOUD_COVER_ATTRIBUTE_NAME, Float.class);
        typeBuilder.add(PROCESSING_LEVEL_ATTRIBUTE_NAME, String.class);
        typeBuilder.add(PATH_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(ROW_ATTRIBUTE_NAME, Integer.class);
        typeBuilder.add(SCENE_DOWNLOAD_ATTRIBUTE_NAME, String.class);
        return typeBuilder.buildFeatureType();
    }

    private boolean hasOtherProperties(Filter cqlFilter) {
        String[] attributes;
        for (String attr : attributes = DataUtilities.attributeNames((Filter)cqlFilter, (SimpleFeatureType)this.type)) {
            if (ArrayUtils.contains((Object[])SCENE_ATTRIBUTES, (Object)attr)) continue;
            return true;
        }
        return false;
    }

    private void nBestScenes(boolean byPathRow, int n) {
        this.iterator = SceneFeatureIterator.nBestScenes(this, byPathRow, n);
    }

    protected static Iterator<SimpleFeature> nBestScenes(SimpleFeatureIterator iterator, boolean byPathRow, int n) {
        if (byPathRow) {
            HashMap<PathRowPair, MinMaxPriorityQueue> bestScenes = new HashMap<PathRowPair, MinMaxPriorityQueue>();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Integer path = (Integer)feature.getAttribute(PATH_ATTRIBUTE_NAME);
                Integer row = (Integer)feature.getAttribute(ROW_ATTRIBUTE_NAME);
                PathRowPair pr = new PathRowPair(path, row);
                MinMaxPriorityQueue queue = (MinMaxPriorityQueue)bestScenes.get(pr);
                if (queue == null) {
                    queue = MinMaxPriorityQueue.orderedBy((Comparator)new BestCloudCoverComparator()).maximumSize(n).create();
                    bestScenes.put(pr, queue);
                }
                queue.offer((Object)feature);
            }
            ArrayList<Iterator> iterators = new ArrayList<Iterator>();
            for (MinMaxPriorityQueue queue : bestScenes.values()) {
                iterators.add(queue.iterator());
            }
            return Iterators.concat(iterators.iterator());
        }
        MinMaxPriorityQueue bestScenes = MinMaxPriorityQueue.orderedBy((Comparator)new BestCloudCoverComparator()).maximumSize(n).create();
        while (iterator.hasNext()) {
            bestScenes.offer((Object)iterator.next());
        }
        iterator.close();
        return bestScenes.iterator();
    }

    private void setupCsvToFeatureIterator(File csvFile, long startLine, WRS2GeometryStore geometryStore, Filter cqlFilter) throws FileNotFoundException, IOException {
        this.parserFis = new FileInputStream(csvFile);
        this.parserIsr = new InputStreamReader((InputStream)this.parserFis, StringUtils.UTF8_CHARSET);
        this.parser = new CSVParser((Reader)this.parserIsr, CSVFormat.DEFAULT.withHeader(new String[0]).withSkipHeaderRecord());
        Iterator csvIterator = this.parser.iterator();
        for (long startLineDecrementor = startLine; startLineDecrementor > 1L && csvIterator.hasNext(); --startLineDecrementor) {
            csvIterator.next();
        }
        this.iterator = Iterators.transform((Iterator)csvIterator, (Function)new CSVToFeatureTransform(geometryStore, this.type));
        if (cqlFilter != null) {
            Filter actualFilter;
            if (this.hasOtherProperties(cqlFilter)) {
                PropertyIgnoringFilterVisitor visitor = new PropertyIgnoringFilterVisitor(SCENE_ATTRIBUTES, this.type);
                actualFilter = (Filter)cqlFilter.accept((FilterVisitor)visitor, null);
            } else {
                actualFilter = cqlFilter;
            }
            CqlFilterPredicate filterPredicate = new CqlFilterPredicate(actualFilter);
            this.iterator = Iterators.filter(this.iterator, (Predicate)filterPredicate);
        }
    }

    public SimpleFeatureType getFeatureType() {
        return this.type;
    }

    public void close() {
        if (this.parser != null) {
            try {
                this.parser.close();
                this.parser = null;
                this.parserFis.close();
                this.parserFis = null;
                this.parserIsr.close();
                this.parserIsr = null;
            }
            catch (IOException e) {
                LOGGER.warn("Unable to close CSV parser", (Object)this.parser, (Object)e);
            }
        }
    }

    public boolean hasNext() {
        if (this.iterator != null) {
            return this.iterator.hasNext();
        }
        return false;
    }

    public SimpleFeature next() throws NoSuchElementException {
        if (this.iterator != null) {
            return this.iterator.next();
        }
        return null;
    }

    private static class CqlFilterPredicate
    implements Predicate<SimpleFeature> {
        private final Filter cqlFilter;

        public CqlFilterPredicate(Filter cqlFilter) {
            this.cqlFilter = cqlFilter;
        }

        public boolean apply(SimpleFeature input) {
            return this.cqlFilter.evaluate((Object)input);
        }
    }

    private static class CSVToFeatureTransform
    implements Function<CSVRecord, SimpleFeature> {
        private final WRS2GeometryStore wrs2Geometry;
        private final SimpleFeatureBuilder featureBuilder;

        public CSVToFeatureTransform(WRS2GeometryStore wrs2Geometry, SimpleFeatureType type) {
            this.wrs2Geometry = wrs2Geometry;
            this.featureBuilder = new SimpleFeatureBuilder(type);
        }

        public SimpleFeature apply(CSVRecord input) {
            if (input == null) {
                return null;
            }
            String entityId = input.get(SceneFeatureIterator.ENTITY_ID_ATTRIBUTE_NAME);
            double cloudCover = Double.parseDouble(input.get(SceneFeatureIterator.CLOUD_COVER_ATTRIBUTE_NAME));
            String processingLevel = input.get(SceneFeatureIterator.PROCESSING_LEVEL_ATTRIBUTE_NAME);
            int path = Integer.parseInt(input.get(SceneFeatureIterator.PATH_ATTRIBUTE_NAME));
            int row = Integer.parseInt(input.get(SceneFeatureIterator.ROW_ATTRIBUTE_NAME));
            String downloadUrl = input.get("download_url");
            MultiPolygon shape = this.wrs2Geometry.getGeometry(path, row);
            this.featureBuilder.add((Object)shape);
            this.featureBuilder.add((Object)entityId);
            SimpleDateFormat sdf = new SimpleDateFormat(AQUISITION_DATE_FORMAT);
            try {
                Date aquisitionDate = sdf.parse(input.get(SceneFeatureIterator.ACQUISITION_DATE_ATTRIBUTE_NAME));
                this.featureBuilder.add((Object)aquisitionDate);
            }
            catch (ParseException e) {
                LOGGER.warn("Unable to parse aquisition date", (Throwable)e);
                this.featureBuilder.add(null);
            }
            this.featureBuilder.add((Object)cloudCover);
            this.featureBuilder.add((Object)processingLevel);
            this.featureBuilder.add((Object)path);
            this.featureBuilder.add((Object)row);
            this.featureBuilder.add((Object)downloadUrl);
            return this.featureBuilder.buildFeature(entityId);
        }
    }

    private static class PathRowPair {
        private final int path;
        private final int row;

        public PathRowPair(int path, int row) {
            this.path = path;
            this.row = row;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.path;
            result = 31 * result + this.row;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathRowPair other = (PathRowPair)obj;
            if (this.path != other.path) {
                return false;
            }
            return this.row == other.row;
        }
    }

    protected static class BestCloudCoverComparator
    implements Comparator<SimpleFeature>,
    Serializable {
        private static final long serialVersionUID = -5294130929073387335L;

        protected BestCloudCoverComparator() {
        }

        @Override
        public int compare(SimpleFeature first, SimpleFeature second) {
            return Float.compare(((Float)first.getAttribute(SceneFeatureIterator.CLOUD_COVER_ATTRIBUTE_NAME)).floatValue(), ((Float)second.getAttribute(SceneFeatureIterator.CLOUD_COVER_ATTRIBUTE_NAME)).floatValue());
        }
    }
}

