/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.jts.geom.MultiPolygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WRS2GeometryStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(WRS2GeometryStore.class);
    private static final String WRS2_TYPE_NAME = "WRS2_descending";
    private static final String WRS2_SHAPE_URL = "https://landsat.usgs.gov/sites/default/files/documents/WRS2_descending.zip";
    private static final String WRS2_SHAPE_NAME = "WRS2_descending.shp";
    private static final String WRS2_SHAPE_ZIP = "WRS2_descending.zip";
    protected static final String WRS2_SHAPE_DIRECTORY = "WRS2_descending";
    private final File wrs2Shape;
    private final File wrs2Directory;
    private final Map<WRS2Key, MultiPolygon> featureCache = new HashMap<WRS2Key, MultiPolygon>();
    private SimpleFeatureType wrs2Type;

    public WRS2GeometryStore(String workspaceDirectory) throws MalformedURLException, IOException {
        this.wrs2Directory = new File(workspaceDirectory, "WRS2_descending");
        this.wrs2Shape = new File(this.wrs2Directory, WRS2_SHAPE_NAME);
        this.init();
    }

    public SimpleFeatureType getType() {
        return this.wrs2Type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws MalformedURLException, IOException {
        if (!this.wrs2Shape.exists()) {
            File targetFile;
            File wsDir;
            if (!this.wrs2Directory.delete()) {
                LOGGER.warn("Unable to delete '" + this.wrs2Directory.getAbsolutePath() + "'");
            }
            if (!(wsDir = this.wrs2Directory.getParentFile()).exists() && !wsDir.mkdirs()) {
                LOGGER.warn("Unable to create directory '" + wsDir.getAbsolutePath() + "'");
            }
            if (!this.wrs2Directory.mkdirs()) {
                LOGGER.warn("Unable to create directory '" + this.wrs2Directory.getAbsolutePath() + "'");
            }
            if ((targetFile = new File(this.wrs2Directory, WRS2_SHAPE_ZIP)).exists() && !targetFile.delete()) {
                LOGGER.warn("Unable to delete file '" + targetFile.getAbsolutePath() + "'");
            }
            FileUtils.copyURLToFile((URL)new URL(WRS2_SHAPE_URL), (File)targetFile);
            try (ZipFile zipFile = new ZipFile(targetFile);){
                Enumeration entries = zipFile.getEntries();
                while (entries.hasMoreElements()) {
                    ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                    if (entry.isDirectory()) continue;
                    FileUtils.copyInputStreamToFile((InputStream)zipFile.getInputStream(entry), (File)new File(this.wrs2Directory, entry.getName()));
                }
            }
        }
        try {
            HashMap<String, URL> map = new HashMap<String, URL>();
            map.put("url", this.wrs2Shape.toURI().toURL());
            DataStore dataStore = DataStoreFinder.getDataStore(map);
            if (dataStore == null) {
                LOGGER.error("Unable to get a datastore instance, getDataStore returned null");
                return;
            }
            SimpleFeatureSource source = dataStore.getFeatureSource("WRS2_descending");
            SimpleFeatureCollection featureCollection = source.getFeatures();
            this.wrs2Type = (SimpleFeatureType)featureCollection.getSchema();
            SimpleFeatureIterator iterator = featureCollection.features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Number path = (Number)feature.getAttribute("PATH");
                Number row = (Number)feature.getAttribute("ROW");
                this.featureCache.put(new WRS2Key(path.intValue(), row.intValue()), (MultiPolygon)feature.getDefaultGeometry());
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to read wrs2_asc_desc shapefile '" + this.wrs2Shape.getAbsolutePath() + "'", (Throwable)e);
            throw e;
        }
    }

    public MultiPolygon getGeometry(int path, int row) {
        return this.featureCache.get(new WRS2Key(path, row));
    }

    protected static class WRS2Key {
        private final int path;
        private final int row;

        public WRS2Key(int path, int row) {
            this.path = path;
            this.row = row;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.path;
            result = 31 * result + this.row;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WRS2Key other = (WRS2Key)obj;
            if (this.path != other.path) {
                return false;
            }
            return this.row == other.row;
        }
    }
}

