/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8.qa;

import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.locationtech.geowave.format.landsat8.Landsat8BandConverterSpi;
import org.opengis.feature.simple.SimpleFeature;

public class QABandToIceMaskConverter
implements Landsat8BandConverterSpi {
    private static final int doubleBitMask = 3;
    private static final int tripleBitMask = 7;

    @Override
    public GridCoverage2D convert(String coverageName, GridCoverage2D originalBandData, SimpleFeature bandMetadata) {
        Object attrValue = bandMetadata.getAttribute("band");
        if ("BQA".equalsIgnoreCase(attrValue.toString())) {
            MultiPixelPackedSampleModel newSampleModel = new MultiPixelPackedSampleModel(0, originalBandData.getRenderedImage().getWidth(), originalBandData.getRenderedImage().getHeight(), 2);
            WritableRaster nextRaster = Raster.createWritableRaster(newSampleModel, null);
            RenderedImage image = originalBandData.getRenderedImage();
            Raster data = image.getData();
            for (int x = 0; x < data.getWidth(); ++x) {
                for (int y = 0; y < data.getHeight(); ++y) {
                    int sample = this.getIceSample(x, y, data);
                    nextRaster.setSample(x, y, 0, sample);
                }
            }
            GridCoverage2D nextCov = new GridCoverageFactory().create((CharSequence)coverageName, nextRaster, originalBandData.getEnvelope());
            return nextCov;
        }
        return originalBandData;
    }

    private int getIceSample(int x, int y, Raster data) {
        int sample = data.getSample(x, y, 0);
        if ((sample & 7) > 0) {
            return 0;
        }
        if ((sample >> 14 & 3) == 3 || (sample >> 12 & 3) == 3) {
            return 1;
        }
        return (sample >> 10 & 3) > 1 ? 3 : 2;
    }

    @Override
    public String getName() {
        return "icemask";
    }
}

