/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8.index;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.locationtech.geowave.core.index.dimension.bin.BinRange;
import org.locationtech.geowave.core.index.dimension.bin.BinValue;
import org.locationtech.geowave.core.index.dimension.bin.BinningStrategy;
import org.locationtech.geowave.core.index.sfc.data.NumericData;
import org.locationtech.geowave.core.index.sfc.data.NumericRange;

public class Landsat8TemporalBinningStrategy
implements BinningStrategy {
    protected static final long MILLIS_PER_DAY = 86400000L;
    protected static final long BIN_SIZE_MILLIS = 353894400000L;
    protected static final long ORIGIN_MILLIS = 1420070400L;

    public double getBinMin() {
        return 0.0;
    }

    public double getBinMax() {
        return this.getBinSizeMillis() - 1L;
    }

    public BinValue getBinnedValue(double value) {
        long millisFromOrigin = (long)value - 1420070400L;
        if (millisFromOrigin < 0L) {
            int binId = (int)((millisFromOrigin - 353894400000L + 1L) / 353894400000L);
            long startOfEpochFromOrigin = (long)binId * 353894400000L;
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putInt(binId);
            return new BinValue(buf.array(), (double)(millisFromOrigin - startOfEpochFromOrigin));
        }
        int binId = (int)(millisFromOrigin / 353894400000L);
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(binId);
        return new BinValue(buf.array(), (double)(millisFromOrigin % 353894400000L));
    }

    private long getStartEpoch(byte[] binId) {
        ByteBuffer buf = ByteBuffer.wrap(binId);
        int binsFromOrigin = buf.getInt();
        long millisFromOrigin = (long)binsFromOrigin * 353894400000L;
        return 1420070400L + millisFromOrigin;
    }

    private long getBinSizeMillis() {
        return 353894400000L;
    }

    public int getFixedBinIdSize() {
        return 4;
    }

    private byte[] getBinId(long value) {
        long millisFromOrigin = value - 1420070400L;
        if (millisFromOrigin < 0L) {
            int binId = (int)((millisFromOrigin - 353894400000L + 1L) / 353894400000L);
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putInt(binId);
            return buf.array();
        }
        int binId = (int)(millisFromOrigin / 353894400000L);
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(binId);
        return buf.array();
    }

    public BinRange[] getNormalizedRanges(NumericData range) {
        long millisFromOrigin = (long)range.getMin() - 1420070400L;
        int binId = millisFromOrigin < 0L ? (int)(millisFromOrigin / 353894400000L) - 1 : (int)(millisFromOrigin / 353894400000L);
        long startOfEpochFromOrigin = (long)binId * 353894400000L;
        long epochIterator = startOfEpochFromOrigin + 1420070400L;
        ArrayList<BinRange> bins = new ArrayList<BinRange>();
        boolean firstBin = millisFromOrigin != startOfEpochFromOrigin;
        boolean lastBin = false;
        do {
            long startMillis;
            boolean fullExtent;
            long endMillis;
            long nextEpoch = epochIterator + 353894400000L;
            long maxOfBin = nextEpoch - 1L;
            if ((long)range.getMax() <= maxOfBin) {
                lastBin = true;
                endMillis = (long)range.getMax();
                fullExtent = (long)range.getMax() == maxOfBin;
            } else {
                endMillis = maxOfBin;
                boolean bl = fullExtent = !firstBin;
            }
            if (firstBin) {
                startMillis = (long)range.getMin();
                firstBin = false;
            } else {
                startMillis = epochIterator;
            }
            bins.add(new BinRange(this.getBinId(epochIterator), (double)(startMillis - epochIterator), (double)(endMillis - epochIterator), fullExtent));
            epochIterator = nextEpoch;
        } while (!lastBin);
        return bins.toArray(new BinRange[bins.size()]);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        String className = this.getClass().getName();
        result = 31 * result + (className == null ? 0 : className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public NumericRange getDenormalizedRanges(BinRange binnedRange) {
        long startOfEpochMillis = this.getStartEpoch(binnedRange.getBinId());
        long minMillis = startOfEpochMillis + (long)binnedRange.getNormalizedMin();
        long maxMillis = startOfEpochMillis + (long)binnedRange.getNormalizedMax();
        return new NumericRange((double)minMillis, (double)maxMillis);
    }

    public byte[] toBinary() {
        return new byte[0];
    }

    public void fromBinary(byte[] bytes) {
    }
}

