/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.format.landsat8.BandFeatureIterator;
import org.locationtech.geowave.format.landsat8.Landsat8BasicCommandLineOptions;
import org.locationtech.geowave.format.landsat8.SceneFeatureIterator;
import org.locationtech.geowave.format.landsat8.WRS2GeometryStore;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzeRunner.class);
    protected Landsat8BasicCommandLineOptions landsatOptions = new Landsat8BasicCommandLineOptions();

    public AnalyzeRunner(Landsat8BasicCommandLineOptions landsatOptions) {
        this.landsatOptions = landsatOptions;
    }

    protected void runInternal(OperationParams params) throws Exception {
        try (BandFeatureIterator bands = new BandFeatureIterator(this.landsatOptions.isOnlyScenesSinceLastRun(), this.landsatOptions.isUseCachedScenes(), this.landsatOptions.isNBestPerSpatial(), this.landsatOptions.getNBestScenes(), this.landsatOptions.getNBestBands(), this.landsatOptions.getCqlFilter(), this.landsatOptions.getWorkspaceDir());){
            AnalysisInfo info = new AnalysisInfo();
            String prevEntityId = null;
            while (bands.hasNext()) {
                SimpleFeature band = bands.next();
                String entityId = (String)band.getAttribute("entityId");
                if (prevEntityId == null || !prevEntityId.equals(entityId)) {
                    prevEntityId = entityId;
                    this.nextScene(band, info);
                }
                this.nextBand(band, info);
            }
            this.lastSceneComplete(info);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    protected void nextScene(SimpleFeature firstBandOfScene, AnalysisInfo analysisInfo) {
        analysisInfo.nextScene(firstBandOfScene);
    }

    protected void nextBand(SimpleFeature band, AnalysisInfo analysisInfo) {
        analysisInfo.addBandInfo(band);
    }

    protected void lastSceneComplete(AnalysisInfo analysisInfo) {
        analysisInfo.printSceneInfo();
        analysisInfo.printTotals();
    }

    protected static class AnalysisInfo {
        private final TreeMap<String, Float> bandIdToMbMap = new TreeMap();
        private final TreeMap<String, SimpleFeature> entityBandIdToSimpleFeatureMap = new TreeMap();
        private int sceneCount = 0;
        private final Set<WRS2GeometryStore.WRS2Key> wrs2Keys = new HashSet<WRS2GeometryStore.WRS2Key>();
        private int minRow = Integer.MAX_VALUE;
        private int minPath = Integer.MAX_VALUE;
        private int maxRow = Integer.MIN_VALUE;
        private int maxPath = Integer.MIN_VALUE;
        private double minLat = Double.MAX_VALUE;
        private double minLon = Double.MAX_VALUE;
        private double maxLat = -1.7976931348623157E308;
        private double maxLon = -1.7976931348623157E308;
        private long startDate = Long.MAX_VALUE;
        private long endDate = 0L;
        private float totalCloudCover = 0.0f;
        private float minCloudCover = Float.MAX_VALUE;
        private float maxCloudCover = -3.4028235E38f;
        private final Map<String, Integer> processingLevelCounts = new HashMap<String, Integer>();

        protected AnalysisInfo() {
        }

        private void nextScene(SimpleFeature currentBand) {
            this.printSceneInfo();
            ++this.sceneCount;
            this.entityBandIdToSimpleFeatureMap.clear();
            int path = (Integer)currentBand.getAttribute("path");
            int row = (Integer)currentBand.getAttribute("row");
            float cloudCover = ((Float)currentBand.getAttribute("cloudCover")).floatValue();
            String processingLevel = (String)currentBand.getAttribute("processingLevel");
            Date date = (Date)currentBand.getAttribute("acquisitionDate");
            this.minRow = Math.min(this.minRow, row);
            this.maxRow = Math.max(this.maxRow, row);
            this.minPath = Math.min(this.minPath, path);
            this.maxPath = Math.max(this.maxPath, path);
            Envelope env = ((Geometry)currentBand.getDefaultGeometry()).getEnvelopeInternal();
            this.minLat = Math.min(this.minLat, env.getMinY());
            this.maxLat = Math.max(this.maxLat, env.getMaxY());
            this.minLon = Math.min(this.minLon, env.getMinX());
            this.maxLon = Math.max(this.maxLon, env.getMaxX());
            this.minCloudCover = Math.min(this.minCloudCover, cloudCover);
            this.maxCloudCover = Math.max(this.maxCloudCover, cloudCover);
            this.totalCloudCover += cloudCover;
            Integer count = this.processingLevelCounts.get(processingLevel);
            if (count == null) {
                count = 0;
            }
            count = count + 1;
            this.processingLevelCounts.put(processingLevel, count);
            this.startDate = Math.min(this.startDate, date.getTime());
            this.endDate = Math.max(this.endDate, date.getTime());
            this.wrs2Keys.add(new WRS2GeometryStore.WRS2Key(path, row));
        }

        private void printSceneInfo() {
            if (this.sceneCount > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat(SceneFeatureIterator.AQUISITION_DATE_FORMAT);
                boolean first = true;
                for (Map.Entry<String, SimpleFeature> entry : this.entityBandIdToSimpleFeatureMap.entrySet()) {
                    String bandId = entry.getKey();
                    SimpleFeature feature = entry.getValue();
                    if (first) {
                        if (feature == null) {
                            throw new RuntimeException("feature is null");
                        }
                        System.out.println("\n<--   " + feature.getAttribute("entityId") + "   -->");
                        System.out.println("Acquisition Date: " + sdf.format(feature.getAttribute("acquisitionDate")));
                        System.out.println("Cloud Cover: " + feature.getAttribute("cloudCover"));
                        System.out.println("Scene Download URL: " + feature.getAttribute("sceneDownloadUrl"));
                        first = false;
                    }
                    float mb = ((Float)feature.getAttribute("sizeMB")).floatValue();
                    String bandDownloadUrl = (String)feature.getAttribute("bandDownloadUrl");
                    System.out.println("Band " + bandId + ": " + mb + " MB, download at " + bandDownloadUrl);
                    Float totalMb = this.bandIdToMbMap.get(bandId);
                    if (totalMb == null) {
                        totalMb = Float.valueOf(0.0f);
                    }
                    totalMb = Float.valueOf(totalMb.floatValue() + mb);
                    this.bandIdToMbMap.put(bandId, totalMb);
                }
            }
        }

        private void addBandInfo(SimpleFeature band) {
            this.entityBandIdToSimpleFeatureMap.put((String)band.getAttribute("band"), band);
        }

        private void printTotals() {
            System.out.println("\n<--   Totals   -->");
            System.out.println("Total Scenes: " + this.sceneCount);
            if (this.sceneCount > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat(SceneFeatureIterator.AQUISITION_DATE_FORMAT);
                System.out.println("Date Range: [" + sdf.format(new Date(this.startDate)) + ", " + sdf.format(new Date(this.endDate)) + "]");
                System.out.println("Cloud Cover Range: [" + this.minCloudCover + ", " + this.maxCloudCover + "]");
                System.out.println("Average Cloud Cover: " + this.totalCloudCover / (float)this.sceneCount);
                System.out.println("WRS2 Paths/Rows covered: " + this.wrs2Keys.size());
                System.out.println("Row Range: [" + this.minRow + ", " + this.maxRow + "]");
                System.out.println("Path Range: [" + this.minPath + ", " + this.maxPath + "]");
                System.out.println("Latitude Range: [" + this.minLat + ", " + this.maxLat + "]");
                System.out.println("Longitude Range: [" + this.minLon + ", " + this.maxLon + "]");
                StringBuffer strBuf = new StringBuffer("Processing Levels: ");
                boolean includeSceneCount = false;
                boolean first = true;
                if (this.processingLevelCounts.size() > 1) {
                    includeSceneCount = true;
                }
                for (Map.Entry<String, Integer> entry : this.processingLevelCounts.entrySet()) {
                    if (!first) {
                        strBuf.append(", ");
                    } else {
                        first = false;
                    }
                    strBuf.append(entry.getKey());
                    if (!includeSceneCount) continue;
                    strBuf.append(" (" + entry.getValue() + " scenes)");
                }
                for (Map.Entry<String, Number> entry : this.bandIdToMbMap.entrySet()) {
                    String bandId = entry.getKey();
                    float mb = (float)Math.round(((Float)entry.getValue()).floatValue() * 10.0f) / 10.0f;
                    String avg = this.sceneCount > 1 ? "(avg. " + (float)Math.round(((Float)entry.getValue()).floatValue() * 10.0f / (float)this.sceneCount) / 10.0f + " MB)" : "";
                    System.out.println("Band " + bandId + ": " + mb + " MB " + avg);
                }
            }
        }
    }
}

