/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.IntegerConverter;
import org.locationtech.geowave.adapter.vector.ingest.CQLFilterOptionProvider;
import org.opengis.filter.Filter;

public class Landsat8BasicCommandLineOptions {
    private static final String DEFAULT_WORKSPACE_DIR = "landsat8";
    @Parameter(names={"-ws", "--workspaceDir"}, description="A local directory to write temporary files needed for landsat 8 ingest. Default is <TEMP_DIR>/landsat8")
    private String workspaceDir = "landsat8";
    @Parameter(names={"--cql"}, description="An optional CQL expression to filter the ingested imagery. The feature type for the expression has the following attributes: shape (Geometry) in EPSG:4326, acquisitionDate (Date), cloudCover (double), processingLevel (String), path (int), row (int) and the feature ID is entityId for the scene.  Additionally attributes of the individuals band can be used such as band (String), sizeMB (double), and bandDownloadUrl (String)", converter=CQLFilterOptionProvider.ConvertCQLStrToFilterConverter.class)
    private CQLFilterOptionProvider.FilterParameter cqlFilter = new CQLFilterOptionProvider.FilterParameter(null, null);
    @Parameter(names={"--sincelastrun"}, arity=1, description="An option to check the scenes list from the workspace and if it exists, to only ingest data since the last scene.")
    private boolean onlyScenesSinceLastRun;
    @Parameter(names={"--usecachedscenes"}, arity=1, description="An option to run against the existing scenes catalog in the workspace directory if it exists.")
    private boolean useCachedScenes;
    @Parameter(names={"--nbestscenes"}, description="An option to identify and only use a set number of scenes with the best cloud cover", converter=IntegerConverter.class)
    private int nBestScenes;
    @Parameter(names={"--nbestbands"}, description="An option to identify and only use a set number of bands with the best cloud cover", converter=IntegerConverter.class)
    private int nBestBands;
    @Parameter(names={"--nbestperspatial"}, arity=1, description="A boolean flag, when applied with --nbestscenes or --nbestbands will aggregate scenes and/or bands by path/row")
    private boolean nBestPerSpatial;

    public String getWorkspaceDir() {
        return this.workspaceDir;
    }

    public Filter getCqlFilter() {
        if (this.cqlFilter != null) {
            return this.cqlFilter.getFilter();
        }
        return null;
    }

    public boolean isUseCachedScenes() {
        return this.useCachedScenes;
    }

    public boolean isOnlyScenesSinceLastRun() {
        return this.onlyScenesSinceLastRun;
    }

    public int getNBestScenes() {
        return this.nBestScenes;
    }

    public boolean isNBestPerSpatial() {
        return this.nBestPerSpatial;
    }

    public int getNBestBands() {
        return this.nBestBands;
    }

    public void setWorkspaceDir(String workspaceDir) {
        this.workspaceDir = workspaceDir;
    }

    public void setCqlFilter(String cqlFilter) {
        this.cqlFilter = new CQLFilterOptionProvider.ConvertCQLStrToFilterConverter().convert(cqlFilter);
    }

    public void setOnlyScenesSinceLastRun(boolean onlyScenesSinceLastRun) {
        this.onlyScenesSinceLastRun = onlyScenesSinceLastRun;
    }

    public void setUseCachedScenes(boolean useCachedScenes) {
        this.useCachedScenes = useCachedScenes;
    }

    public void setNBestScenes(int nBestScenes) {
        this.nBestScenes = nBestScenes;
    }

    public void setNBestBands(int nBestBands) {
        this.nBestBands = nBestBands;
    }

    public void setNBestPerSpatial(boolean nBestPerSpatial) {
        this.nBestPerSpatial = nBestPerSpatial;
    }
}

