/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.converters.IntegerConverter;

public class Landsat8RasterIngestCommandLineOptions {
    @Parameter(names={"--histogram"}, arity=1, description="An option to store the histogram of the values of the coverage so that histogram equalization will be performed")
    protected boolean histogram = false;
    @Parameter(names={"--pyramid"}, arity=1, description="An option to store an image pyramid for the coverage")
    protected boolean pyramid = false;
    @Parameter(names={"--retainimages"}, arity=1, description="An option to keep the images that are ingested in the local workspace directory.  By default it will delete the local file after it is ingested successfully.")
    protected boolean retainimages = false;
    @Parameter(names={"--tilesize"}, description="The option to set the pixel size for each tile stored in GeoWave. The default is 256")
    protected int tilesize = 256;
    @Parameter(names={"--coverage"}, description="The name to give to each unique coverage. Freemarker templating can be used for variable substition based on the same attributes used for filtering.  The default coverage name is '${entityId}_${band}'.  If ${band} is unused in the coverage name, all bands will be merged together into the same coverage.")
    protected String coverage = "${entityId}_${band}";
    @Parameter(names={"--converter"}, description="Prior to ingesting an image, this converter will be used to massage the data. The default is not to convert the data.")
    protected String coverageConverter;
    @Parameter(names={"--subsample"}, description="Subsample the image prior to ingest by the scale factor provided.  The scale factor should be an integer value greater than 1.", converter=IntegerConverter.class)
    protected int scale = 1;
    @Parameter(names={"--crop"}, arity=1, description="Use the spatial constraint provided in CQL to crop the image.  If no spatial constraint is provided, this will not have an effect.")
    protected boolean cropToSpatialConstraint;
    @Parameter(names={"--skipMerge"}, arity=1, description="By default the ingest will automerge overlapping tiles as a post-processing optimization step for efficient retrieval, but this will skip the merge process")
    protected boolean skipMerge;

    public boolean isCreateHistogram() {
        return this.histogram;
    }

    public boolean isCreatePyramid() {
        return this.pyramid;
    }

    public boolean isRetainImages() {
        return this.retainimages;
    }

    public String getCoverageName() {
        return this.coverage;
    }

    public String getCoverageConverter() {
        return this.coverageConverter;
    }

    public boolean isCoveragePerBand() {
        return this.coverage.contains("${band}") || this.coverage.contains("${bandDownloadUrl}") || this.coverage.contains("${sizeMB}");
    }

    public int getTileSize() {
        return this.tilesize;
    }

    public boolean isSubsample() {
        return this.scale > 1;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isCropToSpatialConstraint() {
        return this.cropToSpatialConstraint;
    }

    public void setCreateHistogram(boolean createHistogram) {
        this.histogram = createHistogram;
    }

    public void setCreatePyramid(boolean createPyramid) {
        this.pyramid = createPyramid;
    }

    public void setRetainImages(boolean retainImages) {
        this.retainimages = retainImages;
    }

    public void setTileSize(int tileSize) {
        this.tilesize = tileSize;
    }

    public void setCoverageName(String coverageName) {
        this.coverage = coverageName;
    }

    public void setCoverageConverter(String coverageConverter) {
        this.coverageConverter = coverageConverter;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setCropToSpatialConstraint(boolean cropToSpatialConstraint) {
        this.cropToSpatialConstraint = cropToSpatialConstraint;
    }

    public boolean isSkipMerge() {
        return this.skipMerge;
    }

    public void setSkipMerge(boolean skipMerge) {
        this.skipMerge = skipMerge;
    }
}

