/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.landsat8;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureIteratorIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.geowave.format.landsat8.SceneFeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandFeatureIterator
implements SimpleFeatureIterator {
    private static final int DOWNLOAD_RETRY = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(BandFeatureIterator.class);
    protected static final NumberFormat PATH_ROW_FORMATTER = NumberFormat.getIntegerInstance();
    private static final String DOWNLOAD_PREFIX = "https://s3-us-west-2.amazonaws.com/landsat-pds/c1/L8";
    protected static final String BANDS_TYPE_NAME = "band";
    public static final String BAND_ATTRIBUTE_NAME = "band";
    public static final String SIZE_ATTRIBUTE_NAME = "sizeMB";
    public static final String BAND_DOWNLOAD_ATTRIBUTE_NAME = "bandDownloadUrl";
    private Iterator<SimpleFeature> iterator;
    private final SceneFeatureIterator sceneIterator;

    public BandFeatureIterator(boolean onlyScenesSinceLastRun, boolean useCachedScenes, boolean nBestScenesByPathRow, int nBestScenes, int nBestBands, Filter cqlFilter, String workspaceDir) throws MalformedURLException, IOException {
        this(new SceneFeatureIterator(onlyScenesSinceLastRun, useCachedScenes, nBestScenesByPathRow, nBestScenes, cqlFilter, workspaceDir), nBestScenesByPathRow, nBestBands, cqlFilter);
    }

    public BandFeatureIterator(SceneFeatureIterator sceneIterator, boolean nBestScenesByPathRow, int nBestBands, Filter cqlFilter) {
        this.sceneIterator = sceneIterator;
        this.init(nBestScenesByPathRow, nBestBands, cqlFilter);
    }

    public static SimpleFeatureType createFeatureType(SimpleFeatureType sceneType) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.init(sceneType);
        typeBuilder.setName("band");
        typeBuilder.add("band", String.class);
        typeBuilder.add(SIZE_ATTRIBUTE_NAME, Float.class);
        typeBuilder.add(BAND_DOWNLOAD_ATTRIBUTE_NAME, String.class);
        SimpleFeatureType bandType = typeBuilder.buildFeatureType();
        return bandType;
    }

    private void init(boolean nBestScenesByPathRow, int nBestBands, Filter cqlFilter) {
        Object[] attributes;
        SimpleFeatureType bandType = BandFeatureIterator.createFeatureType(this.sceneIterator.getFeatureType());
        this.iterator = Iterators.concat((Iterator)Iterators.transform((Iterator)new FeatureIteratorIterator((FeatureIterator)this.sceneIterator), (Function)new SceneToBandFeatureTransform(bandType)));
        if (cqlFilter != null && (ArrayUtils.contains((Object[])(attributes = DataUtilities.attributeNames((Filter)cqlFilter, (SimpleFeatureType)bandType)), (Object)"band") || ArrayUtils.contains((Object[])attributes, (Object)SIZE_ATTRIBUTE_NAME) || ArrayUtils.contains((Object[])attributes, (Object)BAND_DOWNLOAD_ATTRIBUTE_NAME))) {
            this.iterator = Iterators.filter(this.iterator, (Predicate)new CqlFilterPredicate(cqlFilter));
            if (nBestBands > 0) {
                this.iterator = SceneFeatureIterator.nBestScenes(this, nBestScenesByPathRow, nBestBands);
            }
        }
    }

    public void close() {
        this.sceneIterator.close();
    }

    public boolean hasNext() {
        if (this.iterator != null) {
            return this.iterator.hasNext();
        }
        return false;
    }

    public SimpleFeature next() throws NoSuchElementException {
        if (this.iterator != null) {
            return this.iterator.next();
        }
        return null;
    }

    protected static String getDownloadPath(String productId, int path, int row) {
        return "https://s3-us-west-2.amazonaws.com/landsat-pds/c1/L8/" + PATH_ROW_FORMATTER.format(path) + "/" + PATH_ROW_FORMATTER.format(row) + "/" + productId;
    }

    protected static String getDownloadIndexHtml(String productId, int path, int row) {
        return BandFeatureIterator.getDownloadPath(productId, path, row) + "/index.html";
    }

    protected static String getDownloadImage(String productId, int path, int row, String bandId) {
        return BandFeatureIterator.getDownloadPath(productId, path, row) + "/" + productId + "_" + bandId + ".TIF";
    }

    static {
        PATH_ROW_FORMATTER.setMaximumIntegerDigits(3);
        PATH_ROW_FORMATTER.setMinimumIntegerDigits(3);
    }

    private static class CqlFilterPredicate
    implements Predicate<SimpleFeature> {
        private final Filter cqlFilter;

        public CqlFilterPredicate(Filter cqlFilter) {
            this.cqlFilter = cqlFilter;
        }

        public boolean apply(SimpleFeature input) {
            return this.cqlFilter.evaluate((Object)input);
        }
    }

    private static class SceneToBandFeatureTransform
    implements Function<SimpleFeature, Iterator<SimpleFeature>> {
        private final SimpleFeatureBuilder featureBuilder;

        public SceneToBandFeatureTransform(SimpleFeatureType type) {
            this.featureBuilder = new SimpleFeatureBuilder(type);
        }

        public Iterator<SimpleFeature> apply(SimpleFeature scene) {
            if (scene == null) {
                return Collections.emptyIterator();
            }
            String productId = scene.getID();
            int path = (Integer)scene.getAttribute("path");
            int row = (Integer)scene.getAttribute("row");
            ArrayList<SimpleFeature> bands = new ArrayList<SimpleFeature>();
            String indexHtml = BandFeatureIterator.getDownloadIndexHtml(productId, path, row);
            int retry = 0;
            boolean success = false;
            while (!success && retry < 5) {
                try {
                    if (retry > 0) {
                        Thread.sleep(1000L);
                    }
                    List htmlLines = IOUtils.readLines((InputStream)new URL(indexHtml).openStream());
                    success = true;
                    for (String line : htmlLines) {
                        int endIndex = line.lastIndexOf(".TIF");
                        if (endIndex <= 0) continue;
                        String productIdSubstring = productId + "_";
                        int beginIndex = line.lastIndexOf(productIdSubstring);
                        String bandId = line.substring(beginIndex + productIdSubstring.length(), endIndex);
                        endIndex = line.indexOf("MB)");
                        double divisor = 1.0;
                        if (endIndex < 0) {
                            endIndex = line.indexOf("KB)");
                            divisor = 1000.0;
                        }
                        if (endIndex < 0) continue;
                        beginIndex = endIndex - 6;
                        String sizeStr = line.substring(beginIndex, endIndex);
                        sizeStr = sizeStr.replaceAll("[^\\d.]", "");
                        double mb = Double.parseDouble(sizeStr) / divisor;
                        for (String attributeName : SceneFeatureIterator.SCENE_ATTRIBUTES) {
                            this.featureBuilder.set(attributeName, scene.getAttribute(attributeName));
                        }
                        this.featureBuilder.set(BandFeatureIterator.SIZE_ATTRIBUTE_NAME, (Object)mb);
                        this.featureBuilder.set("band", (Object)bandId);
                        this.featureBuilder.set(BandFeatureIterator.BAND_DOWNLOAD_ATTRIBUTE_NAME, (Object)BandFeatureIterator.getDownloadImage(productId, path, row, bandId));
                        bands.add(this.featureBuilder.buildFeature(productId + "_" + bandId));
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.warn("Unable to read '" + indexHtml + "'; retry round " + ++retry, (Throwable)e);
                }
            }
            return bands.iterator();
        }
    }
}

