/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.converters;

import com.beust.jcommander.converters.BaseConverter;
import com.beust.jcommander.internal.Console;
import com.beust.jcommander.internal.DefaultConsole;
import com.beust.jcommander.internal.JDK6Console;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;
import org.locationtech.geowave.core.cli.utils.PropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeoWaveBaseConverter<T>
extends BaseConverter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeoWaveBaseConverter.class);
    private String propertyKey;
    private static Console console;
    private static Properties properties;

    public GeoWaveBaseConverter() {
        super("");
        this.init();
    }

    public GeoWaveBaseConverter(String optionName) {
        super(optionName);
        this.init();
    }

    private void init() {
        File propertyFile = null;
        propertyFile = new ConfigOptions().getConfigFile() != null ? new File(new ConfigOptions().getConfigFile()) : ConfigOptions.getDefaultPropertyFile();
        if (propertyFile != null && propertyFile.exists()) {
            this.setProperties(ConfigOptions.loadProperties(propertyFile));
        }
    }

    protected static Console getConsole() {
        LOGGER.trace("ENTER :: getConsole()");
        if (console == null) {
            try {
                Method consoleMethod = System.class.getDeclaredMethod("console", new Class[0]);
                Object consoleObj = consoleMethod.invoke(null, new Object[0]);
                console = new JDK6Console(consoleObj);
            }
            catch (Throwable t) {
                LOGGER.error("An error occurred getting declared method console. Defaulting to default console. Error message: " + t.getLocalizedMessage(), t);
                console = new DefaultConsole();
            }
        }
        return console;
    }

    public static String promptAndReadValue(String promptMessage) {
        LOGGER.trace("ENTER :: promptAndReadValue()");
        PropertiesUtils propsUtils = new PropertiesUtils(GeoWaveBaseConverter.getProperties());
        boolean defaultEchoEnabled = propsUtils.getBoolean("geowave.console.default.echo.enabled", false);
        LOGGER.debug("Default console echo is {}", new Object[]{defaultEchoEnabled ? "enabled" : "disabled"});
        GeoWaveBaseConverter.getConsole().print(promptMessage);
        char[] responseChars = GeoWaveBaseConverter.getConsole().readPassword(defaultEchoEnabled);
        String response = new String(responseChars);
        responseChars = null;
        return response;
    }

    public static String promptAndReadPassword(String promptMessage) {
        LOGGER.trace("ENTER :: promptAndReadPassword()");
        PropertiesUtils propsUtils = new PropertiesUtils(GeoWaveBaseConverter.getProperties());
        boolean defaultEchoEnabled = propsUtils.getBoolean("geowave.console.default.echo.enabled", false);
        boolean passwordEchoEnabled = propsUtils.getBoolean("geowave.console.password.echo.enabled", defaultEchoEnabled);
        LOGGER.debug("Password console echo is {}", new Object[]{passwordEchoEnabled ? "enabled" : "disabled"});
        GeoWaveBaseConverter.getConsole().print(promptMessage);
        char[] passwordChars = GeoWaveBaseConverter.getConsole().readPassword(passwordEchoEnabled);
        String strPassword = new String(passwordChars);
        passwordChars = null;
        return strPassword;
    }

    public String getPropertyKey() {
        return this.propertyKey;
    }

    public void setPropertyKey(String propertyKey) {
        this.propertyKey = propertyKey;
    }

    public boolean isPassword() {
        return false;
    }

    public boolean isRequired() {
        return false;
    }

    private static Properties getProperties() {
        return properties;
    }

    private void setProperties(Properties props) {
        properties = props;
    }
}

