/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.locationtech.geowave.core.cli.VersionUtils;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.DefaultOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;

@GeowaveOperation(name="geowave")
@Parameters(commandDescription="This is the top level section.")
public class GeowaveTopLevelSection
extends DefaultOperation {
    @Parameter(names={"--debug"}, description="Verbose output")
    private Boolean verboseFlag;
    @Parameter(names={"--version"}, description="Output Geowave build version information")
    private Boolean versionFlag;
    @ParametersDelegate
    private ConfigOptions options = new ConfigOptions();

    @Override
    public boolean prepare(OperationParams inputParams) {
        this.options.prepare(inputParams);
        super.prepare(inputParams);
        if (Boolean.TRUE.equals(this.verboseFlag)) {
            LogManager.getRootLogger().setLevel(Level.DEBUG);
        }
        if (Boolean.TRUE.equals(this.versionFlag)) {
            VersionUtils.printVersionInfo();
            return false;
        }
        return true;
    }
}

