/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations.config;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.locationtech.geowave.core.cli.annotations.GeowaveOperation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.api.ServiceEnabledCommand;
import org.locationtech.geowave.core.cli.operations.config.ConfigSection;
import org.locationtech.geowave.core.cli.operations.config.options.ConfigOptions;

@GeowaveOperation(name="list", parentOperation=ConfigSection.class)
@Parameters(commandDescription="List property name within cache")
public class ListCommand
extends ServiceEnabledCommand<SortedMap<String, Object>> {
    @Parameter(names={"-f", "--filter"})
    private String filter;

    @Override
    public void execute(OperationParams params) {
        Pair<String, SortedMap<String, Object>> list = this.getProperties(params);
        String name = (String)list.getKey();
        JCommander.getConsole().println("PROPERTIES (" + name + ")");
        SortedMap properties = (SortedMap)list.getValue();
        for (Map.Entry e : properties.entrySet()) {
            JCommander.getConsole().println((String)e.getKey() + ": " + e.getValue());
        }
    }

    @Override
    public SortedMap<String, Object> computeResults(OperationParams params) {
        return (SortedMap)this.getProperties(params).getValue();
    }

    private Pair<String, SortedMap<String, Object>> getProperties(OperationParams params) {
        File f = this.getGeoWaveConfigFile(params);
        Properties p = null;
        p = this.filter != null ? ConfigOptions.loadProperties(f, this.filter) : ConfigOptions.loadProperties(f);
        return new ImmutablePair((Object)f.getName(), (Object)new GeoWaveConfig((Map)p));
    }

    protected static class GeoWaveConfig
    extends TreeMap<String, Object> {
        private static final long serialVersionUID = 1L;

        public GeoWaveConfig() {
        }

        public GeoWaveConfig(Map m) {
            super(m);
        }
    }
}

