/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.operations.config.security.utils;

import java.io.File;
import org.locationtech.geowave.core.cli.operations.config.security.crypto.BaseEncryption;
import org.locationtech.geowave.core.cli.operations.config.security.crypto.GeoWaveEncryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecurityUtils.class);
    private static BaseEncryption encService;
    private static final String WRAPPER = "ENC{}";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String decryptHexEncodedValue(String value, String resourceLocation) throws Exception {
        LOGGER.trace("Decrypting hex-encoded value");
        if (value != null && !"".equals(value.trim())) {
            if (!BaseEncryption.isProperlyWrapped(value.trim())) {
                LOGGER.debug("WARNING: Value to decrypt was not propertly encoded and wrapped with ENC{}. Not decrypting value.");
                return value;
            }
            try {
                return SecurityUtils.getEncryptionService(resourceLocation).decryptHexEncoded(value);
            }
            catch (Throwable t) {
                LOGGER.error("Encountered exception during content decryption: " + t.getLocalizedMessage(), t);
                return "";
            }
        }
        LOGGER.debug("WARNING: No value specified to decrypt.");
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String encryptAndHexEncodeValue(String value, String resourceLocation) throws Exception {
        LOGGER.debug("Encrypting and hex-encoding value");
        if (value != null && !"".equals(value.trim())) {
            if (BaseEncryption.isProperlyWrapped(value)) {
                LOGGER.debug("WARNING: Value to encrypt already appears to be encrypted and already wrapped with ENC{}. Not encrypting value.");
                return value;
            }
            try {
                return SecurityUtils.getEncryptionService(resourceLocation).encryptAndHexEncode(value);
            }
            catch (Throwable t) {
                LOGGER.error("Encountered exception during content encryption: " + t.getLocalizedMessage(), t);
                return value;
            }
        }
        LOGGER.debug("WARNING: No value specified to encrypt.");
        return value;
    }

    private static synchronized BaseEncryption getEncryptionService(String resourceLocation) throws Throwable {
        if (encService == null) {
            if (resourceLocation != null && !"".equals(resourceLocation.trim())) {
                LOGGER.trace("Setting resource location for encryption service: [" + resourceLocation + "]");
                encService = new GeoWaveEncryption(resourceLocation);
            } else {
                encService = new GeoWaveEncryption();
            }
        } else if (!resourceLocation.equals(encService.getResourceLocation())) {
            encService = new GeoWaveEncryption(resourceLocation);
        }
        return encService;
    }

    public static File getFormattedTokenKeyFileForConfig(File configFile) {
        return new File(configFile.getParentFile(), BaseEncryption.getFormattedTokenFileName(configFile.getName()));
    }
}

