/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.parser;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.api.OperationParams;
import org.locationtech.geowave.core.cli.prefix.PrefixedJCommander;

public class CommandLineOperationParams
implements OperationParams {
    private final Map<String, Object> context = new HashMap<String, Object>();
    private final Map<String, Operation> operationMap = new LinkedHashMap<String, Operation>();
    private final String[] args;
    private PrefixedJCommander commander;
    private boolean validate = true;
    private boolean allowUnknown = false;
    private boolean commandPresent;
    private int successCode = 0;
    private String successMessage;
    private Throwable successException;

    public CommandLineOperationParams(String[] args) {
        this.args = args;
    }

    public String[] getArgs() {
        return this.args;
    }

    @Override
    public Map<String, Operation> getOperationMap() {
        return this.operationMap;
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    public PrefixedJCommander getCommander() {
        return this.commander;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setAllowUnknown(boolean allowUnknown) {
        this.allowUnknown = allowUnknown;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public boolean isAllowUnknown() {
        return this.allowUnknown;
    }

    public void setCommander(PrefixedJCommander commander) {
        this.commander = commander;
    }

    public void addOperation(String name, Operation operation, boolean isCommand) {
        this.commandPresent |= isCommand;
        this.operationMap.put(name, operation);
    }

    public boolean isCommandPresent() {
        return this.commandPresent;
    }

    public int getSuccessCode() {
        return this.successCode;
    }

    public void setSuccessCode(int successCode) {
        this.successCode = successCode;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public Throwable getSuccessException() {
        return this.successException;
    }

    public void setSuccessException(Throwable successException) {
        this.successException = successException;
    }
}

