/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.parser;

import com.beust.jcommander.ParameterException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.locationtech.geowave.core.cli.api.Operation;
import org.locationtech.geowave.core.cli.parser.CommandLineOperationParams;
import org.locationtech.geowave.core.cli.prefix.PrefixedJCommander;
import org.locationtech.geowave.core.cli.spi.OperationEntry;
import org.locationtech.geowave.core.cli.spi.OperationRegistry;

public class OperationParser {
    private final OperationRegistry registry;
    private final Set<Object> additionalObjects = new HashSet<Object>();

    public OperationParser(OperationRegistry registry) {
        this.registry = registry;
    }

    public OperationParser() {
        this(OperationRegistry.getInstance());
    }

    public CommandLineOperationParams parse(Operation operation, String[] args) {
        CommandLineOperationParams params = new CommandLineOperationParams(args);
        OperationEntry topLevelEntry = this.registry.getOperation(operation.getClass());
        params.getOperationMap().put(topLevelEntry.getOperationName(), operation);
        this.parseInternal(params, topLevelEntry);
        return params;
    }

    public CommandLineOperationParams parse(Class<? extends Operation> topLevel, String[] args) {
        CommandLineOperationParams params = new CommandLineOperationParams(args);
        OperationEntry topLevelEntry = this.registry.getOperation(topLevel);
        this.parseInternal(params, topLevelEntry);
        return params;
    }

    private void parseInternal(CommandLineOperationParams params, OperationEntry topLevelEntry) {
        try {
            PrefixedJCommander pluginCommander = new PrefixedJCommander();
            pluginCommander.setInitializer(new OperationContext(topLevelEntry, params));
            params.setCommander(pluginCommander);
            for (Object obj : this.additionalObjects) {
                params.getCommander().addPrefixedObject(obj);
            }
            params.getCommander().setAcceptUnknownOptions(true);
            params.getCommander().setValidate(false);
            params.getCommander().parse(params.getArgs());
            for (Operation operation : params.getOperationMap().values()) {
                if (operation.prepare(params)) continue;
                params.setSuccessCode(1);
                return;
            }
            PrefixedJCommander finalCommander = new PrefixedJCommander();
            finalCommander.setInitializer(new OperationContext(topLevelEntry, params));
            params.setCommander(finalCommander);
            for (Object obj : this.additionalObjects) {
                params.getCommander().addPrefixedObject(obj);
            }
            params.getCommander().setAcceptUnknownOptions(params.isAllowUnknown());
            params.getCommander().setValidate(params.isValidate());
            params.getCommander().parse(params.getArgs());
        }
        catch (ParameterException p) {
            params.setSuccessCode(-1);
            params.setSuccessMessage("Error: " + p.getMessage());
            params.setSuccessException(p);
        }
    }

    public CommandLineOperationParams parse(String[] args) {
        CommandLineOperationParams params = new CommandLineOperationParams(args);
        try {
            PrefixedJCommander pluginCommander = new PrefixedJCommander();
            params.setCommander(pluginCommander);
            for (Object obj : this.additionalObjects) {
                params.getCommander().addPrefixedObject(obj);
            }
            params.getCommander().parse(params.getArgs());
        }
        catch (ParameterException p) {
            params.setSuccessCode(-1);
            params.setSuccessMessage("Error: " + p.getMessage());
            params.setSuccessException(p);
        }
        return params;
    }

    public Set<Object> getAdditionalObjects() {
        return this.additionalObjects;
    }

    public void addAdditionalObject(Object obj) {
        this.additionalObjects.add(obj);
    }

    public OperationRegistry getRegistry() {
        return this.registry;
    }

    public class OperationContext
    implements PrefixedJCommander.PrefixedJCommanderInitializer {
        private final OperationEntry operationEntry;
        private final CommandLineOperationParams params;
        private Operation operation;

        public OperationContext(OperationEntry entry, CommandLineOperationParams params) {
            this.operationEntry = entry;
            this.params = params;
        }

        @Override
        public void initialize(PrefixedJCommander commander) {
            commander.setCaseSensitiveOptions(false);
            if (this.params.getOperationMap().containsKey(this.operationEntry.getOperationName())) {
                this.operation = this.params.getOperationMap().get(this.operationEntry.getOperationName());
            } else {
                this.operation = this.operationEntry.createInstance();
                this.params.addOperation(this.operationEntry.getOperationName(), this.operation, this.operationEntry.isCommand());
            }
            commander.addPrefixedObject(this.operation);
            for (OperationEntry child : this.operationEntry.getChildren()) {
                commander.addCommand(child.getOperationName(), null);
            }
            Map childCommanders = commander.getCommands();
            for (OperationEntry child : this.operationEntry.getChildren()) {
                PrefixedJCommander pCommander = (PrefixedJCommander)((Object)childCommanders.get(child.getOperationName()));
                pCommander.setInitializer(new OperationContext(child, this.params));
            }
        }

        public Operation getOperation() {
            return this.operation;
        }

        public OperationEntry getOperationEntry() {
            return this.operationEntry;
        }
    }
}

