/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.prefix;

import com.beust.jcommander.Parameterized;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.locationtech.geowave.core.cli.annotations.PrefixParameter;
import org.locationtech.geowave.core.cli.prefix.JCommanderTranslationMap;
import org.locationtech.geowave.core.cli.prefix.JavassistUtils;

public class JCommanderPrefixTranslator {
    private final Queue<ParseContext> queue = new LinkedList<ParseContext>();
    private final Field paraField;
    private final Field paraMethod;

    public JCommanderPrefixTranslator() {
        try {
            this.paraField = Parameterized.class.getDeclaredField("m_field");
            this.paraField.setAccessible(true);
            this.paraMethod = Parameterized.class.getDeclaredField("m_method");
            this.paraMethod.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public void addObject(Object object) {
        ParseContext pc = new ParseContext("", object);
        this.queue.add(pc);
    }

    public JCommanderTranslationMap translate() {
        JCommanderTranslationMap transMap = new JCommanderTranslationMap();
        try {
            while (this.queue.size() > 0) {
                ParseContext pc = this.queue.remove();
                Object item = pc.getObject();
                List params = Parameterized.parseArg((Object)item);
                for (Parameterized param : params) {
                    AccessibleObject annotatedElement;
                    Field f = (Field)this.paraField.get(param);
                    Method m = (Method)this.paraMethod.get(param);
                    AccessibleObject accessibleObject = annotatedElement = f != null ? f : m;
                    if (param.getDelegateAnnotation() != null) {
                        Object delegateItem = param.get(item);
                        if (delegateItem == null) continue;
                        PrefixParameter prefixParam = annotatedElement.getAnnotation(PrefixParameter.class);
                        String newPrefix = pc.getPrefix();
                        if (prefixParam != null) {
                            if (!newPrefix.equals("")) {
                                newPrefix = newPrefix + ".";
                            }
                            newPrefix = newPrefix + prefixParam.prefix();
                        }
                        if (delegateItem instanceof Collection) {
                            Collection coll = (Collection)delegateItem;
                            for (Object e : coll) {
                                ParseContext newPc = new ParseContext(newPrefix, e);
                                this.queue.add(newPc);
                            }
                            continue;
                        }
                        if (delegateItem instanceof Map) {
                            Map mapp = (Map)delegateItem;
                            for (Map.Entry entry : mapp.entrySet()) {
                                String prefix = entry.getKey().toString();
                                Object mapItem = entry.getValue();
                                String convertedPrefix = newPrefix;
                                if (!convertedPrefix.equals("")) {
                                    convertedPrefix = convertedPrefix + ".";
                                }
                                convertedPrefix = convertedPrefix + prefix;
                                ParseContext newPc = new ParseContext(convertedPrefix, mapItem);
                                this.queue.add(newPc);
                            }
                            continue;
                        }
                        ParseContext newPc = new ParseContext(newPrefix, delegateItem);
                        this.queue.add(newPc);
                        continue;
                    }
                    String newFieldName = JavassistUtils.getNextUniqueFieldName();
                    transMap.addEntry(newFieldName, item, param, pc.getPrefix(), annotatedElement);
                }
            }
            return transMap;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ParseContext {
        private final String prefix;
        private final Object object;

        public ParseContext(String prefix, Object object) {
            this.prefix = prefix;
            this.object = object;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Object getObject() {
            return this.object;
        }
    }
}

