/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.prefix;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameterized;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.locationtech.geowave.core.cli.prefix.JCommanderPrefixTranslator;
import org.locationtech.geowave.core.cli.prefix.JavassistUtils;
import org.locationtech.geowave.core.cli.prefix.TranslationEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCommanderTranslationMap {
    private static Logger LOGGER = LoggerFactory.getLogger(JCommanderTranslationMap.class);
    public static final String NAMES_MEMBER = "names";
    public static final String REQUIRED_MEMBER = "required";
    public static final String PASSWORD_MEMBER = "password";
    public static final String PREFIX_SEPARATOR = ".";
    private final Map<String, TranslationEntry> translations = new LinkedHashMap<String, TranslationEntry>();
    private List<Object> translatedObjects = null;

    public Collection<Object> getObjects() {
        return Collections.unmodifiableCollection(this.translatedObjects);
    }

    public Map<String, TranslationEntry> getEntries() {
        if (this.translatedObjects != null) {
            return Collections.unmodifiableMap(this.translations);
        }
        return this.translations;
    }

    public void transformToOriginal() {
        for (Object obj : this.translatedObjects) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                TranslationEntry tEntry = this.translations.get(field.getName());
                try {
                    tEntry.getParam().set(tEntry.getObject(), field.get(obj));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.warn("Unable to return field object", (Throwable)e);
                }
            }
        }
    }

    public void transformToFacade() {
        for (Object obj : this.translatedObjects) {
            for (Field field : obj.getClass().getDeclaredFields()) {
                TranslationEntry tEntry = this.translations.get(field.getName());
                try {
                    field.set(obj, tEntry.getParam().get(tEntry.getObject()));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LOGGER.warn("Unable to set field", (Throwable)e);
                }
            }
        }
    }

    protected void addEntry(String newFieldName, Object item, Parameterized param, String prefix, AnnotatedElement member) {
        this.translations.put(newFieldName, new TranslationEntry(param, item, prefix, member));
    }

    public void createFacadeObjects() {
        if (this.translatedObjects != null) {
            throw new RuntimeException("Cannot use the same translation map twice");
        }
        this.translatedObjects = new ArrayList<Object>();
        HashMap createdClasses = new HashMap();
        try {
            ClassPool classPool = ClassPool.getDefault();
            ClassClassPath path = new ClassClassPath(JCommanderPrefixTranslator.class);
            classPool.insertClassPath((ClassPath)path);
            for (Map.Entry<String, TranslationEntry> mapEntry : this.translations.entrySet()) {
                String newFieldName = mapEntry.getKey();
                TranslationEntry entry = mapEntry.getValue();
                Class<?> objectClass = entry.getObject().getClass();
                CtClass oldClass = classPool.get(objectClass.getName());
                CtClass newClass = (CtClass)createdClasses.get(objectClass);
                if (newClass == null) {
                    newClass = JavassistUtils.generateEmptyClass();
                    JavassistUtils.copyClassAnnotations(oldClass, newClass);
                    createdClasses.put(objectClass, newClass);
                }
                CtField newField = null;
                if (!entry.isMethod()) {
                    newField = new CtField(oldClass.getField(entry.getParam().getName()), newClass);
                } else {
                    CtClass fieldType = classPool.get(entry.getParam().getType().getName());
                    newField = new CtField(fieldType, entry.getParam().getName(), newClass);
                    CtMethod method = JavassistUtils.findMethod(oldClass, (Method)entry.getMember());
                    JavassistUtils.copyMethodAnnotationsToField(method, newField);
                }
                if (entry.getPrefix().length() > 0) {
                    this.overrideParameterPrefixes(newField, entry.getPrefixedNames());
                }
                if (entry.isRequired() && entry.hasValue()) {
                    this.disableBooleanMember(REQUIRED_MEMBER, newField);
                }
                if (entry.isPassword() && entry.hasValue()) {
                    this.disableBooleanMember(PASSWORD_MEMBER, newField);
                }
                newField.setName(newFieldName);
                newField.getFieldInfo().setAccessFlags(1);
                newClass.addField(newField);
            }
            for (CtClass clz : createdClasses.values()) {
                Class toClass = clz.toClass();
                Object instance = toClass.newInstance();
                this.translatedObjects.add(instance);
            }
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException | NullPointerException | CannotCompileException | NotFoundException e) {
            LOGGER.error("Unable to create classes", e);
            throw new RuntimeException();
        }
    }

    private void overrideParameterPrefixes(CtField field, String[] names) {
        String packageName = JCommander.class.getPackage().getName();
        AnnotationsAttribute fieldAttributes = (AnnotationsAttribute)field.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        for (Annotation annotation : fieldAttributes.getAnnotations()) {
            MemberValue namesMember;
            if (!annotation.getTypeName().startsWith(packageName) || (namesMember = annotation.getMemberValue(NAMES_MEMBER)) == null) continue;
            ArrayMemberValue arrayNamesMember = (ArrayMemberValue)namesMember;
            MemberValue[] newMemberValues = new MemberValue[names.length];
            for (int i = 0; i < names.length; ++i) {
                newMemberValues[i] = new StringMemberValue(names[i], field.getFieldInfo2().getConstPool());
            }
            arrayNamesMember.setValue(newMemberValues);
            fieldAttributes.setAnnotation(annotation);
            break;
        }
    }

    private void disableBooleanMember(String booleanMemberName, CtField field) {
        String packageName = JCommander.class.getPackage().getName();
        AnnotationsAttribute fieldAttributes = (AnnotationsAttribute)field.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
        for (Annotation annotation : fieldAttributes.getAnnotations()) {
            MemberValue requiredMember;
            if (!annotation.getTypeName().startsWith(packageName) || (requiredMember = annotation.getMemberValue(booleanMemberName)) == null) continue;
            BooleanMemberValue booleanRequiredMember = (BooleanMemberValue)requiredMember;
            booleanRequiredMember.setValue(false);
            fieldAttributes.setAnnotation(annotation);
            break;
        }
    }
}

