/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.prefix;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(JavassistUtils.class);
    public static final String PREFIX_PACKAGE = "org.locationtech.geowave.core.cli.parsed";
    private static final String uniqueId;
    private static int objectCounter;

    private JavassistUtils() {
    }

    public static AnnotationsAttribute cloneAnnotationsAttribute(ConstPool constPool, AnnotationsAttribute attr, ElementType validElementType) {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        AnnotationsAttribute attrNew = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        if (attr != null) {
            for (Annotation annotation : attr.getAnnotations()) {
                Annotation newAnnotation;
                block7: {
                    newAnnotation = new Annotation(annotation.getTypeName(), constPool);
                    try {
                        Class<?> annoClass = cl.loadClass(annotation.getTypeName());
                        Target target = annoClass.getAnnotation(Target.class);
                        if (target != null && !Arrays.asList(target.value()).contains((Object)validElementType)) {
                        }
                        break block7;
                    }
                    catch (ClassNotFoundException e) {
                        LOGGER.error("Cannot apply this annotation because it's type cannot be found", (Throwable)e);
                    }
                    continue;
                }
                if (annotation.getMemberNames() != null) {
                    for (Object memberName : annotation.getMemberNames()) {
                        MemberValue memberValue = annotation.getMemberValue((String)memberName);
                        if (memberValue == null) continue;
                        newAnnotation.addMemberValue((String)memberName, memberValue);
                    }
                }
                attrNew.addAnnotation(newAnnotation);
            }
        }
        return attrNew;
    }

    public static CtMethod findMethod(CtClass clz, Method m) throws NotFoundException {
        ClassPool pool = ClassPool.getDefault();
        Class<?>[] paramTypes = m.getParameterTypes();
        ArrayList<CtClass> paramTypesCtClass = new ArrayList<CtClass>();
        for (Class<?> claz : paramTypes) {
            paramTypesCtClass.add(pool.get(claz.getName()));
        }
        String desc = Descriptor.ofMethod((CtClass)pool.get(m.getReturnType().getName()), (CtClass[])paramTypesCtClass.toArray(new CtClass[0]));
        CtMethod method = clz.getMethod(m.getName(), desc);
        return method;
    }

    public static void copyClassAnnotations(CtClass oldClass, CtClass newClass) {
        AnnotationsAttribute classAnnotations = (AnnotationsAttribute)oldClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
        AnnotationsAttribute copyClassAttribute = JavassistUtils.cloneAnnotationsAttribute(newClass.getClassFile2().getConstPool(), classAnnotations, ElementType.TYPE);
        newClass.getClassFile().addAttribute((AttributeInfo)copyClassAttribute);
    }

    public static void copyMethodAnnotationsToField(CtMethod method, CtField field) {
        AnnotationsAttribute methodAnnotations = (AnnotationsAttribute)method.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
        AnnotationsAttribute copyMethodAttribute = JavassistUtils.cloneAnnotationsAttribute(field.getFieldInfo2().getConstPool(), methodAnnotations, ElementType.FIELD);
        field.getFieldInfo().addAttribute((AttributeInfo)copyMethodAttribute);
    }

    public static String getNextUniqueClassName() {
        return String.format("%s.cli_%s_%d", PREFIX_PACKAGE, uniqueId, objectCounter++);
    }

    public static String getNextUniqueFieldName() {
        return String.format("field_%d", objectCounter++);
    }

    public static CtClass generateEmptyClass() {
        ClassPool pool = ClassPool.getDefault();
        return pool.makeClass(JavassistUtils.getNextUniqueClassName());
    }

    static {
        objectCounter = 0;
        uniqueId = UUID.randomUUID().toString().replace('-', '_');
    }
}

