/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.prefix;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.JCommander;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.locationtech.geowave.core.cli.prefix.JCommanderPrefixTranslator;
import org.locationtech.geowave.core.cli.prefix.JCommanderTranslationMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrefixedJCommander
extends JCommander {
    private static Logger LOGGER = LoggerFactory.getLogger(PrefixedJCommander.class);
    private final Map<Object, JCommander> childCommanders;
    private List<Object> prefixedObjects = null;
    private boolean validate = true;
    private boolean allowUnknown = false;
    private IDefaultProvider defaultProvider = null;
    private JCommanderTranslationMap translationMap = null;
    private PrefixedJCommanderInitializer initializer = null;

    public PrefixedJCommander() {
        try {
            Field commandsField = JCommander.class.getDeclaredField("m_commands");
            commandsField.setAccessible(true);
            this.childCommanders = (Map)commandsField.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            LOGGER.error("Another version of JCommander is being used", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void createMap() {
        if (this.translationMap != null) {
            throw new RuntimeException("This PrefixedJCommander has already been used.");
        }
        if (this.initializer != null) {
            this.initializer.initialize(this);
        }
        JCommanderPrefixTranslator translator = new JCommanderPrefixTranslator();
        if (this.prefixedObjects != null) {
            for (Object obj : this.prefixedObjects) {
                translator.addObject(obj);
            }
        }
        this.translationMap = translator.translate();
        this.translationMap.createFacadeObjects();
        for (Object obj : this.translationMap.getObjects()) {
            this.addObject(obj);
        }
        this.translationMap.transformToFacade();
    }

    public void addCommand(String name, Object object, String ... aliases) {
        super.addCommand(name, new Object(), aliases);
        Iterator<Map.Entry<Object, JCommander>> iter = this.childCommanders.entrySet().iterator();
        Map.Entry<Object, JCommander> last = null;
        while (iter.hasNext()) {
            last = iter.next();
        }
        PrefixedJCommander comm = new PrefixedJCommander();
        comm.setProgramName(name, aliases);
        comm.setDefaultProvider(this.defaultProvider);
        comm.setAcceptUnknownOptions(this.allowUnknown);
        comm.setValidate(this.validate);
        if (object != null) {
            comm.addPrefixedObject(object);
        }
        if (last != null) {
            this.childCommanders.put(last.getKey(), comm);
        }
    }

    public void parse(String ... args) {
        this.createMap();
        if (this.validate) {
            super.parse(args);
        } else {
            super.parseWithoutValidation(args);
        }
        this.translationMap.transformToOriginal();
    }

    public void parseWithoutValidation(String ... args) {
        throw new NotImplementedException("Do not use this method.  Use setValidate()");
    }

    public void setDefaultProvider(IDefaultProvider defaultProvider) {
        super.setDefaultProvider(defaultProvider);
        this.defaultProvider = defaultProvider;
    }

    public void setAcceptUnknownOptions(boolean allowUnknown) {
        super.setAcceptUnknownOptions(allowUnknown);
        this.allowUnknown = allowUnknown;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public List<Object> getPrefixedObjects() {
        return this.prefixedObjects;
    }

    public void addPrefixedObject(Object object) {
        if (this.prefixedObjects == null) {
            this.prefixedObjects = new ArrayList<Object>();
        }
        this.prefixedObjects.add(object);
    }

    public JCommanderTranslationMap getTranslationMap() {
        return this.translationMap;
    }

    public PrefixedJCommanderInitializer getInitializer() {
        return this.initializer;
    }

    public void setInitializer(PrefixedJCommanderInitializer initializer) {
        this.initializer = initializer;
    }

    public static interface PrefixedJCommanderInitializer {
        public void initialize(PrefixedJCommander var1);
    }
}

