/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.prefix;

import com.beust.jcommander.Parameterized;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import org.locationtech.geowave.core.cli.utils.JCommanderParameterUtils;

public class TranslationEntry {
    private final Parameterized param;
    private final Object object;
    private final String prefix;
    private final String[] prefixedNames;
    private final AnnotatedElement member;

    protected TranslationEntry(Parameterized param, Object object, String prefix, AnnotatedElement member) {
        this.param = param;
        this.object = object;
        this.prefix = prefix;
        this.member = member;
        this.prefixedNames = this.addPrefixToNames();
    }

    public Parameterized getParam() {
        return this.param;
    }

    public Object getObject() {
        return this.object;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isMethod() {
        return this.member instanceof Method;
    }

    public AnnotatedElement getMember() {
        return this.member;
    }

    public String[] getPrefixedNames() {
        return this.prefixedNames;
    }

    public String getDescription() {
        String descriptionKey;
        String description = null;
        if (this.getParam().getParameter() != null && this.getParam().getParameter().descriptionKey() != null) {
            String descriptionKey2 = this.getParam().getParameter().descriptionKey();
            if (descriptionKey2 != null && !"".equals(descriptionKey2.trim())) {
                descriptionKey2 = descriptionKey2.trim();
                description = this.getDescriptionFromResourceBundle(descriptionKey2);
            }
        } else if (this.getParam().isDynamicParameter() && this.getParam().getWrappedParameter() != null && this.getParam().getWrappedParameter().getDynamicParameter() != null && (descriptionKey = this.getParam().getWrappedParameter().getDynamicParameter().descriptionKey()) != null && !"".equals(descriptionKey.trim())) {
            descriptionKey = descriptionKey.trim();
            description = this.getDescriptionFromResourceBundle(descriptionKey);
        }
        if (description == null || "".equals(description.trim())) {
            if (this.getParam().getParameter() != null && this.getParam().getParameter().description() != null) {
                description = this.getParam().getParameter().description();
            } else if (this.getParam().isDynamicParameter()) {
                description = this.getParam().getWrappedParameter().getDynamicParameter().description();
            }
        }
        return description == null ? "<no description>" : description;
    }

    private String getDescriptionFromResourceBundle(String descriptionKey) {
        ResourceBundle resourceBundle;
        String description = "";
        String bundleName = "GeoWaveLabels";
        Locale locale = Locale.getDefault();
        String defaultResourcePath = "GeoWaveLabels.properties";
        String localeResourcePath = "GeoWaveLabels_" + locale.toString() + ".properties";
        if ((this.getClass().getResource("/GeoWaveLabels.properties") != null || this.getClass().getResource("/" + localeResourcePath) != null) && (resourceBundle = ResourceBundle.getBundle("GeoWaveLabels", locale, ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES))) != null && resourceBundle.containsKey(descriptionKey)) {
            description = resourceBundle.getString(descriptionKey);
        }
        return description;
    }

    public boolean isPassword() {
        boolean isPassword = false;
        isPassword = isPassword || JCommanderParameterUtils.isPassword(this.getParam().getParameter());
        isPassword = isPassword || JCommanderParameterUtils.isPassword(this.getParam().getWrappedParameter().getParameter());
        return isPassword;
    }

    public boolean isHidden() {
        if (this.getParam().getParameter() != null) {
            return this.getParam().getParameter().hidden();
        }
        if (this.getParam().getWrappedParameter() != null) {
            return this.getParam().getWrappedParameter().hidden();
        }
        return false;
    }

    public boolean isRequired() {
        boolean isRequired = false;
        isRequired = isRequired || JCommanderParameterUtils.isRequired(this.getParam().getParameter());
        isRequired = isRequired || JCommanderParameterUtils.isRequired(this.getParam().getWrappedParameter().getParameter());
        return isRequired;
    }

    public boolean hasValue() {
        Object value = this.getParam().get(this.getObject());
        return value != null;
    }

    public String getAsPropertyName() {
        return this.trimNonAlphabetic(this.getLongestParam(this.getPrefixedNames()));
    }

    private String[] addPrefixToNames() {
        String[] names = null;
        names = this.param.getParameter() != null ? this.param.getParameter().names() : this.param.getWrappedParameter().names();
        String[] newNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            int j;
            String item = names[i];
            char subPrefix = item.charAt(0);
            for (j = 0; j < item.length() && item.charAt(j) == subPrefix; ++j) {
            }
            String prePrefix = item.substring(0, j);
            item = item.substring(j);
            newNames[i] = String.format("%s%s%s%s", prePrefix, this.prefix, ".", item);
        }
        return newNames;
    }

    private String getLongestParam(String[] names) {
        String longest = null;
        for (String name : names) {
            if (longest != null && name.length() <= longest.length()) continue;
            longest = name;
        }
        return longest;
    }

    private String trimNonAlphabetic(String str) {
        int i = 0;
        for (i = 0; i < str.length() && !Character.isAlphabetic(str.charAt(i)); ++i) {
        }
        return str.substring(i);
    }
}

