/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.utils;

import java.io.File;
import java.util.Scanner;

public class FileUtils {
    public static String formatFilePath(String filePath) {
        if (filePath != null) {
            if (filePath.indexOf("~") != -1) {
                filePath = filePath.replace("~", System.getProperty("user.home", "~"));
            }
            if (filePath.indexOf("$") != -1) {
                int startIndex = 0;
                while (startIndex != -1 && filePath.indexOf("$", startIndex) != -1) {
                    String resolvedValue;
                    String variable = FileUtils.getVariable(filePath.substring(startIndex));
                    if (!variable.equals(resolvedValue = FileUtils.resolveVariableValue(variable))) {
                        filePath = filePath.replace(variable, resolvedValue);
                    }
                    startIndex = filePath.indexOf("$", startIndex + 1);
                }
            }
        }
        return filePath;
    }

    private static String getVariable(String variable) {
        char nextChar;
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < variable.length() && ((nextChar = variable.charAt(index)) == '$' || Character.isLetterOrDigit(nextChar) || nextChar != File.separatorChar); ++index) {
            sb.append(nextChar);
        }
        return sb.toString();
    }

    private static String resolveVariableValue(String variable) {
        if (System.getenv().containsKey(variable)) {
            return System.getenv(variable);
        }
        if (System.getProperties().containsKey(variable)) {
            return System.getProperty(variable);
        }
        return variable;
    }

    public static String readFileContent(File inputFile) throws Exception {
        try (Scanner scanner = null;){
            scanner = new Scanner(inputFile, "UTF-8");
            String string = scanner.nextLine();
            return string;
        }
    }
}

