/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.utils;

import com.beust.jcommander.Parameter;
import java.lang.reflect.Constructor;
import org.locationtech.geowave.core.cli.converters.GeoWaveBaseConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCommanderParameterUtils {
    private static Logger LOGGER = LoggerFactory.getLogger(JCommanderParameterUtils.class);

    public static boolean isPassword(Parameter parameter) {
        boolean isPassword = false;
        if (parameter != null) {
            GeoWaveBaseConverter<?> converter;
            Class superClass = null;
            Class converterClass = parameter.converter();
            if (converterClass != null) {
                for (superClass = converterClass.getSuperclass(); superClass != null && superClass != GeoWaveBaseConverter.class; superClass = superClass.getSuperclass()) {
                }
            }
            if (superClass != null && superClass.equals(GeoWaveBaseConverter.class) && (converter = JCommanderParameterUtils.getParameterBaseConverter(parameter)) != null) {
                isPassword = isPassword || converter.isPassword();
            }
            isPassword = isPassword || parameter.password();
        }
        return isPassword;
    }

    public static boolean isRequired(Parameter parameter) {
        boolean isRequired = false;
        if (parameter != null) {
            GeoWaveBaseConverter<?> converter;
            if (parameter.converter() != null && parameter.converter().getSuperclass().equals(GeoWaveBaseConverter.class) && (converter = JCommanderParameterUtils.getParameterBaseConverter(parameter)) != null) {
                isRequired = isRequired || converter.isRequired();
            }
            isRequired = isRequired || parameter.required();
        }
        return isRequired;
    }

    private static GeoWaveBaseConverter<?> getParameterBaseConverter(Parameter parameter) {
        GeoWaveBaseConverter converter = null;
        try {
            Constructor ctor = parameter.converter().getConstructor(String.class);
            if (ctor != null) {
                converter = (GeoWaveBaseConverter)((Object)ctor.newInstance(""));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred getting converter from parameter: " + e.getLocalizedMessage(), (Throwable)e);
        }
        return converter;
    }
}

