/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URLUtils {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static String[] schemes = new String[]{"http", "https"};

    public static String getUrl(String url) throws URISyntaxException, MalformedURLException {
        if (url != null) {
            URL targetURL;
            URI uri;
            if (URLUtils.isValidURL(url)) {
                return url;
            }
            boolean valid = URLUtils.isValidScheme(url);
            if (!valid) {
                url = "http://" + url;
            }
            if ((uri = new URI(url)).getScheme() == null) {
                uri = new URI("http://" + url);
            }
            if ((targetURL = uri.toURL()).getPort() == -1) {
                targetURL = new URL(targetURL.getProtocol(), targetURL.getHost(), targetURL.getDefaultPort(), targetURL.getFile());
            }
            if (String.valueOf(targetURL.getPort()).endsWith("443")) {
                targetURL = new URL(HTTPS, targetURL.getHost(), targetURL.getPort(), targetURL.getFile());
            }
            return targetURL.toString();
        }
        return url;
    }

    private static boolean isValidURL(String url) {
        URL targetURL = null;
        try {
            targetURL = new URL(url);
        }
        catch (MalformedURLException e) {
            return false;
        }
        try {
            targetURL.toURI();
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    private static boolean isValidScheme(String url) {
        int ix = url.indexOf("://");
        if (ix == -1) {
            return false;
        }
        String inputScheme = url.substring(0, ix);
        for (String scheme : URLUtils.getSchemes()) {
            if (!inputScheme.equalsIgnoreCase(scheme)) continue;
            return true;
        }
        return false;
    }

    public static String[] getSchemes() {
        return schemes;
    }

    public static void setSchemes(String[] schemes) {
        URLUtils.schemes = schemes;
    }
}

