/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.core.cli.utils;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueConverter {
    private static Logger LOGGER = LoggerFactory.getLogger(ValueConverter.class);

    private ValueConverter() {
    }

    public static <X> X convert(Object value, Class<X> targetType) {
        LOGGER.trace("Attempting to convert " + value + " to class type " + targetType);
        if (value != null) {
            if (value.getClass() == targetType) {
                return (X)value;
            }
            if (value.getClass() == JSONObject.class || value.getClass() == JSONArray.class) {
                return (X)value;
            }
        }
        String strValue = String.valueOf(value);
        Object retval = ConvertUtils.convert((String)strValue, targetType);
        return (X)retval;
    }
}

