/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.image;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.locationtech.geowave.format.stanag4676.image.ImageChipUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageChip {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageChip.class);
    private final String mission;
    private final String trackId;
    private final long timeMillis;
    private final byte[] imageBinary;
    private BufferedImage image;

    public ImageChip(String mission, String trackId, long timeMillis, byte[] imageBinary) {
        this.mission = mission;
        this.trackId = trackId;
        this.timeMillis = timeMillis;
        this.imageBinary = imageBinary;
    }

    public String getMission() {
        return this.mission;
    }

    public String getTrackId() {
        return this.trackId;
    }

    public long getTimeMillis() {
        return this.timeMillis;
    }

    public byte[] getImageBinary() {
        return this.imageBinary;
    }

    public byte[] getDataId() {
        return ImageChipUtils.getDataId(this.mission, this.trackId, this.timeMillis);
    }

    public BufferedImage getImage(int targetPixelSize) {
        BufferedImage img;
        if (targetPixelSize <= 0 && (img = this.getImage()) != null && img.getType() != 5) {
            return ImageChipUtils.toBufferedImage(img, 5);
        }
        return ImageChipUtils.getImage(this.getImage(), targetPixelSize, 5);
    }

    private synchronized BufferedImage getImage() {
        if (this.image == null) {
            try {
                this.image = ImageIO.read(new ByteArrayInputStream(this.imageBinary));
            }
            catch (IOException e) {
                LOGGER.warn("Unable to read image chip", (Throwable)e);
            }
        }
        return this.image;
    }
}

