/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.IllegalDataException;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class JDOMUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDOMUtils.class);
    public static final String tagLayerBounds = "LayerBounds";
    public static final String tagX = "X";
    public static final String tagY = "Y";
    public static final String tagZ = "Z";
    public static final String tagLat = "Lat";
    public static final String tagLon = "Lon";
    public static final String tagAlt = "Alt";
    public static final String tagLL = "LL";
    public static final String tagUR = "UR";
    public static final String tagStart = "start";
    public static final String tagStop = "stop";

    public static Element parseDocument(URL docUrl) {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            builder.setValidation(false);
            Document doc = builder.build(docUrl);
            if (doc == null) {
                return null;
            }
            Element root = doc.getRootElement();
            return root;
        }
        catch (IOException ioe) {
            LOGGER.warn("parse error", (Throwable)ioe);
            return null;
        }
        catch (JDOMException jdome) {
            LOGGER.warn("parse error", (Throwable)jdome);
            return null;
        }
    }

    public static Element parseDocument(File f) {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = builder.build(f);
            if (doc == null) {
                return null;
            }
            Element root = doc.getRootElement();
            return root;
        }
        catch (IOException ioe) {
            LOGGER.warn("parse error", (Throwable)ioe);
            return null;
        }
        catch (JDOMException jdome) {
            LOGGER.warn("parse error", (Throwable)jdome);
            return null;
        }
    }

    public static Element parseDocument(InputStream is) {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = builder.build(is);
            if (doc == null) {
                return null;
            }
            Element root = doc.getRootElement();
            return root;
        }
        catch (IOException ioe) {
            LOGGER.warn("parse error", (Throwable)ioe);
            return null;
        }
        catch (JDOMException jdome) {
            LOGGER.warn("parse error", (Throwable)jdome);
            return null;
        }
    }

    public static Element parseDocument(InputSource is) {
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = builder.build(is);
            if (doc == null) {
                return null;
            }
            Element root = doc.getRootElement();
            return root;
        }
        catch (IOException ioe) {
            LOGGER.warn("parse error", (Throwable)ioe);
            return null;
        }
        catch (JDOMException jdome) {
            LOGGER.warn("parse error", (Throwable)jdome);
            return null;
        }
    }

    public static Element parseDocument(String filename) {
        File f = new File(filename);
        return JDOMUtils.parseDocument(f);
    }

    public static void writeElementToStream(Element e, OutputStream os) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            Document document = new Document((Element)e.clone());
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(document, (OutputStream)bos);
            bos.flush();
        }
        catch (IOException ioe) {
            LOGGER.info("write error", (Throwable)ioe);
        }
    }

    public static void writeElementToStreamPretty(Element e, OutputStream os) {
        try {
            BufferedOutputStream bos = new BufferedOutputStream(os);
            Document document = new Document((Element)e.clone());
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(document, (OutputStream)bos);
            bos.flush();
        }
        catch (IOException ioe) {
            LOGGER.info("write error", (Throwable)ioe);
        }
    }

    public static String writeElementToString(Element e) {
        try {
            StringWriter sw = new StringWriter();
            Document document = new Document((Element)e.clone());
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(document, (Writer)sw);
            return sw.getBuffer().toString();
        }
        catch (IOException ioe) {
            LOGGER.info("write error", (Throwable)ioe);
            return null;
        }
    }

    public static String writeElementToStringWithoutHeader(Element e) {
        try {
            StringWriter sw = new StringWriter();
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(e, (Writer)sw);
            return sw.getBuffer().toString();
        }
        catch (IOException ioe) {
            LOGGER.info("write error", (Throwable)ioe);
            return null;
        }
    }

    public static void writeElementToWriter(Element e, Writer writer) {
        try {
            Document document = new Document((Element)e.clone());
            XMLOutputter outputter = new XMLOutputter();
            outputter.output(document, writer);
        }
        catch (IOException ioe) {
            LOGGER.info("write error", (Throwable)ioe);
        }
    }

    public static Document readDocumentFromString(String xmlData) {
        try {
            StringReader sr = new StringReader(xmlData);
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = builder.build((Reader)sr);
            return doc;
        }
        catch (IOException ioe) {
            LOGGER.info("read error", (Throwable)ioe);
            return null;
        }
        catch (JDOMException jdome) {
            LOGGER.info("read error", (Throwable)jdome);
            return null;
        }
    }

    public static Element readElementFromString(String xmlData) {
        try {
            StringReader sr = new StringReader(xmlData);
            SAXBuilder builder = new SAXBuilder();
            builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = builder.build((Reader)sr);
            if (doc == null) {
                return null;
            }
            Element root = doc.getRootElement();
            return root;
        }
        catch (IOException ioe) {
            LOGGER.info("read error", (Throwable)ioe);
            return null;
        }
        catch (JDOMException jdome) {
            LOGGER.info("read error", (Throwable)jdome);
            return null;
        }
    }

    public static String getProp(Element e, String childName, Logger logger, String errorMessage) {
        Element childEl = e.getChild(childName);
        if (childEl == null) {
            logger.error(errorMessage);
            return null;
        }
        String val = childEl.getTextTrim();
        if (val == null) {
            logger.error(errorMessage);
            return null;
        }
        return val;
    }

    public static Element writeElementList(String tag, Collection<?> c) {
        Element el = new Element(tag);
        try {
            el.addContent(c);
        }
        catch (IllegalAddException e) {
            LOGGER.warn((Object)((Object)e) + ":  " + el.toString(), (Throwable)e);
        }
        return el;
    }

    public static Element writeElementList(String tag, Collection<?> c, Namespace ns) {
        Element e = new Element(tag, ns);
        e.addContent(c);
        return e;
    }

    public static Element writeElement(String tag, Element childElm) {
        Element e = new Element(tag);
        e.addContent((Content)childElm);
        return e;
    }

    public static Element writeElement(String tag, Element childElm, Namespace ns) {
        Element e = new Element(tag, ns);
        e.addContent((Content)childElm);
        return e;
    }

    public static Element writeStringVal(String tag, String val) {
        Element e = new Element(tag);
        JDOMUtils.addSanitizedContent(e, val);
        return e;
    }

    public static Element writeStringVal(String tag, String val, Namespace ns) {
        Element e = new Element(tag, ns);
        JDOMUtils.addSanitizedContent(e, val);
        return e;
    }

    private static void addSanitizedContent(Element e, String val) {
        try {
            e.addContent(val);
        }
        catch (IllegalDataException ide) {
            LOGGER.warn("Unable to add content", (Throwable)ide);
            StringBuffer newVal = new StringBuffer();
            int len = val.length();
            for (int i = 0; i < len; ++i) {
                if (Verifier.isXMLCharacter((int)val.charAt(i))) {
                    newVal.append(val.charAt(i));
                    continue;
                }
                newVal.append(' ');
            }
            e.addContent(newVal.toString());
        }
    }

    public static String getStringVal(Element e, String childText, Namespace ns) {
        if (e == null) {
            return null;
        }
        return e.getChildTextTrim(childText, ns);
    }

    public static String getStringVal(Element e) {
        return JDOMUtils.getStringVal(e, true);
    }

    public static String getStringVal(Element e, boolean trim) {
        if (e == null) {
            return null;
        }
        if (trim) {
            return e.getTextTrim();
        }
        return e.getText();
    }

    public static String getStringVal(Element e, String childText) {
        return JDOMUtils.getStringVal(e, childText, true);
    }

    public static String getStringVal(Element e, String childText, boolean trim) {
        if (e == null) {
            return null;
        }
        if (trim) {
            return e.getChildTextTrim(childText);
        }
        return e.getChildText(childText);
    }

    public static Element writeEmptyProperty(String tag) {
        Element e = new Element(tag);
        return e;
    }

    public static Element writeDoubleVal(String tag, double d) {
        return JDOMUtils.writeStringVal(tag, Double.toString(d));
    }

    public static Element writeDoubleVal(String tag, double d, Namespace ns) {
        return JDOMUtils.writeStringVal(tag, Double.toString(d), ns);
    }

    public static Double getDoubleVal(Element e) {
        try {
            return Double.valueOf(e.getText());
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Double getDoubleVal(Element e, String childText, double defaultValue) {
        Double value = JDOMUtils.getDoubleVal(e, childText);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Double getDoubleVal(Element e, String childText) {
        try {
            return Double.valueOf(e.getChildText(childText));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Double getDoubleVal(Element e, String childText, Namespace ns) {
        try {
            return Double.valueOf(e.getChildText(childText, ns));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Double getAttrDoubleVal(Element e, String attrName) {
        try {
            return Double.valueOf(e.getAttributeValue(attrName));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Element writeFloatVal(String tag, float f) {
        return JDOMUtils.writeStringVal(tag, Float.toString(f));
    }

    public static Float getFloatVal(Element e, String childText) {
        String str = JDOMUtils.getStringVal(e, childText);
        Float val = null;
        if (str != null) {
            try {
                val = Float.valueOf(Float.parseFloat(str));
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to get parse", (Throwable)ex);
            }
        }
        return val;
    }

    public static Element writeIntegerVal(String tag, int i) {
        return JDOMUtils.writeStringVal(tag, Integer.toString(i));
    }

    public static Element writeIntegerVal(String tag, int i, Namespace ns) {
        return JDOMUtils.writeStringVal(tag, Integer.toString(i), ns);
    }

    public static Element writeShortVal(String tag, short s) {
        return JDOMUtils.writeStringVal(tag, Short.toString(s));
    }

    public static Element writeShortVal(String tag, short s, Namespace ns) {
        return JDOMUtils.writeStringVal(tag, Short.toString(s), ns);
    }

    public static Short getShortVal(Element e) {
        try {
            return Short.valueOf(e.getText());
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Short getShortVal(Element e, String childText, short defaultValue) {
        Short value = JDOMUtils.getShortVal(e, childText);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Short getShortVal(Element e, String childText) {
        try {
            return Short.valueOf(e.getChildText(childText));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Short getShortVal(Element e, String childText, Namespace ns) {
        try {
            return Short.valueOf(e.getChildText(childText, ns));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Element writeByteVal(String tag, byte b) {
        return JDOMUtils.writeStringVal(tag, Byte.toString(b));
    }

    public static Element writeByteVal(String tag, byte b, Namespace ns) {
        return JDOMUtils.writeStringVal(tag, Byte.toString(b), ns);
    }

    public static Byte getByteVal(Element e) {
        try {
            return Byte.valueOf(e.getText());
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Byte getByteVal(Element e, String childText) {
        try {
            return Byte.valueOf(e.getChildText(childText));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Byte getByteVal(Element e, String childText, Namespace ns) {
        try {
            return Byte.valueOf(e.getChildText(childText, ns));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Integer getIntegerVal(Element e) {
        try {
            return Integer.valueOf(e.getText());
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Integer getIntegerVal(Element e, String childText, int defaultValue) {
        Integer value = JDOMUtils.getIntegerVal(e, childText);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Integer getIntegerVal(Element e, String childText) {
        try {
            return Integer.valueOf(e.getChildText(childText));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Integer getIntegerVal(Element e, String childText, Namespace ns) {
        try {
            return Integer.valueOf(e.getChildText(childText, ns));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Element writeLongVal(String tag, long i) {
        return JDOMUtils.writeStringVal(tag, Long.toString(i));
    }

    public static Element writeLongVal(String tag, long i, Namespace ns) {
        return JDOMUtils.writeStringVal(tag, Long.toString(i), ns);
    }

    public static Long getLongVal(Element e) {
        try {
            return Long.valueOf(e.getText());
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Long getLongVal(Element e, String childText, long defaultValue) {
        Long value = JDOMUtils.getLongVal(e, childText);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static Long getLongVal(Element e, String childTag) {
        try {
            return Long.valueOf(e.getChildText(childTag));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Long getLongVal(Element e, String childText, Namespace ns) {
        try {
            return Long.valueOf(e.getChildText(childText, ns));
        }
        catch (NumberFormatException ex) {
            LOGGER.error("Unable to get value", (Throwable)ex);
            return null;
        }
    }

    public static Element writeBooleanVal(String tag, Boolean b) {
        if (b == null) {
            return JDOMUtils.writeStringVal(tag, "");
        }
        return JDOMUtils.writeStringVal(tag, Boolean.toString(b));
    }

    public static boolean getBooleanVal(Element e, String childTag, boolean defaultValue) {
        if (e == null || e.getChildText(childTag) == null) {
            return defaultValue;
        }
        Boolean value = JDOMUtils.getBooleanVal(e, childTag);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="its private and only used by methods that check for null")
    private static Boolean getBooleanVal(Element e, String childTag) {
        String text = e.getChildText(childTag);
        if (text == null || text.isEmpty()) {
            return null;
        }
        return Boolean.valueOf(text.trim());
    }

    public static boolean getBooleanVal(Element e, boolean defaultValue) {
        if (e == null || e.getText() == null) {
            return defaultValue;
        }
        Boolean value = JDOMUtils.getBooleanVal(e);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="its private and only used by methods that check for null")
    private static Boolean getBooleanVal(Element e) {
        String text = e.getText();
        if (text == null || text.isEmpty()) {
            return null;
        }
        return Boolean.valueOf(text);
    }

    public static Element getElementVal(Element e, String tag) {
        return e.getChild(tag);
    }

    public static Point2d readPoint(String tagName, Element parentEl) {
        Element ptEl = parentEl.getChild(tagName);
        if (ptEl == null) {
            return null;
        }
        double lat = JDOMUtils.getDoubleVal(ptEl, tagLat);
        double lon = JDOMUtils.getDoubleVal(ptEl, tagLon);
        return new Point2d(lon, lat);
    }

    public static Point2d readPoint(Element ptEl) {
        if (ptEl == null) {
            return null;
        }
        double lat = JDOMUtils.getDoubleVal(ptEl, tagLat);
        double lon = JDOMUtils.getDoubleVal(ptEl, tagLon);
        return new Point2d(lon, lat);
    }

    public static Element writePoint(String tagName, Point2d pt) {
        ArrayList<Element> v = new ArrayList<Element>();
        v.add(JDOMUtils.writeDoubleVal(tagLat, pt.y));
        v.add(JDOMUtils.writeDoubleVal(tagLon, pt.x));
        return JDOMUtils.writeElementList(tagName, v);
    }

    public static Element writePointList(String tagName, ArrayList<Point2d> pts) {
        StringBuffer sb = new StringBuffer();
        int nPts = pts.size();
        int idx = 0;
        for (Point2d pt : pts) {
            sb.append(Double.toString(pt.x));
            sb.append(",");
            sb.append(Double.toString(pt.y));
            if (idx < nPts - 1) {
                sb.append(",");
            }
            ++idx;
        }
        return JDOMUtils.writeStringVal(tagName, sb.toString());
    }

    public static ArrayList<Point2d> readPointList(Element el) {
        ArrayList<Point2d> pts = new ArrayList<Point2d>();
        String ptStr = JDOMUtils.getStringVal(el);
        StringTokenizer st = new StringTokenizer(ptStr, ",");
        while (st.hasMoreTokens()) {
            try {
                String xStr = st.nextToken();
                String yStr = st.nextToken();
                double x = Double.parseDouble(xStr);
                double y = Double.parseDouble(yStr);
                pts.add(new Point2d(x, y));
            }
            catch (Exception e) {
                LOGGER.warn("error parsing point list", (Throwable)e);
                return null;
            }
        }
        return pts;
    }

    public static Element writePoint3dList(String tagName, ArrayList<Point3d> pts) {
        if (pts == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int nPts = pts.size();
        int idx = 0;
        for (Point3d pt : pts) {
            sb.append(Double.toString(pt.x));
            sb.append(",");
            sb.append(Double.toString(pt.y));
            sb.append(",");
            sb.append(Double.toString(pt.z));
            if (idx < nPts - 1) {
                sb.append(",");
            }
            ++idx;
        }
        return JDOMUtils.writeStringVal(tagName, sb.toString());
    }

    public static ArrayList<Point3d> readPoint3dList(Element parentEl, String tagName) {
        Element el = parentEl.getChild(tagName);
        if (el == null) {
            return null;
        }
        ArrayList<Point3d> pts = new ArrayList<Point3d>();
        String ptStr = JDOMUtils.getStringVal(el);
        StringTokenizer st = new StringTokenizer(ptStr, ",");
        while (st.hasMoreTokens()) {
            try {
                String xStr = st.nextToken();
                String yStr = st.nextToken();
                String zStr = st.nextToken();
                double x = Double.parseDouble(xStr);
                double y = Double.parseDouble(yStr);
                double z = Double.parseDouble(zStr);
                pts.add(new Point3d(x, y, z));
            }
            catch (Exception e) {
                LOGGER.warn("error parsing point list", (Throwable)e);
                return null;
            }
        }
        return pts;
    }

    public static Element writePoint2d(String tagName, Point2d pt) {
        ArrayList<Element> v = new ArrayList<Element>();
        v.add(JDOMUtils.writeDoubleVal(tagX, pt.x));
        v.add(JDOMUtils.writeDoubleVal(tagY, pt.y));
        return JDOMUtils.writeElementList(tagName, v);
    }

    public static Point2d readPoint2d(String tagName, Element parentEl) {
        Element ptEl = parentEl.getChild(tagName);
        if (ptEl == null) {
            return null;
        }
        double x = JDOMUtils.getDoubleVal(ptEl, tagX);
        double y = JDOMUtils.getDoubleVal(ptEl, tagY);
        return new Point2d(x, y);
    }

    public static Point2d readPoint2d(Element ptEl) {
        if (ptEl == null) {
            return null;
        }
        double x = JDOMUtils.getDoubleVal(ptEl, tagX);
        double y = JDOMUtils.getDoubleVal(ptEl, tagY);
        return new Point2d(x, y);
    }

    public static Element writePoint3d(String tagName, Point3d pt) {
        ArrayList<Element> v = new ArrayList<Element>();
        v.add(JDOMUtils.writeDoubleVal(tagX, pt.x));
        v.add(JDOMUtils.writeDoubleVal(tagY, pt.y));
        v.add(JDOMUtils.writeDoubleVal(tagZ, pt.z));
        return JDOMUtils.writeElementList(tagName, v);
    }

    public static Point3d readPoint3d(String tagName, Element parentEl) {
        Element ptEl = parentEl.getChild(tagName);
        if (ptEl == null) {
            return null;
        }
        double x = JDOMUtils.getDoubleVal(ptEl, tagX);
        double y = JDOMUtils.getDoubleVal(ptEl, tagY);
        double z = JDOMUtils.getDoubleVal(ptEl, tagZ);
        return new Point3d(x, y, z);
    }

    public static Point3d readPoint3d(Element ptEl) {
        if (ptEl == null) {
            return null;
        }
        double x = JDOMUtils.getDoubleVal(ptEl, tagX);
        double y = JDOMUtils.getDoubleVal(ptEl, tagY);
        double z = JDOMUtils.getDoubleVal(ptEl, tagZ);
        return new Point3d(x, y, z);
    }

    public static Point2d[] readBounds(String tagName, Element parentEl) {
        Element boundsEl = parentEl.getChild(tagName);
        if (boundsEl == null) {
            return null;
        }
        return JDOMUtils.readBounds(boundsEl);
    }

    public static Point2d[] readBounds(Element boundsEl) {
        if (boundsEl == null) {
            return null;
        }
        Point2d ll = JDOMUtils.readPoint(tagLL, boundsEl);
        if (ll == null) {
            return null;
        }
        Point2d ur = JDOMUtils.readPoint(tagUR, boundsEl);
        Point2d[] bounds = new Point2d[]{ll, ur};
        return bounds;
    }

    public static Element writeBounds(String tagName, Point2d[] bounds) {
        ArrayList<Element> v = new ArrayList<Element>();
        if (bounds != null && bounds[0] != null) {
            v.add(JDOMUtils.writePoint(tagLL, bounds[0]));
            v.add(JDOMUtils.writePoint(tagUR, bounds[1]));
        }
        return JDOMUtils.writeElementList(tagName, v);
    }

    public static ArrayList<Double> readDoubleList(String tagName, Element elList) {
        List doubleElementList = elList.getChildren(tagName);
        ArrayList<Double> doubleList = new ArrayList<Double>();
        for (Object doubleElement : doubleElementList) {
            doubleList.add(JDOMUtils.getDoubleVal((Element)doubleElement));
        }
        return doubleList;
    }

    public static ArrayList<Element> writeDoubleList(String tagName, List<Double> doubleList) {
        ArrayList<Element> doubleElementList = new ArrayList<Element>();
        for (Double doubleVal : doubleList) {
            doubleElementList.add(JDOMUtils.writeDoubleVal(tagName, doubleVal));
        }
        return doubleElementList;
    }

    public static ArrayList<Color> readColorList(String tagName, Element elList) {
        List colorElementList = elList.getChildren(tagName);
        ArrayList<Color> colorList = new ArrayList<Color>();
        for (Object colorElement : colorElementList) {
            colorList.add(JDOMUtils.readColor((Element)colorElement));
        }
        return colorList;
    }

    public static ArrayList<Element> writeColorList(String tagName, List<Color> colorList) {
        ArrayList<Element> colorElementList = new ArrayList<Element>();
        for (Color color : colorList) {
            colorElementList.add(JDOMUtils.writeColor(tagName, color));
        }
        return colorElementList;
    }

    public static Date readDate(String tagName, Element parentEl) {
        Element boundsEl = parentEl.getChild(tagName);
        if (boundsEl == null) {
            return null;
        }
        Long startL = JDOMUtils.getLongVal(boundsEl);
        if (startL == null) {
            return null;
        }
        return new Date(startL);
    }

    public static Element writeDate(String tagName, Date date) {
        if (date != null) {
            return JDOMUtils.writeLongVal(tagName, date.getTime());
        }
        return null;
    }

    public static Element writeColor(String tagName, Color c) {
        return JDOMUtils.writeIntegerVal(tagName, c.getRGB());
    }

    public static Color readColor(String tagName, Element el) {
        if (el == null) {
            return null;
        }
        Integer colVal = JDOMUtils.getIntegerVal(el.getChild(tagName));
        if (colVal == null) {
            return null;
        }
        return new Color(colVal, true);
    }

    public static String readStringVal(String tag, Element el) {
        if (el == null) {
            return null;
        }
        String strVal = el.getChildText(tag);
        return strVal;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="its known that it can return null")
    public static Boolean readBooleanVal(String tag, Element el) {
        if (el == null) {
            return null;
        }
        Boolean boolVal = JDOMUtils.getBooleanVal(el, tag);
        return boolVal;
    }

    public static Double readDoubleVal(String tag, Element el) {
        if (el == null) {
            return null;
        }
        return JDOMUtils.getDoubleVal(el, tag);
    }

    public static Integer readIntegerVal(String tag, Element el) {
        if (el == null) {
            return null;
        }
        return JDOMUtils.getIntegerVal(el, tag);
    }

    public static Color readColor(Element el) {
        if (el == null) {
            return null;
        }
        int colVal = JDOMUtils.getIntegerVal(el);
        return new Color(colVal);
    }

    public static Element findFirstChild(Element parentEl, String childName) {
        ElementFilter filter = new ElementFilter(childName);
        Iterator childrenIter = parentEl.getDescendants((Filter)filter);
        if (childrenIter.hasNext()) {
            return (Element)childrenIter.next();
        }
        return null;
    }

    public static Element getChildIgnoreNamespace(Element parentEl, String childName, Namespace[] namespaces, boolean tryLowerCase) {
        Element el = parentEl.getChild(childName);
        if (el == null) {
            Namespace ns;
            Namespace[] namespaceArray = namespaces;
            int n = namespaceArray.length;
            for (int i = 0; i < n && (el = parentEl.getChild(childName, ns = namespaceArray[i])) == null; ++i) {
            }
        }
        if (el == null && tryLowerCase) {
            el = JDOMUtils.getChildIgnoreNamespace(parentEl, childName.toLowerCase(Locale.ENGLISH), namespaces, false);
        }
        return el;
    }

    public static List<Element> getChildrenIgnoreNamespace(Element parentEl, String childName, Namespace[] namespaces, boolean tryLowerCase) {
        List el = parentEl.getChildren(childName);
        if (el == null || el.isEmpty()) {
            Namespace ns;
            Namespace[] namespaceArray = namespaces;
            int n = namespaceArray.length;
            for (int i = 0; i < n && ((el = parentEl.getChildren(childName, ns = namespaceArray[i])) == null || el.isEmpty()); ++i) {
            }
        }
        if (el == null && tryLowerCase) {
            el = JDOMUtils.getChildrenIgnoreNamespace(parentEl, childName.toLowerCase(Locale.ENGLISH), namespaces, false);
        }
        if (el == null) {
            return new ArrayList<Element>();
        }
        ArrayList<Element> elementList = new ArrayList<Element>();
        for (Object element : el) {
            elementList.add((Element)element);
        }
        return elementList;
    }

    public static String getStringValIgnoreNamespace(Element parentEl, String childName, Namespace[] namespaces, boolean tryLowerCase) {
        Element el = JDOMUtils.getChildIgnoreNamespace(parentEl, childName, namespaces, tryLowerCase);
        if (el != null) {
            return el.getTextTrim();
        }
        return null;
    }

    public static Double getDoubleValIgnoreNamespace(Element rootEl, String tagName, Namespace[] namespaces, boolean tryLowerCase) {
        String str = JDOMUtils.getStringValIgnoreNamespace(rootEl, tagName, namespaces, tryLowerCase);
        Double val = null;
        if (str != null) {
            try {
                val = Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Unable to parse", (Throwable)e);
            }
        }
        return val;
    }

    public static Float getFloatValIgnoreNamespace(Element rootEl, String tagName, Namespace[] namespaces, boolean tryLowerCase) {
        String str = JDOMUtils.getStringValIgnoreNamespace(rootEl, tagName, namespaces, tryLowerCase);
        Float val = null;
        if (str != null) {
            try {
                val = Float.valueOf(Float.parseFloat(str));
            }
            catch (NumberFormatException e) {
                LOGGER.error("Unable to parse", (Throwable)e);
            }
        }
        return val;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="its known that it can return null")
    public static Boolean getBoolValIgnoreNamespace(Element rootEl, String tagName, Namespace[] namespaces, boolean tryLowerCase) {
        String str = JDOMUtils.getStringValIgnoreNamespace(rootEl, tagName, namespaces, tryLowerCase);
        if (str != null) {
            Integer val = null;
            try {
                val = Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                LOGGER.error("Unable to parse", (Throwable)e);
            }
            if (val != null) {
                if (val == 0) {
                    return false;
                }
                return true;
            }
        }
        return null;
    }

    public static String getAttrStringValIgnoreNamespace(Element resourceEl, String attrName) {
        List resourceAttr = resourceEl.getAttributes();
        if (resourceAttr != null) {
            for (Object attrEl : resourceAttr) {
                Attribute attr = (Attribute)attrEl;
                if (!attrName.equalsIgnoreCase(attr.getName())) continue;
                return attr.getValue();
            }
        }
        return null;
    }

    public static Document string2Doc(String xml) {
        try {
            SAXBuilder builder = new SAXBuilder();
            return builder.build(new InputSource(new StringReader(xml)));
        }
        catch (JDOMException e) {
            LOGGER.error("Unable to build the SAXBuilder", (Throwable)e);
            return null;
        }
        catch (IOException e1) {
            LOGGER.error("Unable to build the SAXBuilder", (Throwable)e1);
            return null;
        }
    }

    public static String doc2String(Document doc) {
        StringWriter sw = new StringWriter();
        Format format = Format.getRawFormat().setEncoding("UTF-8");
        XMLOutputter xmlOut = new XMLOutputter(format);
        String strOutput = null;
        if (doc != null) {
            try {
                xmlOut.output(doc, (Writer)sw);
                strOutput = sw.toString();
            }
            catch (IOException e) {
                LOGGER.error("Unable to retrieve the xml output", (Throwable)e);
                return null;
            }
        }
        return strOutput;
    }
}

