/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.parser;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.locationtech.geowave.format.stanag4676.parser.TrackDecoder;
import org.locationtech.geowave.format.stanag4676.parser.model.Area;
import org.locationtech.geowave.format.stanag4676.parser.model.ClassificationCredibility;
import org.locationtech.geowave.format.stanag4676.parser.model.ClassificationLevel;
import org.locationtech.geowave.format.stanag4676.parser.model.CovarianceMatrix;
import org.locationtech.geowave.format.stanag4676.parser.model.ExerciseIndicator;
import org.locationtech.geowave.format.stanag4676.parser.model.GeodeticPosition;
import org.locationtech.geowave.format.stanag4676.parser.model.IDdata;
import org.locationtech.geowave.format.stanag4676.parser.model.Identity;
import org.locationtech.geowave.format.stanag4676.parser.model.LineageRelation;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionFrame;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionSummary;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionSummaryMessage;
import org.locationtech.geowave.format.stanag4676.parser.model.ModalityType;
import org.locationtech.geowave.format.stanag4676.parser.model.MotionEventPoint;
import org.locationtech.geowave.format.stanag4676.parser.model.MotionImagery;
import org.locationtech.geowave.format.stanag4676.parser.model.NATO4676Message;
import org.locationtech.geowave.format.stanag4676.parser.model.ObjectClassification;
import org.locationtech.geowave.format.stanag4676.parser.model.Security;
import org.locationtech.geowave.format.stanag4676.parser.model.SimulationIndicator;
import org.locationtech.geowave.format.stanag4676.parser.model.SymbolicSpectralRange;
import org.locationtech.geowave.format.stanag4676.parser.model.Track;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackClassification;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackEnvironment;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackEvent;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackIdentity;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackManagement;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackMessage;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackPoint;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackPointDetail;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackPointType;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackStatus;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NATO4676Decoder
implements TrackDecoder {
    HashMap<String, Track> trackMap = new HashMap();
    private int trackStatsNumTracks = 0;
    private int trackStatsNumDots = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(NATO4676Decoder.class);
    boolean printNotParse = false;

    @Override
    public void initialize() {
        this.trackStatsNumTracks = 0;
        this.trackStatsNumDots = 0;
    }

    public void setPrintNotParse(boolean shouldPrint) {
        this.printNotParse = shouldPrint;
    }

    @Override
    public NATO4676Message readNext(InputStream is) {
        NATO4676Message msg = null;
        try {
            if (this.printNotParse) {
                String trackStr = IOUtils.toString((InputStream)is, (String)"UTF-8");
                is.reset();
            } else {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(is);
                Element rootEl = doc.getRootElement();
                Namespace xmlns = rootEl.getNamespace();
                String name = rootEl.getName();
                if ("TrackMessage".equals(name)) {
                    msg = this.readTrackMessage(rootEl, xmlns);
                    LOGGER.info("TrackMessage read " + this.trackStatsNumTracks + " Tracks and " + this.trackStatsNumDots + " TrackPoints.");
                } else if ("MissionSummary".equals(name)) {
                    msg = this.readMissionSummaryMessage(rootEl, xmlns);
                }
            }
        }
        catch (JDOMParseException jdomPe) {
            LOGGER.info("jdomParseException: " + jdomPe.getLocalizedMessage(), (Throwable)jdomPe);
            return null;
        }
        catch (IOException ioe) {
            LOGGER.info("IO exception: " + ioe.getLocalizedMessage(), (Throwable)ioe);
            return null;
        }
        catch (JDOMException jdome) {
            LOGGER.info("jdomException: " + jdome.getLocalizedMessage(), (Throwable)jdome);
            return null;
        }
        return msg;
    }

    private MissionSummaryMessage readMissionSummaryMessage(Element element, Namespace xmlns) {
        MissionSummaryMessage msg = new MissionSummaryMessage();
        MissionSummary missionSummary = msg.getMissionSummary();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("missionID".equals(childName)) {
                missionSummary.setMissionId(childValue);
                continue;
            }
            if ("Name".equals(childName)) {
                missionSummary.setName(childValue);
                continue;
            }
            if ("Security".equals(childName)) {
                msg.setSecurity(this.readSecurity(child, xmlns));
                missionSummary.setSecurity(msg.getSecurity().getClassification().toString());
                continue;
            }
            if ("msgCreatedTime".equals(childName)) {
                msg.setMessageTime(this.DateStringToLong(childValue));
                continue;
            }
            if ("senderId".equals(childName)) {
                msg.setSenderID(this.readIDdata(child, xmlns));
                continue;
            }
            if ("StartTime".equals(childName)) {
                missionSummary.setStartTime(this.DateStringToLong(childValue));
                continue;
            }
            if ("EndTime".equals(childName)) {
                missionSummary.setEndTime(this.DateStringToLong(childValue));
                continue;
            }
            if ("FrameInformation".equals(childName)) {
                missionSummary.addFrame(this.readFrame(child, xmlns));
                continue;
            }
            if ("CoverageArea".equals(childName)) {
                missionSummary.setCoverageArea(this.readCoverageArea(child, xmlns));
                continue;
            }
            if (!"ActiveObjectClassifications".equals(childName)) continue;
            missionSummary.setClassifications(this.readObjectClassifications(child, xmlns));
        }
        return msg;
    }

    private List<ObjectClassification> readObjectClassifications(Element element, Namespace xmlns) {
        ArrayList<ObjectClassification> objClassList = new ArrayList<ObjectClassification>();
        List children = element.getChildren();
        for (Element child : children) {
            ObjectClassification classification;
            String childName = child.getName();
            String childValue = child.getValue();
            if (!"classification".equals(childName) || (classification = ObjectClassification.fromString(childValue)) == null) continue;
            objClassList.add(classification);
        }
        return objClassList;
    }

    private MissionFrame readFrame(Element element, Namespace xmlns) {
        MissionFrame frame = new MissionFrame();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("frameNumber".equals(childName)) {
                frame.setFrameNumber(Integer.parseInt(childValue));
                continue;
            }
            if ("frameTimestamp".equals(childName)) {
                frame.setFrameTime(this.DateStringToLong(childValue));
                continue;
            }
            if (!"frameCoverageArea".equals(childName)) continue;
            frame.setCoverageArea(this.readCoverageArea(child, xmlns));
        }
        return frame;
    }

    private TrackMessage readTrackMessage(Element element, Namespace xmlns) {
        TrackMessage msg = new TrackMessage();
        msg.setUuid(UUID.randomUUID());
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("stanagVersion".equals(childName)) {
                msg.setFormatVersion(childValue);
                continue;
            }
            if ("messageSecurity".equals(childName)) {
                msg.setSecurity(this.readSecurity(child, xmlns));
                continue;
            }
            if ("msgCreatedTime".equals(childName)) {
                msg.setMessageTime(this.DateStringToLong(childValue));
                continue;
            }
            if ("senderId".equals(childName)) {
                msg.setSenderID(this.readIDdata(child, xmlns));
                continue;
            }
            if (!"tracks".equals(childName)) continue;
            msg.addTrackEvent(this.readTrackEvent(child, xmlns));
        }
        return msg;
    }

    private Security readSecurity(Element element, Namespace xmlns) {
        Security security = new Security();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("securityClassification".equals(childName)) {
                try {
                    security.setClassification(ClassificationLevel.valueOf(childValue));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set classification level", (Throwable)iae);
                    security.setClassification(null);
                }
            }
            if ("securityPolicyName".equals(childName)) {
                security.setPolicyName(childValue);
            }
            if ("securityControlSystem".equals(childName)) {
                security.setControlSystem(childValue);
            }
            if ("securityDissemination".equals(childName)) {
                security.setDissemination(childValue);
            }
            if (!"securityReleasability".equals(childName)) continue;
            security.setReleasability(childValue);
        }
        return security;
    }

    private IDdata readIDdata(Element element, Namespace xmlns) {
        IDdata id = new IDdata();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("stationID".equals(childName)) {
                id.setStationId(childValue);
                continue;
            }
            if (!"nationality".equals(childName)) continue;
            id.setNationality(childValue);
        }
        return id;
    }

    private TrackEvent readTrackEvent(Element element, Namespace xmlns) {
        TrackEvent trackEvent = new TrackEvent();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("trackUUID".equals(childName)) {
                trackEvent.setUuid(childValue);
                continue;
            }
            if ("trackNumber".equals(childName)) {
                trackEvent.setTrackNumber(childValue);
                continue;
            }
            if ("trackStatus".equals(childName)) {
                try {
                    trackEvent.setStatus(TrackStatus.valueOf(childValue));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set status", (Throwable)iae);
                    trackEvent.setStatus(null);
                }
                continue;
            }
            if ("trackSecurity".equals(childName)) {
                trackEvent.setSecurity(this.readSecurity(child, xmlns));
                continue;
            }
            if ("trackComment".equals(childName)) {
                trackEvent.setComment(childValue);
                continue;
            }
            if ("missionID".equals(childName)) {
                trackEvent.setMissionId(childValue);
                continue;
            }
            if ("exerciseIndicator".equals(childName)) {
                try {
                    trackEvent.setExerciseIndicator(ExerciseIndicator.valueOf(childValue));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set exercise indicator", (Throwable)iae);
                    trackEvent.setExerciseIndicator(null);
                }
                continue;
            }
            if ("simulationIndicator".equals(childName)) {
                try {
                    trackEvent.setSimulationIndicator(SimulationIndicator.valueOf(childValue));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set simulation indicator", (Throwable)iae);
                    trackEvent.setSimulationIndicator(null);
                }
                continue;
            }
            if (!"items".equals(childName)) continue;
            Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
            Attribute xsitype = child.getAttribute("type", xsi);
            if (xsitype != null) {
                if ("TrackPoint".equals(xsitype.getValue())) {
                    trackEvent.addPoint(this.readTrackPoint(child, xmlns));
                    continue;
                }
                if ("TrackIdentityInformation".equals(xsitype.getValue())) {
                    trackEvent.addIdentity(this.readTrackIdentity(child, xmlns));
                    continue;
                }
                if ("TrackClassificationInformation".equals(xsitype.getValue())) {
                    trackEvent.addClassification(this.readTrackClassification(child, xmlns));
                    continue;
                }
                if ("TrackManagementInformation".equals(xsitype.getValue())) {
                    trackEvent.addManagement(this.readTrackManagement(child, xmlns));
                    continue;
                }
                if ("VideoInformation".equals(xsitype.getValue())) {
                    trackEvent.addMotionImagery(this.readMotionImagery(child, xmlns));
                    continue;
                }
                if ("ESMInformation".equals(xsitype.getValue())) continue;
                if ("TrackLineageInformation".equals(xsitype.getValue())) {
                    trackEvent.addTrackRelation(this.readLineageRelation(child, xmlns));
                    continue;
                }
                if (!"MotionEventInformation".equals(xsitype.getValue())) continue;
                trackEvent.addMotionPoint(this.readMotionPoint(child, xmlns));
                continue;
            }
            TrackPoint point = this.readTrackPoint(child, xmlns);
            if (point == null) continue;
            trackEvent.addPoint(point);
        }
        Track track = this.trackMap.get(trackEvent.getTrackNumber());
        if (track == null) {
            track = new Track();
            track.setUuid(trackEvent.getUuid());
            this.trackMap.put(trackEvent.getTrackNumber(), track);
            ++this.trackStatsNumTracks;
        }
        return trackEvent;
    }

    private TrackPoint readTrackPoint(Element element, Namespace xmlns) {
        TrackPoint trackPoint = new TrackPoint();
        ++this.trackStatsNumDots;
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("trackItemUUID".equals(childName)) {
                trackPoint.uuid = childValue;
                continue;
            }
            if ("trackItemSecurity".equals(childName)) {
                trackPoint.security = this.readSecurity(child, xmlns);
                continue;
            }
            if ("trackItemTime".equals(childName)) {
                trackPoint.eventTime = this.DateStringToLong(childValue);
                continue;
            }
            if ("trackItemSource".equals(childName)) {
                trackPoint.trackItemSource = childValue;
                continue;
            }
            if ("trackItemComment".equals(childName)) {
                trackPoint.trackItemComment = childValue;
                continue;
            }
            if ("trackPointPosition".equals(childName)) {
                trackPoint.location = this.readGeodeticPosition(child, xmlns);
                continue;
            }
            if ("trackPointSpeed".equals(childName)) {
                try {
                    trackPoint.speed = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("Unable to set speed", (Throwable)nfe);
                    trackPoint.speed = null;
                }
                continue;
            }
            if ("motionEvent".equals(childName) && childValue != null) {
                trackPoint.motionEvent = childValue.trim();
                continue;
            }
            if ("motionEventPosition".equals(childName)) {
                trackPoint.location = this.readGeodeticPosition(child, xmlns);
                continue;
            }
            if ("trackPointCourse".equals(childName)) {
                try {
                    trackPoint.course = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("Unable to set course", (Throwable)nfe);
                    trackPoint.course = null;
                }
                continue;
            }
            if ("trackPointType".equals(childName)) {
                try {
                    trackPoint.trackPointType = TrackPointType.valueOf(childValue);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set track point type", (Throwable)iae);
                    trackPoint.trackPointType = null;
                }
                continue;
            }
            if ("trackPointSource".equals(childName)) {
                trackPoint.trackPointSource = ModalityType.fromString(childValue);
                continue;
            }
            if ("trackPointObjectMask".equals(childName)) {
                trackPoint.objectMask = this.readArea(child, xmlns);
                continue;
            }
            if (!"TrackPointDetail".equals(childName)) continue;
            trackPoint.detail = this.readTrackPointDetail(child, xmlns);
        }
        return trackPoint;
    }

    private MotionEventPoint readMotionPoint(Element element, Namespace xmlns) {
        MotionEventPoint trackPoint = new MotionEventPoint();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("trackItemUUID".equals(childName)) {
                trackPoint.uuid = childValue;
                continue;
            }
            if ("trackItemSecurity".equals(childName)) {
                trackPoint.security = this.readSecurity(child, xmlns);
                continue;
            }
            if ("trackItemTime".equals(childName)) {
                trackPoint.eventTime = this.DateStringToLong(childValue);
                continue;
            }
            if ("trackItemSource".equals(childName)) {
                trackPoint.trackItemSource = childValue;
                continue;
            }
            if ("trackItemComment".equals(childName)) {
                trackPoint.trackItemComment = childValue;
                continue;
            }
            if ("trackPointPosition".equals(childName)) {
                trackPoint.location = this.readGeodeticPosition(child, xmlns);
                continue;
            }
            if ("trackPointSpeed".equals(childName)) {
                try {
                    trackPoint.speed = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("Unable to set speed", (Throwable)nfe);
                    trackPoint.speed = null;
                }
                continue;
            }
            if ("motionEvent".equals(childName) && childValue != null) {
                trackPoint.motionEvent = childValue.trim();
                continue;
            }
            if ("motionEventEndTime".equals(childName) && childValue != null) {
                trackPoint.eventEndTime = this.DateStringToLong(childValue);
                continue;
            }
            if ("motionEventPosition".equals(childName)) {
                trackPoint.location = this.readGeodeticPosition(child, xmlns);
                continue;
            }
            if ("trackPointCourse".equals(childName)) {
                try {
                    trackPoint.course = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("Unable to set course", (Throwable)nfe);
                    trackPoint.course = null;
                }
                continue;
            }
            if ("trackPointType".equals(childName)) {
                try {
                    trackPoint.trackPointType = TrackPointType.valueOf(childValue);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set track point type", (Throwable)iae);
                    trackPoint.trackPointType = null;
                }
                continue;
            }
            if ("trackPointSource".equals(childName)) {
                try {
                    trackPoint.trackPointSource = ModalityType.valueOf(childValue);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set track point source", (Throwable)iae);
                    trackPoint.trackPointSource = null;
                }
                continue;
            }
            if ("trackPointObjectMask".equals(childName)) {
                trackPoint.objectMask = this.readArea(child, xmlns);
                continue;
            }
            if (!"TrackPointDetail".equals(childName)) continue;
            trackPoint.detail = this.readTrackPointDetail(child, xmlns);
        }
        return trackPoint;
    }

    private TrackIdentity readTrackIdentity(Element element, Namespace xmlns) {
        TrackIdentity trackIdentity = new TrackIdentity();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if (!"identity".equals(childName)) continue;
            try {
                trackIdentity.identity = Identity.valueOf(childValue);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn("Unable to set identity", (Throwable)iae);
                trackIdentity.identity = null;
            }
        }
        return trackIdentity;
    }

    private TrackClassification readTrackClassification(Element element, Namespace xmlns) {
        TrackClassification trackClassification = new TrackClassification();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("trackItemUUID".equals(childName)) {
                try {
                    trackClassification.setUuid(UUID.fromString(childValue));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set uuid", (Throwable)iae);
                    trackClassification.setUuid(null);
                }
                continue;
            }
            if ("trackItemSecurity".equals(childName)) {
                trackClassification.setSecurity(this.readSecurity(child, xmlns));
                continue;
            }
            if ("trackItemTime".equals(childName)) {
                trackClassification.setTime(this.DateStringToLong(childValue));
                continue;
            }
            if ("trackItemSource".equals(childName)) {
                trackClassification.setSource(childValue);
                continue;
            }
            if ("classification".equals(childName)) {
                trackClassification.classification = ObjectClassification.fromString(childValue);
                continue;
            }
            if ("classificationCredibility".equals(childName)) {
                trackClassification.credibility = this.readClassificationCredibility(child, xmlns);
                continue;
            }
            if (!"numObjects".equals(childName)) continue;
            trackClassification.setNumObjects(Integer.parseInt(child.getText()));
        }
        return trackClassification;
    }

    private TrackManagement readTrackManagement(Element element, Namespace xmlns) {
        TrackManagement trackManagement = new TrackManagement();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("trackItemUUID".equals(childName)) {
                try {
                    trackManagement.setUuid(UUID.fromString(childValue));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set uuid", (Throwable)iae);
                    trackManagement.setUuid(null);
                }
                continue;
            }
            if ("trackItemSecurity".equals(childName)) {
                trackManagement.setSecurity(this.readSecurity(child, xmlns));
                continue;
            }
            if ("trackItemTime".equals(childName)) {
                trackManagement.setTime(this.DateStringToLong(childValue));
                continue;
            }
            if ("trackItemSource".equals(childName)) {
                trackManagement.setSource(childValue);
                continue;
            }
            if ("trackItemComment".equals(childName)) {
                trackManagement.setComment(childValue);
                continue;
            }
            if ("trackProductionArea".equals(childName)) {
                trackManagement.area = this.readArea(child, xmlns);
                continue;
            }
            if ("trackSource".equals(childName)) {
                try {
                    trackManagement.sourceModality = ModalityType.valueOf(childValue);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set source modality", (Throwable)iae);
                    trackManagement.sourceModality = null;
                }
                continue;
            }
            if ("trackEnvironment".equals(childName)) {
                try {
                    trackManagement.environment = TrackEnvironment.valueOf(childValue);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set environment", (Throwable)iae);
                    trackManagement.environment = null;
                }
                continue;
            }
            if ("trackQuality".equals(childName)) {
                try {
                    trackManagement.quality = Integer.parseInt(childValue);
                }
                catch (NumberFormatException nfe) {
                    trackManagement.quality = 0;
                }
                continue;
            }
            if ("trackerID".equals(childName)) {
                IDdata id = this.readIDdata(child, xmlns);
                trackManagement.stationId = id.getStationId();
                trackManagement.nationality = id.getNationality();
                continue;
            }
            if ("trackerType".equals(childName)) {
                try {
                    trackManagement.trackerType = TrackerType.valueOf(childValue);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set tracker type", (Throwable)iae);
                    trackManagement.trackerType = null;
                }
                continue;
            }
            if (!"alertIndicator".equals(childName)) continue;
            try {
                trackManagement.alertIndicator = Boolean.parseBoolean(childValue);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn("Unable to set alert indicator", (Throwable)iae);
                trackManagement.alertIndicator = false;
            }
        }
        return trackManagement;
    }

    private MotionImagery readMotionImagery(Element element, Namespace xmlns) {
        MotionImagery motionImagery = new MotionImagery();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("trackItemUUID".equals(childName)) {
                try {
                    motionImagery.setUuid(UUID.fromString(childValue));
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set uuid", (Throwable)iae);
                    motionImagery.setUuid(null);
                }
                continue;
            }
            if ("trackItemSecurity".equals(childName)) {
                motionImagery.setSecurity(this.readSecurity(child, xmlns));
                continue;
            }
            if ("trackItemTime".equals(childName)) {
                motionImagery.setTime(this.DateStringToLong(childValue));
                continue;
            }
            if ("trackItemSource".equals(childName)) {
                motionImagery.setSource(childValue);
                continue;
            }
            if ("trackItemComment".equals(childName)) {
                motionImagery.setComment(childValue);
                continue;
            }
            if ("band".equals(childName)) {
                try {
                    motionImagery.band = SymbolicSpectralRange.valueOf(childValue);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.warn("Unable to set band value", (Throwable)iae);
                    motionImagery.band = null;
                }
                continue;
            }
            if ("imageReference".equals(childName)) {
                motionImagery.imageReference = childValue;
                continue;
            }
            if ("imageChip".equals(childName)) {
                motionImagery.imageChip = child.getText();
                continue;
            }
            if ("frameNumber".equals(childName)) {
                motionImagery.frameNumber = Integer.parseInt(child.getText());
                continue;
            }
            if ("pixelRow".equals(childName)) {
                motionImagery.pixelRow = Integer.parseInt(child.getText());
                continue;
            }
            if (!"pixelColumn".equals(childName)) continue;
            motionImagery.pixelColumn = Integer.parseInt(child.getText());
        }
        return motionImagery;
    }

    private LineageRelation readLineageRelation(Element element, Namespace xmlns) {
        LineageRelation relation = new LineageRelation();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if (!"relations".equals(childName)) continue;
        }
        return relation;
    }

    private ClassificationCredibility readClassificationCredibility(Element element, Namespace xmlns) {
        ClassificationCredibility credibility = new ClassificationCredibility();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("valueConfidence".equals(childName)) {
                try {
                    credibility.setValueConfidence(Integer.parseInt(childValue));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!"sourceReliability".equals(childName)) continue;
            try {
                credibility.setSourceReliability(Integer.parseInt(childValue));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return credibility;
    }

    private GeodeticPosition readGeodeticPosition(Element element, Namespace xmlns) {
        GeodeticPosition pos = new GeodeticPosition();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("latitude".equals(childName)) {
                try {
                    pos.latitude = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    pos.latitude = null;
                }
                continue;
            }
            if ("longitude".equals(childName)) {
                try {
                    pos.longitude = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    pos.longitude = null;
                }
                continue;
            }
            if (!"elevation".equals(childName)) continue;
            try {
                pos.elevation = Double.parseDouble(childValue);
            }
            catch (NumberFormatException nfe) {
                pos.elevation = null;
            }
        }
        return pos;
    }

    private Area readArea(Element element, Namespace xmlns) {
        Area area = new Area();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if (!"xxx".equals(childName)) continue;
        }
        return area;
    }

    private Area readCoverageArea(Element element, Namespace xmlns) {
        Area area = new Area();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if (!"areaBoundaryPoints".equals(childName)) continue;
            GeodeticPosition pos = this.readGeodeticPosition(child, xmlns);
            area.getPoints().add(pos);
        }
        return area;
    }

    private TrackPointDetail readTrackPointDetail(Element element, Namespace xmlns) {
        Namespace xsi = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        TrackPointDetail detail = new TrackPointDetail();
        List children = element.getChildren();
        for (Element child : children) {
            Attribute xsitype;
            String childName = child.getName();
            String childValue = child.getValue();
            if ("pointDetailPosition".equals(childName)) {
                xsitype = child.getAttribute("type", xsi);
                if (xsitype != null) {
                    if ("GeodeticPosition".equals(xsitype.getValue())) {
                        detail.location = this.readGeodeticPosition(child, xmlns);
                        continue;
                    }
                    if (!"LocalCartesianPosition".equals(xsitype.getValue())) continue;
                    continue;
                }
                try {
                    GeodeticPosition geoPos = this.readGeodeticPosition(child, xmlns);
                    if (geoPos == null) continue;
                    detail.location = geoPos;
                }
                catch (Exception e) {
                    LOGGER.error("Could not identify TrackPoint position type", (Throwable)e);
                }
                continue;
            }
            if ("pointDetailVelocity".equals(childName)) {
                Double[] velCoords;
                xsitype = child.getAttribute("type", xsi);
                if (xsitype != null) {
                    if (!"LocalCartesianVelocity".equals(xsitype.getValue())) continue;
                    velCoords = this.readLocalCartesianVelocity(child);
                    detail.velocityX = velCoords[0];
                    detail.velocityY = velCoords[1];
                    detail.velocityZ = velCoords[2];
                    continue;
                }
                try {
                    velCoords = this.readLocalCartesianVelocity(child);
                    detail.velocityX = velCoords[0];
                    detail.velocityY = velCoords[1];
                    detail.velocityZ = velCoords[2];
                }
                catch (Exception e) {
                    LOGGER.error("Could not identify TrackPoint velocity", (Throwable)e);
                }
                continue;
            }
            if ("pointDetailAcceleration".equals(childName)) {
                Double[] accelCoords;
                xsitype = child.getAttribute("type", xsi);
                if (xsitype != null) {
                    if (!"LocalCartesianAcceleration".equals(xsitype.getValue())) continue;
                    accelCoords = this.readLocalCartesianAccel(child);
                    detail.accelerationX = accelCoords[0];
                    detail.accelerationY = accelCoords[1];
                    detail.accelerationZ = accelCoords[2];
                    continue;
                }
                try {
                    accelCoords = this.readLocalCartesianAccel(child);
                    detail.accelerationX = accelCoords[0];
                    detail.accelerationY = accelCoords[1];
                    detail.accelerationZ = accelCoords[2];
                }
                catch (Exception e) {
                    LOGGER.error("Could not identify TrackPoint velocity", (Throwable)e);
                }
                continue;
            }
            if (!"pointDetailCovarianceMatrix".equals(childName)) continue;
            detail.covarianceMatrix = this.readCovarianceMatrix(child, xmlns);
        }
        return detail;
    }

    private Double[] readLocalCartesianVelocity(Element child) {
        Double[] velCoords = new Double[3];
        List grandchildren = child.getChildren();
        for (Element grandchild : grandchildren) {
            String grandchildName = grandchild.getName();
            String grandchildValue = grandchild.getValue();
            if ("velx".equals(grandchildName)) {
                try {
                    velCoords[0] = Double.parseDouble(grandchildValue);
                }
                catch (NumberFormatException nfe) {
                    velCoords[0] = null;
                }
                continue;
            }
            if ("vely".equals(grandchildName)) {
                try {
                    velCoords[1] = Double.parseDouble(grandchildValue);
                }
                catch (NumberFormatException nfe) {
                    velCoords[1] = null;
                }
                continue;
            }
            if (!"velz".equals(grandchildName)) continue;
            try {
                velCoords[2] = Double.parseDouble(grandchildValue);
            }
            catch (NumberFormatException nfe) {
                velCoords[2] = null;
            }
        }
        return velCoords;
    }

    private Double[] readLocalCartesianAccel(Element child) {
        Double[] accelCoords = new Double[3];
        List grandchildren = child.getChildren();
        for (Element grandchild : grandchildren) {
            String grandchildName = grandchild.getName();
            String grandchildValue = grandchild.getValue();
            if ("accx".equals(grandchildName)) {
                try {
                    accelCoords[0] = Double.parseDouble(grandchildValue);
                }
                catch (NumberFormatException nfe) {
                    accelCoords[0] = null;
                }
                continue;
            }
            if ("accy".equals(grandchildName)) {
                try {
                    accelCoords[1] = Double.parseDouble(grandchildValue);
                }
                catch (NumberFormatException nfe) {
                    accelCoords[1] = null;
                }
                continue;
            }
            if (!"accz".equals(grandchildName)) continue;
            try {
                accelCoords[2] = Double.parseDouble(grandchildValue);
            }
            catch (NumberFormatException nfe) {
                accelCoords[2] = null;
            }
        }
        return accelCoords;
    }

    private CovarianceMatrix readCovarianceMatrix(Element element, Namespace xmlns) {
        CovarianceMatrix matrix = new CovarianceMatrix();
        List children = element.getChildren();
        for (Element child : children) {
            String childName = child.getName();
            String childValue = child.getValue();
            if ("covPosxPosx".equals(childName)) {
                try {
                    matrix.covPosXPosX = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosXPosX = null;
                }
                continue;
            }
            if ("covPosyPosy".equals(childName)) {
                try {
                    matrix.covPosYPosY = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosYPosY = null;
                }
                continue;
            }
            if ("covPoszPosz".equals(childName)) {
                try {
                    matrix.covPosZPosZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosZPosZ = null;
                }
                continue;
            }
            if ("covPosxPosy".equals(childName)) {
                try {
                    matrix.covPosXPosY = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosXPosY = null;
                }
                continue;
            }
            if ("covPosxPosz".equals(childName)) {
                try {
                    matrix.covPosXPosZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosXPosZ = null;
                }
                continue;
            }
            if ("covPosyPosz".equals(childName)) {
                try {
                    matrix.covPosYPosZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosYPosZ = null;
                }
                continue;
            }
            if ("covVelxVelx".equals(childName)) {
                try {
                    matrix.covVelXVelX = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covVelXVelX = null;
                }
                continue;
            }
            if ("covVelyVely".equals(childName)) {
                try {
                    matrix.covVelYVelY = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covVelYVelY = null;
                }
                continue;
            }
            if ("covVelzVelz".equals(childName)) {
                try {
                    matrix.covVelZVelZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covVelZVelZ = null;
                }
                continue;
            }
            if ("covPosxVelx".equals(childName)) {
                try {
                    matrix.covPosXVelX = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosXVelX = null;
                }
                continue;
            }
            if ("covPosxVely".equals(childName)) {
                try {
                    matrix.covPosXVelY = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosXVelY = null;
                }
                continue;
            }
            if ("covPosxVelz".equals(childName)) {
                try {
                    matrix.covPosXVelZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosXVelZ = null;
                }
                continue;
            }
            if ("covPosyVelx".equals(childName)) {
                try {
                    matrix.covPosYVelX = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosYVelX = null;
                }
                continue;
            }
            if ("covPosyVely".equals(childName)) {
                try {
                    matrix.covPosYVelY = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosYVelY = null;
                }
                continue;
            }
            if ("covPosyVelz".equals(childName)) {
                try {
                    matrix.covPosYVelZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosYVelZ = null;
                }
                continue;
            }
            if ("covPoszVelx".equals(childName)) {
                try {
                    matrix.covPosZVelX = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosZVelX = null;
                }
                continue;
            }
            if ("covPoszVely".equals(childName)) {
                try {
                    matrix.covPosZVelY = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosZVelY = null;
                }
                continue;
            }
            if ("covPoszVelz".equals(childName)) {
                try {
                    matrix.covPosZVelZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covPosZVelZ = null;
                }
                continue;
            }
            if ("covVelxVely".equals(childName)) {
                try {
                    matrix.covVelXVelY = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covVelXVelY = null;
                }
                continue;
            }
            if ("covVelxVelz".equals(childName)) {
                try {
                    matrix.covVelXVelZ = Double.parseDouble(childValue);
                }
                catch (NumberFormatException nfe) {
                    matrix.covVelXVelZ = null;
                }
                continue;
            }
            if (!"covVelyVelz".equals(childName)) continue;
            try {
                matrix.covVelYVelZ = Double.parseDouble(childValue);
            }
            catch (NumberFormatException nfe) {
                matrix.covVelYVelZ = null;
            }
        }
        return matrix;
    }

    private long DateStringToLong(String dateString) {
        Date date = this.parseHelper(dateString = dateString.replaceAll("(\\.\\d{3})\\d+[Z]", "$1Z"), "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        if (date == null && (date = this.parseHelper(dateString, "yyyy-MM-dd'T'HH:mm:ss.SSS")) == null && (date = this.parseHelper(dateString, "yyyy-MM-dd'T'HH:mm:ss'Z'")) == null && (date = this.parseHelper(dateString, "yyyy-MM-dd'T'HH:mm:ss")) == null) {
            return 0L;
        }
        return date.getTime();
    }

    private Date parseHelper(String dateString, String format) {
        SimpleDateFormat parser = new SimpleDateFormat(format);
        parser.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return parser.parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

