/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.parser;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import org.locationtech.geowave.format.stanag4676.parser.TrackEncoder;
import org.locationtech.geowave.format.stanag4676.parser.model.Area;
import org.locationtech.geowave.format.stanag4676.parser.model.ClassificationCredibility;
import org.locationtech.geowave.format.stanag4676.parser.model.ClassificationLevel;
import org.locationtech.geowave.format.stanag4676.parser.model.CovarianceMatrix;
import org.locationtech.geowave.format.stanag4676.parser.model.ExerciseIndicator;
import org.locationtech.geowave.format.stanag4676.parser.model.GeodeticPosition;
import org.locationtech.geowave.format.stanag4676.parser.model.IDdata;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionFrame;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionSummary;
import org.locationtech.geowave.format.stanag4676.parser.model.MissionSummaryMessage;
import org.locationtech.geowave.format.stanag4676.parser.model.ModalityType;
import org.locationtech.geowave.format.stanag4676.parser.model.MotionImagery;
import org.locationtech.geowave.format.stanag4676.parser.model.NATO4676Message;
import org.locationtech.geowave.format.stanag4676.parser.model.ObjectClassification;
import org.locationtech.geowave.format.stanag4676.parser.model.Security;
import org.locationtech.geowave.format.stanag4676.parser.model.SimulationIndicator;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackClassification;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackEvent;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackIdentity;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackManagement;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackMessage;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackPoint;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackPointDetail;
import org.locationtech.geowave.format.stanag4676.parser.model.TrackRun;

public class NATO4676Encoder
implements TrackEncoder {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final ExerciseIndicator defaultExerciseIndicator;
    private final Security defaultSecurity = new Security();
    private SimulationIndicator defaultSimulationIndicator;
    private int indentLevel = 0;
    private final String stanagVersion;
    private PrintWriter pw = null;
    private OutputStream trackOut = null;
    private OutputStream missionOut = null;
    private PrintWriter pwTrack = null;
    private PrintWriter pwMission = null;

    private String indent() {
        if (this.indentLevel == 0) {
            return "";
        }
        char[] indention = new char[this.indentLevel];
        Arrays.fill(indention, '\t');
        return new String(indention);
    }

    public void setDefaultSecurityLevel(String level) {
        this.defaultSecurity.setClassification(ClassificationLevel.valueOf(level));
    }

    public void setDefaultSimulationString(String simString) {
        this.defaultSimulationIndicator = SimulationIndicator.valueOf(simString);
    }

    public NATO4676Encoder() {
        this.defaultSecurity.setClassification(ClassificationLevel.UNCLASSIFIED);
        this.defaultSecurity.setPolicyName("NATO");
        this.defaultExerciseIndicator = ExerciseIndicator.OPERATIONAL;
        this.stanagVersion = "1.0";
    }

    @Override
    public void setOutputStreams(OutputStream trackOut, OutputStream missionOut) {
        this.trackOut = trackOut;
        this.missionOut = missionOut;
        OutputStreamWriter trackOsw = new OutputStreamWriter(this.trackOut, UTF_8);
        OutputStreamWriter missionOsw = new OutputStreamWriter(this.missionOut, UTF_8);
        this.pw = this.pwTrack = new PrintWriter(new BufferedWriter(trackOsw, 8192));
        this.pwMission = new PrintWriter(new BufferedWriter(missionOsw, 8192));
    }

    private String GetXMLOpen() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
    }

    private String GetXMLClose() {
        return "";
    }

    @Override
    public void Encode(TrackRun run) {
        boolean firstTrackMessage = true;
        boolean trackMessagesExist = false;
        for (NATO4676Message msg : run.getMessages()) {
            this.indentLevel = 0;
            if (msg instanceof TrackMessage) {
                TrackMessage trackMsg = (TrackMessage)msg;
                if (firstTrackMessage) {
                    this.pw.write(this.GetXMLOpen());
                    this.pw.write("<TrackMessage xmlns=\"urn:int:nato:stanag4676:0.14\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" schemaVersion=\"0.14\">\n");
                    ++this.indentLevel;
                    this.EncodeMsgMetadata(msg);
                    --this.indentLevel;
                    firstTrackMessage = false;
                    trackMessagesExist = true;
                }
                this.Encode(trackMsg);
                continue;
            }
            if (!(msg instanceof MissionSummaryMessage)) continue;
            this.pw = this.pwMission;
            MissionSummaryMessage msMsg = (MissionSummaryMessage)msg;
            MissionSummary ms = msMsg.getMissionSummary();
            if (ms == null) continue;
            this.pw.write(this.GetXMLOpen());
            this.pw.write("<MissionSummary xmlns=\"http://siginnovations.com/MissionSummarySIG\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
            ++this.indentLevel;
            this.EncodeMsgMetadata(msg);
            this.pw.write(this.indent() + "<Name>" + ms.getName() + "</Name>\n");
            this.pw.write(this.indent() + "<missionID>" + ms.getMissionId() + "</missionID>\n");
            this.pw.write(this.indent() + "<StartTime>" + this.EncodeTime(ms.getStartTime()) + "</StartTime>\n");
            this.pw.write(this.indent() + "<EndTime>" + this.EncodeTime(ms.getEndTime()) + "</EndTime>\n");
            Area area = ms.getCoverageArea();
            if (area != null) {
                this.pw.write(this.indent() + "<CoverageArea xsi:type=\"PolygonArea\">\n");
                this.Encode(area);
                this.pw.write(this.indent() + "</CoverageArea>\n");
            }
            if (ms.getClassifications().size() > 0) {
                this.pw.write(this.indent() + "<ActiveObjectClassifications>\n");
                ++this.indentLevel;
                for (ObjectClassification oc : ms.getClassifications()) {
                    this.pw.write(this.indent() + "<classification>" + oc.name() + "</classification>\n");
                }
                --this.indentLevel;
                this.pw.write(this.indent() + "</ActiveObjectClassifications>\n");
            }
            --this.indentLevel;
            this.Encode(msMsg);
            this.pw.write("</MissionSummary>\n");
            this.pw.flush();
            this.pw = this.pwTrack;
        }
        if (trackMessagesExist) {
            this.pw.write("</TrackMessage>\n");
            this.pw.flush();
        }
    }

    private void Encode(TrackMessage msg) {
        ++this.indentLevel;
        for (TrackEvent trackevent : msg.getTracks()) {
            this.pw.write(this.indent() + "<tracks>\n");
            this.Encode(trackevent);
            this.pw.write(this.indent() + "</tracks>\n");
        }
        --this.indentLevel;
    }

    private void Encode(MissionSummaryMessage msg) {
        ++this.indentLevel;
        for (MissionFrame frame : msg.getMissionSummary().getFrames()) {
            this.pw.write(this.indent() + "<FrameInformation>\n");
            this.Encode(frame);
            this.pw.write(this.indent() + "</FrameInformation>\n");
        }
        --this.indentLevel;
    }

    private void EncodeMsgMetadata(NATO4676Message msg) {
        this.pw.write(this.indent() + "<stanagVersion>" + this.stanagVersion + "</stanagVersion>\n");
        this.pw.write(this.indent() + "<messageSecurity>\n");
        this.Encode(msg.getSecurity());
        this.pw.write(this.indent() + "</messageSecurity>\n");
        this.pw.write(this.indent() + "<msgCreatedTime>" + this.EncodeTime(msg.getMessageTime()) + "</msgCreatedTime>\n");
        this.pw.write(this.indent() + "<senderId>\n");
        this.Encode(msg.getSenderID());
        this.pw.write(this.indent() + "</senderId>\n");
    }

    private void Encode(Security sec) {
        if (sec == null) {
            sec = this.defaultSecurity;
        }
        ++this.indentLevel;
        this.pw.write(this.indent() + "<securityClassification>" + (Object)((Object)sec.getClassification()) + "</securityClassification>\n");
        this.pw.write(this.indent() + "<securityPolicyName>" + sec.getPolicyName() + "</securityPolicyName>\n");
        if (sec.getControlSystem() != null) {
            this.pw.write(this.indent() + "<securityControlSystem>" + sec.getControlSystem() + "</securityControlSystem>\n");
        }
        if (sec.getDissemination() != null) {
            this.pw.write(this.indent() + "<securityDissemination>" + sec.getDissemination() + "</securityDissemination>\n");
        }
        if (sec.getReleasability() != null) {
            this.pw.write(this.indent() + "<securityReleasability>" + sec.getReleasability() + "</securityReleasability>\n");
        }
        --this.indentLevel;
    }

    private void Encode(IDdata id) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<stationID>" + id.getStationId() + "</stationID>\n");
        this.pw.write(this.indent() + "<nationality>" + id.getNationality() + "</nationality>\n");
        --this.indentLevel;
    }

    private void Encode(TrackEvent event) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<trackUUID>" + event.getUuid() + "</trackUUID>\n");
        this.pw.write(this.indent() + "<trackNumber>" + event.getTrackNumber() + "</trackNumber>\n");
        if (event.getStatus() != null) {
            this.pw.write(this.indent() + "<trackStatus>" + (Object)((Object)event.getStatus()) + "</trackStatus>\n");
        }
        this.pw.write(this.indent() + "<trackSecurity>\n");
        this.Encode(event.getSecurity());
        this.pw.write(this.indent() + "</trackSecurity>\n");
        if (event.getComment() != null) {
            this.pw.write(this.indent() + "<trackComment>" + event.getComment() + "</trackComment>\n");
        }
        if (event.getMissionId() != null) {
            this.pw.write(this.indent() + "<missionID>" + event.getMissionId() + "</missionID>\n");
        }
        if (event.getExerciseIndicator() != null) {
            this.pw.write(this.indent() + "<exerciseIndicator>" + (Object)((Object)event.getExerciseIndicator()) + "</exerciseIndicator>\n");
        } else {
            this.pw.write(this.indent() + "<exerciseIndicator>" + (Object)((Object)this.defaultExerciseIndicator) + "</exerciseIndicator>\n");
        }
        if (event.getSimulationIndicator() != null) {
            this.pw.write(this.indent() + "<simulationIndicator>" + (Object)((Object)event.getSimulationIndicator()) + "</simulationIndicator>\n");
        } else {
            this.pw.write(this.indent() + "<simulationIndicator>" + (Object)((Object)this.defaultSimulationIndicator) + "</simulationIndicator>\n");
        }
        for (TrackPoint point : event.getPoints().values()) {
            this.pw.write(this.indent() + "<items xsi:type=\"TrackPoint\">\n");
            this.Encode(point);
            this.pw.write(this.indent() + "</items>\n");
        }
        for (TrackIdentity identity : event.getIdentities()) {
            this.pw.write(this.indent() + "<items xsi:type=\"TrackIdentityInformation\">\n");
            this.Encode(identity);
            this.pw.write(this.indent() + "</items>\n");
        }
        for (TrackClassification tc : event.getClassifications()) {
            this.pw.write(this.indent() + "<items xsi:type=\"TrackClassificationInformation\">\n");
            this.Encode(tc);
            this.pw.write(this.indent() + "</items>\n");
        }
        for (TrackManagement management : event.getManagements()) {
            this.pw.write(this.indent() + "<items xsi:type=\"TrackManagementInformation\">\n");
            this.Encode(management);
            this.pw.write(this.indent() + "</items>\n");
        }
        for (MotionImagery image : event.getMotionImages()) {
            this.pw.write(this.indent() + "<items xsi:type=\"MotionImageryInformation\">\n");
            this.Encode(image);
            this.pw.write(this.indent() + "</items>\n");
        }
        --this.indentLevel;
    }

    private void Encode(TrackPoint point) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<trackItemUUID>" + point.getUuid() + "</trackItemUUID>\n");
        this.pw.write(this.indent() + "<trackItemSecurity>\n");
        this.Encode(point.getSecurity());
        this.pw.write(this.indent() + "</trackItemSecurity>\n");
        this.pw.write(this.indent() + "<trackItemTime>\n");
        this.pw.write(this.EncodeTime(point.getEventTime()));
        this.pw.write(this.indent() + "</trackItemTime>\n");
        if (point.getTrackItemSource() != null) {
            this.pw.write(this.indent() + "<trackItemSource>" + point.getTrackItemSource() + "</trackItemSource>\n");
        }
        if (point.getTrackItemComment() != null) {
            this.pw.write(this.indent() + "<trackItemComment>" + point.getTrackItemComment() + "</trackItemComment>\n");
        }
        this.pw.write(this.indent() + "<trackPointPosition>\n");
        this.Encode(point.getLocation());
        this.pw.write(this.indent() + "</trackPointPosition>\n");
        if (point.getSpeed() != null) {
            this.pw.write(this.indent() + "<trackPointSpeed>" + point.getSpeed().intValue() + "</trackPointSpeed>\n");
        }
        if (point.getCourse() != null) {
            this.pw.write(this.indent() + "<trackPointCourse>" + point.getCourse() + "</trackPointCourse>\n");
        }
        if (point.getTrackPointType() != null) {
            this.pw.write(this.indent() + "<trackPointType>" + (Object)((Object)point.getTrackPointType()) + "</trackPointType>\n");
        }
        if (point.getTrackPointSource() != null) {
            this.pw.write(this.indent() + "<trackPointSource>" + (Object)((Object)point.getTrackPointSource()) + "</trackPointSource>\n");
        }
        if (point.getDetail() != null) {
            this.pw.write(this.indent() + "<TrackPointDetail>\n");
            this.Encode(point.getDetail());
            this.pw.write(this.indent() + "</TrackPointDetail>\n");
        }
        --this.indentLevel;
    }

    private void Encode(MissionFrame frame) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<frameNumber>" + frame.getFrameNumber() + "</frameNumber>\n");
        this.pw.write(this.indent() + "<frameTimestamp>" + this.EncodeTime(frame.getFrameTime()) + "</frameTimestamp>\n");
        Area area = frame.getCoverageArea();
        if (area != null) {
            this.pw.write(this.indent() + "<frameCoverageArea xsi:type=\"PolygonArea\">\n");
            this.Encode(frame.getCoverageArea());
            this.pw.write(this.indent() + "</frameCoverageArea>\n");
        }
        this.pw.write(this.indent() + "<hasFault>false</hasFault>\n");
        --this.indentLevel;
    }

    private void Encode(TrackIdentity identity) {
    }

    private void Encode(TrackClassification tc) {
        ClassificationCredibility cred;
        ++this.indentLevel;
        this.pw.write(this.indent() + "<trackItemUUID>" + tc.getUuid() + "</trackItemUUID>\n");
        this.pw.write(this.indent() + "<trackItemSecurity>\n");
        this.Encode(tc.getSecurity());
        this.pw.write(this.indent() + "</trackItemSecurity>\n");
        this.pw.write(this.indent() + "<trackItemTime>" + this.EncodeTime(tc.getTime()) + "</trackItemTime>\n");
        this.pw.write(this.indent() + "<numberofObjects>" + tc.getNumObjects() + "</numberofObjects>\n");
        ObjectClassification oc = tc.getClassification();
        if (oc != null) {
            this.pw.write(this.indent() + "<classification>" + oc.name() + "</classification>\n");
            ModalityType mt = ModalityType.fromString(tc.getSource());
            if (mt != null) {
                this.pw.write(this.indent() + "<classificationSource>" + mt.toString() + "</classificationSource>\n");
            }
        }
        if ((cred = tc.getCredibility()) != null) {
            this.pw.write(this.indent() + "<classificationCredibility>\n");
            ++this.indentLevel;
            this.pw.write(this.indent() + "<valueConfidence>" + cred.getValueConfidence() + "</valueConfidence>\n");
            this.pw.write(this.indent() + "<sourceReliability>" + cred.getSourceReliability() + "</sourceReliability>\n");
            --this.indentLevel;
            this.pw.write(this.indent() + "</classificationCredibility>\n");
        }
        --this.indentLevel;
    }

    private void Encode(TrackManagement management) {
    }

    private void Encode(MotionImagery image) {
        this.pw.write("\n");
        ++this.indentLevel;
        if (image.getBand() != null) {
            this.pw.write(this.indent() + "<band>" + image.getBand().toString() + "</band>\n");
        }
        if (image.getImageReference() != null) {
            this.pw.write(this.indent() + "<imageReference>" + image.getImageReference() + "</imageReference>\n");
        }
        if (image.getImageChip() != null) {
            this.pw.write(this.indent() + "<imageChip>\n");
            this.EncodeImage(image.getImageChip());
            this.pw.write(this.indent() + "</imageChip>\n");
        }
        --this.indentLevel;
    }

    private void EncodeImage(String base64imageChip) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<![CDATA[" + base64imageChip + "]]>\n");
        --this.indentLevel;
    }

    private String EncodeTime(Long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String xml = sdf.format(new Date(time));
        return xml;
    }

    private void Encode(GeodeticPosition pos) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<latitude>" + pos.latitude + "</latitude>\n");
        this.pw.write(this.indent() + "<longitude>" + pos.longitude + "</longitude>\n");
        if (pos.elevation != null) {
            this.pw.write(this.indent() + "<elevation>" + pos.elevation + "</elevation>\n");
        }
        --this.indentLevel;
    }

    private void Encode(Area coverageArea) {
        ++this.indentLevel;
        if (coverageArea != null) {
            for (GeodeticPosition pos : coverageArea.getPoints()) {
                this.pw.write(this.indent() + "<areaBoundaryPoints xsi:type=\"GeodeticPosition\">\n");
                this.Encode(pos);
                this.pw.write(this.indent() + "</areaBoundaryPoints>\n");
            }
        }
        --this.indentLevel;
    }

    private void Encode(TrackPointDetail detail) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<pointDetailPosition xsi:type=\"GeodeticPosition\">\n");
        this.Encode(detail.getLocation());
        this.pw.write(this.indent() + "</pointDetailPosition>\n");
        if (detail.getVelocityX() != null || detail.getVelocityY() != null || detail.getVelocityZ() != null) {
            this.pw.write(this.indent() + "<pointDetailVelocity xsi:type=\"LocalCartesianVelocity\">\n");
            ++this.indentLevel;
            if (detail.getVelocityX() != null) {
                this.pw.write(this.indent() + "<velx>" + detail.getVelocityX() + "</velx>\n");
            } else {
                this.pw.write(this.indent() + "<velx>0</velx>\n");
            }
            if (detail.getVelocityY() != null) {
                this.pw.write(this.indent() + "<vely>" + detail.getVelocityY() + "</vely>\n");
            } else {
                this.pw.write(this.indent() + "<vely>0</vely>\n");
            }
            if (detail.getVelocityZ() != null) {
                this.pw.write(this.indent() + "<velz>" + detail.getVelocityZ() + "</velz>\n");
            } else {
                this.pw.write(this.indent() + "<velz>0</velz>\n");
            }
            --this.indentLevel;
            this.pw.write(this.indent() + "</pointDetailVelocity>\n");
        }
        if (detail.getAccelerationX() != null || detail.getAccelerationY() != null || detail.getAccelerationZ() != null) {
            this.pw.write(this.indent() + "<pointDetailAcceleration xsi:type=\"LocalCartesianAcceleration\">\n");
            ++this.indentLevel;
            if (detail.getAccelerationX() != null) {
                this.pw.write(this.indent() + "<accx>" + detail.getAccelerationX() + "</accx>\n");
            } else {
                this.pw.write(this.indent() + "<accx>0</accx>\n");
            }
            if (detail.getAccelerationY() != null) {
                this.pw.write(this.indent() + "<accy>" + detail.getAccelerationY() + "</accy>\n");
            } else {
                this.pw.write(this.indent() + "<accy>0</accy>\n");
            }
            if (detail.getAccelerationZ() != null) {
                this.pw.write(this.indent() + "<accz>" + detail.getAccelerationZ() + "</accz>\n");
            } else {
                this.pw.write(this.indent() + "<accz>0</accz>\n");
            }
            --this.indentLevel;
            this.pw.write(this.indent() + "</pointDetailAcceleration>\n");
        }
        this.pw.write(this.indent() + "<pointDetailCovarianceMatrix xsi:type=\"CovarianceMatrixPositionVelocity\">");
        this.Encode(detail.getCovarianceMatrix());
        this.pw.write(this.indent() + "</pointDetailCovarianceMatrix>\n");
        --this.indentLevel;
    }

    private void Encode(CovarianceMatrix cov) {
        ++this.indentLevel;
        this.pw.write(this.indent() + "<covPosxPosx>" + cov.getCovPosXPosX() + "</covPosxPosx>\n");
        this.pw.write(this.indent() + "<covPosyPosy>" + cov.getCovPosYPosY() + "</covPosyPosy>\n");
        if (cov.getCovPosZPosZ() != null) {
            this.pw.write(this.indent() + "<covPoszPosz>" + cov.getCovPosZPosZ() + "</covPoszPosz>\n");
        }
        if (cov.getCovPosXPosY() != null) {
            this.pw.write(this.indent() + "<covPosxPosy>" + cov.getCovPosXPosY() + "</covPosxPosy>\n");
        }
        if (cov.getCovPosXPosZ() != null) {
            this.pw.write(this.indent() + "<covPosxPosz>" + cov.getCovPosXPosZ() + "</covPosxPosz>\n");
        }
        if (cov.getCovPosYPosZ() != null) {
            this.pw.write(this.indent() + "<covPosyPosz>" + cov.getCovPosYPosZ() + "</covPosyPosz>\n");
        }
        if (cov.getCovVelXVelX() != null) {
            this.pw.write(this.indent() + "<covVelxVelx>" + cov.getCovVelXVelX() + "</covVelxVelx>\n");
        }
        if (cov.getCovVelYVelY() != null) {
            this.pw.write(this.indent() + "<covVelyVely>" + cov.getCovVelYVelY() + "</covVelyVely>\n");
        }
        if (cov.getCovVelZVelZ() != null) {
            this.pw.write(this.indent() + "<covVelzVelz>" + cov.getCovVelZVelZ() + "</covVelzVelz>\n");
        }
        if (cov.getCovPosXVelX() != null) {
            this.pw.write(this.indent() + "<covPosxVelx>" + cov.getCovPosXVelX() + "</covPosxVelx>\n");
        }
        if (cov.getCovPosXVelY() != null) {
            this.pw.write(this.indent() + "<covPosxVely>" + cov.getCovPosXVelY() + "</covPosxVely>\n");
        }
        if (cov.getCovPosXVelZ() != null) {
            this.pw.write(this.indent() + "<covPosxVelz>" + cov.getCovPosXVelZ() + "</covPosxVelz>\n");
        }
        if (cov.getCovPosYVelX() != null) {
            this.pw.write(this.indent() + "<covPosyVelx>" + cov.getCovPosYVelX() + "</covPosyVelx>\n");
        }
        if (cov.getCovPosYVelY() != null) {
            this.pw.write(this.indent() + "<covPosyVely>" + cov.getCovPosYVelY() + "</covPosyVely>\n");
        }
        if (cov.getCovPosYVelZ() != null) {
            this.pw.write(this.indent() + "<covPosyVelz>" + cov.getCovPosYVelZ() + "</covPosyVelz>\n");
        }
        if (cov.getCovPosZVelX() != null) {
            this.pw.write(this.indent() + "<covPoszVelx>" + cov.getCovPosZVelX() + "</covPoszVelx>\n");
        }
        if (cov.getCovPosZVelY() != null) {
            this.pw.write(this.indent() + "<covPoszVely>" + cov.getCovPosZVelY() + "</covPoszVely>\n");
        }
        if (cov.getCovPosZVelZ() != null) {
            this.pw.write(this.indent() + "<covPoszVelz>" + cov.getCovPosZVelZ() + "</covPoszVelz>\n");
        }
        if (cov.getCovVelXVelY() != null) {
            this.pw.write(this.indent() + "<covVelxVely>" + cov.getCovVelXVelY() + "</covVelxVely>\n");
        }
        if (cov.getCovVelXVelZ() != null) {
            this.pw.write(this.indent() + "<covVelxVelz>" + cov.getCovVelXVelZ() + "</covVelxVelz>\n");
        }
        if (cov.getCovVelYVelZ() != null) {
            this.pw.write(this.indent() + "<covVelyVelz>" + cov.getCovVelYVelZ() + "</covVelyVelz>\n");
        }
        --this.indentLevel;
    }
}

