/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class Stanag4676EventWritable
implements Writable {
    public static final double NO_DETAIL = Double.MIN_VALUE;
    public IntWritable EventType = new IntWritable();
    public BytesWritable Geometry = new BytesWritable();
    public BytesWritable DetailGeometry = new BytesWritable();
    public BytesWritable Image = new BytesWritable();
    public Text MissionUUID = new Text();
    public Text MissionName = new Text();
    public IntWritable MissionNumFrames = new IntWritable();
    public Text TrackNumber = new Text();
    public Text TrackUUID = new Text();
    public Text TrackStatus = new Text();
    public Text TrackClassification = new Text();
    public Text TrackItemUUID = new Text();
    public Text TrackPointSource = new Text();
    public LongWritable TimeStamp = new LongWritable();
    public LongWritable EndTimeStamp = new LongWritable();
    public DoubleWritable Speed = new DoubleWritable();
    public DoubleWritable Course = new DoubleWritable();
    public Text TrackItemClassification = new Text();
    public DoubleWritable Latitude = new DoubleWritable();
    public DoubleWritable Longitude = new DoubleWritable();
    public DoubleWritable Elevation = new DoubleWritable();
    public DoubleWritable DetailLatitude = new DoubleWritable();
    public DoubleWritable DetailLongitude = new DoubleWritable();
    public DoubleWritable DetailElevation = new DoubleWritable();
    public IntWritable PixelRow = new IntWritable();
    public IntWritable PixelColumn = new IntWritable();
    public Text MotionEvent = new Text();
    public IntWritable FrameNumber = new IntWritable();
    public Text ObjectClass = new Text();
    public IntWritable ObjectClassConf = new IntWritable();
    public IntWritable ObjectClassRel = new IntWritable();

    public static Stanag4676EventWritable clone(Stanag4676EventWritable sw) {
        Stanag4676EventWritable sw2 = new Stanag4676EventWritable();
        sw2.EventType = new IntWritable(sw.EventType.get());
        sw2.Geometry = new BytesWritable(sw.Geometry.copyBytes());
        sw2.DetailGeometry = new BytesWritable(sw.DetailGeometry.copyBytes());
        sw2.Image = new BytesWritable(sw.Image.copyBytes());
        sw2.MissionUUID = new Text(sw.MissionUUID.toString());
        sw2.MissionName = new Text(sw.MissionName.toString());
        sw2.MissionNumFrames = new IntWritable(sw.MissionNumFrames.get());
        sw2.TrackNumber = new Text(sw.TrackNumber.toString());
        sw2.TrackUUID = new Text(sw.TrackUUID.toString());
        sw2.TrackStatus = new Text(sw.TrackStatus.toString());
        sw2.TrackClassification = new Text(sw.TrackClassification.toString());
        sw2.TrackItemUUID = new Text(sw.TrackItemUUID.toString());
        sw2.TrackPointSource = new Text(sw.TrackPointSource.toString());
        sw2.TimeStamp = new LongWritable(sw.TimeStamp.get());
        sw2.EndTimeStamp = new LongWritable(sw.EndTimeStamp.get());
        sw2.Speed = new DoubleWritable(sw.Speed.get());
        sw2.Course = new DoubleWritable(sw.Course.get());
        sw2.TrackItemClassification = new Text(sw.TrackItemClassification.toString());
        sw2.Latitude = new DoubleWritable(sw.Latitude.get());
        sw2.Longitude = new DoubleWritable(sw.Longitude.get());
        sw2.Elevation = new DoubleWritable(sw.Elevation.get());
        sw2.DetailLatitude = new DoubleWritable(sw.DetailLatitude.get());
        sw2.DetailLongitude = new DoubleWritable(sw.DetailLongitude.get());
        sw2.DetailElevation = new DoubleWritable(sw.DetailElevation.get());
        sw2.PixelRow = new IntWritable(sw.PixelRow.get());
        sw2.PixelColumn = new IntWritable(sw.PixelColumn.get());
        sw2.MotionEvent = new Text(sw.MotionEvent.toString());
        sw2.FrameNumber = new IntWritable(sw.FrameNumber.get());
        sw2.ObjectClass = new Text(sw.ObjectClass.toString());
        sw2.ObjectClassConf = new IntWritable(sw.ObjectClassConf.get());
        sw2.ObjectClassRel = new IntWritable(sw.ObjectClassRel.get());
        return sw2;
    }

    public void setTrackPointData(byte[] geometry, byte[] detailGeometry, byte[] image, String missionUUID, String trackNumber, String trackUUID, String trackStatus, String trackClassification, String trackItemUUID, String trackPointSource, long timeStamp, long endTimeStamp, double speed, double course, String trackItemClassification, double latitude, double longitude, double elevation, double detailLatitude, double detailLongitude, double detailElevation, int pixelRow, int pixelColumn, int frameNumber) {
        this.EventType = new IntWritable(0);
        this.Geometry = new BytesWritable(geometry);
        if (detailGeometry != null) {
            this.DetailGeometry = new BytesWritable(detailGeometry);
        }
        if (image != null) {
            this.Image = new BytesWritable(image);
        }
        this.MissionUUID = new Text(missionUUID);
        this.TrackNumber = new Text(trackNumber);
        this.TrackUUID = new Text(trackUUID);
        this.TrackStatus = new Text(trackStatus);
        this.TrackClassification = new Text(trackClassification);
        this.TrackItemUUID = new Text(trackItemUUID);
        this.TrackPointSource = new Text(trackPointSource);
        this.TimeStamp = new LongWritable(timeStamp);
        this.EndTimeStamp = new LongWritable(endTimeStamp);
        this.Speed = new DoubleWritable(speed);
        this.Course = new DoubleWritable(course);
        this.TrackItemClassification = new Text(trackItemClassification);
        this.Latitude = new DoubleWritable(latitude);
        this.Longitude = new DoubleWritable(longitude);
        this.Elevation = new DoubleWritable(elevation);
        this.DetailLatitude = new DoubleWritable(detailLatitude);
        this.DetailLongitude = new DoubleWritable(detailLongitude);
        this.DetailElevation = new DoubleWritable(detailElevation);
        this.PixelRow = new IntWritable(pixelRow);
        this.PixelColumn = new IntWritable(pixelColumn);
        this.FrameNumber = new IntWritable(frameNumber);
    }

    public void setMotionPointData(byte[] geometry, byte[] image, String missionUUID, String trackNumber, String trackUUID, String trackStatus, String trackClassification, String trackItemUUID, String trackPointSource, long timeStamp, long endTimeStamp, double speed, double course, String trackItemClassification, double latitude, double longitude, double elevation, int pixelRow, int pixelColumn, int frameNumber, String motionEvent) {
        this.EventType = new IntWritable(1);
        this.Geometry = new BytesWritable(geometry);
        if (image != null) {
            this.Image = new BytesWritable(image);
        }
        this.MissionUUID = new Text(missionUUID);
        this.TrackNumber = new Text(trackNumber);
        this.TrackUUID = new Text(trackUUID);
        this.TrackStatus = new Text(trackStatus);
        this.TrackClassification = new Text(trackClassification);
        this.TrackItemUUID = new Text(trackItemUUID);
        this.TrackPointSource = new Text(trackPointSource);
        this.TimeStamp = new LongWritable(timeStamp);
        this.EndTimeStamp = new LongWritable(endTimeStamp);
        this.Speed = new DoubleWritable(speed);
        this.Course = new DoubleWritable(course);
        this.TrackItemClassification = new Text(trackItemClassification);
        this.Latitude = new DoubleWritable(latitude);
        this.Longitude = new DoubleWritable(longitude);
        this.Elevation = new DoubleWritable(elevation);
        this.PixelRow = new IntWritable(pixelRow);
        this.PixelColumn = new IntWritable(pixelColumn);
        this.FrameNumber = new IntWritable(frameNumber);
        this.MotionEvent = new Text(motionEvent);
    }

    public void setTrackObjectClassData(long timeStamp, String objectClass, int objectConf, int objectRel) {
        this.EventType = new IntWritable(2);
        this.TimeStamp = new LongWritable(timeStamp);
        this.ObjectClass = new Text(objectClass);
        this.ObjectClassConf = new IntWritable(objectConf);
        this.ObjectClassRel = new IntWritable(objectRel);
    }

    public void setMissionFrameData(byte[] geometry, String missionUUID, int number, long timeStamp) {
        this.EventType = new IntWritable(3);
        this.Geometry = new BytesWritable(geometry);
        this.MissionUUID = new Text(missionUUID);
        this.FrameNumber = new IntWritable(number);
        this.TimeStamp = new LongWritable(timeStamp);
    }

    public void setMissionSummaryData(byte[] geometry, String missionUUID, String missionName, int missionNumFrames, long timeStamp, long endTimeStamp, String classification, String objectClass) {
        this.EventType = new IntWritable(4);
        this.Geometry = new BytesWritable(geometry);
        this.MissionUUID = new Text(missionUUID);
        this.MissionName = new Text(missionName);
        this.MissionNumFrames = new IntWritable(missionNumFrames);
        this.TimeStamp = new LongWritable(timeStamp);
        this.EndTimeStamp = new LongWritable(endTimeStamp);
        this.TrackClassification = new Text(classification);
        this.ObjectClass = new Text(objectClass);
    }

    public void readFields(DataInput in) throws IOException {
        this.EventType.readFields(in);
        this.Geometry.readFields(in);
        this.DetailGeometry.readFields(in);
        this.Image.readFields(in);
        this.MissionUUID.readFields(in);
        this.MissionName.readFields(in);
        this.MissionNumFrames.readFields(in);
        this.TrackNumber.readFields(in);
        this.TrackUUID.readFields(in);
        this.TrackStatus.readFields(in);
        this.TrackClassification.readFields(in);
        this.TrackItemUUID.readFields(in);
        this.TrackPointSource.readFields(in);
        this.TimeStamp.readFields(in);
        this.EndTimeStamp.readFields(in);
        this.Speed.readFields(in);
        this.Course.readFields(in);
        this.TrackItemClassification.readFields(in);
        this.Latitude.readFields(in);
        this.Longitude.readFields(in);
        this.Elevation.readFields(in);
        this.DetailLatitude.readFields(in);
        this.DetailLongitude.readFields(in);
        this.DetailElevation.readFields(in);
        this.PixelRow.readFields(in);
        this.PixelColumn.readFields(in);
        this.FrameNumber.readFields(in);
        this.MotionEvent.readFields(in);
        this.ObjectClass.readFields(in);
        this.ObjectClassConf.readFields(in);
        this.ObjectClassRel.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        this.EventType.write(out);
        this.Geometry.write(out);
        this.DetailGeometry.write(out);
        this.Image.write(out);
        this.MissionUUID.write(out);
        this.MissionName.write(out);
        this.MissionNumFrames.write(out);
        this.TrackNumber.write(out);
        this.TrackUUID.write(out);
        this.TrackStatus.write(out);
        this.TrackClassification.write(out);
        this.TrackItemUUID.write(out);
        this.TrackPointSource.write(out);
        this.TimeStamp.write(out);
        this.EndTimeStamp.write(out);
        this.Speed.write(out);
        this.Course.write(out);
        this.TrackItemClassification.write(out);
        this.Latitude.write(out);
        this.Longitude.write(out);
        this.Elevation.write(out);
        this.DetailLatitude.write(out);
        this.DetailLongitude.write(out);
        this.DetailElevation.write(out);
        this.PixelRow.write(out);
        this.PixelColumn.write(out);
        this.FrameNumber.write(out);
        this.MotionEvent.write(out);
        this.ObjectClass.write(out);
        this.ObjectClassConf.write(out);
        this.ObjectClassRel.write(out);
    }
}

