/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geowave.format.stanag4676.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.locationtech.geowave.core.index.StringUtils;
import org.locationtech.geowave.format.stanag4676.image.ImageChip;

public class ImageChipUtils {
    public static BufferedImage getImage(Image img, int targetPixelSize, int type) {
        int currentWidth = img.getWidth(null);
        int currentHeight = img.getHeight(null);
        int currentPixelSize = Math.max(currentWidth, currentHeight);
        double scaleFactor = (double)targetPixelSize / (double)currentPixelSize;
        return ImageChipUtils.getScaledImageOfType(img, (int)((double)currentWidth * scaleFactor), (int)((double)currentHeight * scaleFactor), type);
    }

    public static BufferedImage getScaledImageOfType(Image img, int width, int height, int type) {
        if (img instanceof BufferedImage && ((BufferedImage)img).getType() == type && img.getWidth(null) == width && img.getHeight(null) == height) {
            return (BufferedImage)img;
        }
        BufferedImage scaledImage = ImageChipUtils.toBufferedImage(img.getScaledInstance(width, height, 4), type);
        return scaledImage;
    }

    public static BufferedImage toBufferedImage(Image image, int type) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        Graphics g = bi.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bi;
    }

    public static byte[] getDataId(String mission, String trackId, long timeMillis) {
        return StringUtils.stringToBinary((String)(mission + "/" + trackId + "/" + timeMillis));
    }

    public static byte[] getTrackDataIdPrefix(String mission, String trackId) {
        return StringUtils.stringToBinary((String)(mission + "/" + trackId + "/"));
    }

    public static ImageChip fromDataIdAndValue(byte[] dataId, byte[] value) {
        String dataIdStr = StringUtils.stringFromBinary((byte[])dataId);
        String[] split = dataIdStr.split("/");
        return new ImageChip(split[0], split[1], Long.parseLong(split[2]), value);
    }
}

